<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSwmsAwnswersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('swms_awnswers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('swms_id')->nullable();
            $table->unsignedBigInteger('swms_question_id')->nullable();
            $table->text('answer')->nullable();
            $table->timestamps();
            $table->foreign('swms_question_id')->references('id')->on('swms_questions')->onDelete('cascade')->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('swms_awnswers');
    }
}
