<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMeetingNoteTablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('meeting_note_tables', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('meeting_id')->nullable();
            $table->unsignedBigInteger('meeting_note_id')->nullable();
            $table->string('name')->nullable();
            $table->string('activity')->nullable();
            $table->longText('building')->nullable();
            $table->longText('level')->nullable();
            $table->longText('area')->nullable();
            $table->longText('workfore_allocation')->nullable();
            $table->enum('del', ['0', '1'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('meeting_note_tables');
    }
}
