<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCouponsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupons', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('code')->nullable();
            $table->integer('discount')->nullable();
            $table->integer('limit')->nullable();
            $table->string('type')->nullable();
            $table->integer('minimum_spend')->nullable();
            $table->integer('maximum_spend')->nullable();
            $table->integer('limit_per_user')->nullable();
            $table->dateTime('expiry_date')->nullable();
            $table->json('included_plan')->nullable();
            $table->json('excluded_plan')->nullable();
            $table->string('description')->nullable();
            $table->integer('is_active')->nullable();
            $table->integer('is_deleted')->default(0); 

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupons');
    }
}
