<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSafetyAuditDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('safety_audit_details', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('safety_audit_id')->nullable();
            $table->integer('customer_id')->nullable(); 
            $table->integer('workspace_id')->nullable();
            $table->text('hazard_identified_details')->nullable();
            $table->text('action_taken_details')->nullable();
            $table->enum('delete', ['0', '1'])->default('0');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('safety_audit_details');
    }
}
