<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSafetyAuditReportImagesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('safety_audit_report_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('safety_audit_id')->nullable();
            $table->integer('customer_id')->nullable(); 
            $table->integer('workspace_id')->nullable();
            $table->unsignedBigInteger('safety_audit_details_id')->nullable();
            $table->string('image')->nullable();
            $table->integer('unsigned_images')->default(0);

            
            $table->enum('delete', ['0', '1'])->default('0');

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('safety_audit_report_images');
    }
}
