<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('referral_commission_payouts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('commission_id');
            $table->unsignedBigInteger('payout_id');
            $table->decimal('commission_amount', 10, 2); // Amount of this commission included in payout
            $table->enum('status', ['requested', 'completed', 'rejected'])->default('requested');
            $table->timestamp('included_at')->nullable(); // When commission was included in payout
            $table->timestamp('processed_at')->nullable(); // When payout was processed
            $table->text('notes')->nullable(); // Admin notes for this specific commission
            $table->timestamps();
            $table->unique(['commission_id', 'payout_id']);
            $table->index(['commission_id', 'status']);
            $table->index(['payout_id', 'status']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('referral_commission_payouts');
    }
};
