<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhsqSignatureTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whsq_signature', function (Blueprint $table) {
            $table->id();
            $table->integer('whsq_report_id')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('employee_id')->nullable();
            $table->boolean('is_site_employee')->nullable()->default(0);
            $table->text('signature')->nullable();
            $table->text('job_description')->nullable();
            $table->date('induction_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whsq_signature');
    }
} 