<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWHSQEPlansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('whsqe_plan', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('document_number');
            $table->string('revision_number')->nullable();
            $table->unsignedBigInteger('authorised_by');
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->text('address')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('whsqe_plan');
    }
}
