<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateWhsqReportsTable extends Migration
{
    public function up()
    {
        Schema::create('whsq_reports', function (Blueprint $table) {
            $table->id();
            // Footer data columns (merging WHSQFooter functionality)
            $table->string('document_title')->nullable();
            $table->integer('authorised_by')->nullable();
            $table->string('revision_number')->nullable();
            $table->string('document_number')->nullable();
            $table->date('revision_date')->nullable();
            $table->date('next_revision_date')->nullable();
            $table->unsignedBigInteger('site_id')->nullable();
            // Customer and workspace tracking
            $table->unsignedBigInteger('customer_id')->nullable();
            $table->unsignedBigInteger('workspace_id')->nullable();
            // Publish status
            $table->boolean('publish')->default(false);
            // User tracking
            $table->integer('created_by')->nullable();
            $table->integer('is_completed')->nullable();
            // Chain versioning columns
            $table->string('version', 10)->default('1.0');
            $table->integer('chain_id')->nullable();
            $table->integer('parent_report_id')->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamp('chain_created_at')->nullable();
            $table->timestamp('chain_updated_at')->nullable();
            $table->integer('approval_status')->default(0)->nullable();
            $table->enum('del', [0, 1])->default(0);
            $table->enum('is_published', [0, 1])->default(0);
            $table->integer('report_method')->default(0);
            $table->integer('send_by')->nullable();
            $table->string('sender_type')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('whsq_reports');
    }
}