<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateBankAccountsColumns extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('bank_accounts', function (Blueprint $table) {
            // Change account_number and contact_number columns from integer to string
            $table->string('account_number')->change();
            $table->string('contact_number')->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('bank_accounts', function (Blueprint $table) {
            // Revert the columns back to integer type if rolling back
            $table->integer('account_number')->change();
            $table->integer('contact_number')->change();
        });
    }
}
