<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddLinkToPermissionsModulesAndColumnsToPermissionsSubModules extends Migration
{
    public function up()
    {
        Schema::table('permissions_modules', function (Blueprint $table) {
            $table->string('link')->nullable()->after('priority');
        });

        Schema::table('permissions_sub_modules', function (Blueprint $table) {
            $table->string('link')->nullable()->after('module_id');
            $table->integer('priority')->nullable(0)->after('link');
            $table->string('image')->nullable()->after('priority');
        });
    }

    public function down()
    {
        Schema::table('permissions_modules', function (Blueprint $table) {
            $table->dropColumn('link');
        });

        Schema::table('permissions_sub_modules', function (Blueprint $table) {
            $table->dropColumn(['link', 'priority', 'image']);
        });
    }
}
