<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusToRosterTemplatesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::table('roster_templates', function (Blueprint $table) {
            $table->boolean('status')->default(1)->after('updated_at'); // 1 = active, 0 = inactive
        });
    }

    public function down(): void
    {
        Schema::table('roster_templates', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
}
