<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payrolls', function (Blueprint $table) {
            $table->id();
            $table->integer('employee_id')->nullable();
            $table->integer('pay_year')->nullable();
            $table->integer('pay_month')->nullable();
            $table->integer('basic_salary')->nullable();
            $table->float('working_hours')->nullable();
            $table->float('hours_spent')->nullable();
            $table->float('actual_working_hours')->nullable();
            $table->float('overtime_hours')->nullable();
            $table->integer('calculated_salary')->nullable();
            $table->integer('status')->nullable();
            $table->string('pdf_path')->nullable();
            $table->string('attendance_pdf_path')->nullable();
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->integer('created_by')->nullable();
            $table->timestamps();

            // Add indexes for better performance
            $table->index(['employee_id', 'customer_id', 'workspace_id']);
            $table->index(['pay_year', 'pay_month']);
            $table->index(['customer_id', 'workspace_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payrolls');
    }
}
