<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_diary_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('site_diary_id');
            $table->string('image');
            $table->integer('customer_id')->nullable();
            $table->integer('workspace_id')->nullable();
            $table->timestamps();
            
            // Foreign key constraint
            $table->foreign('site_diary_id')->references('id')->on('site_diaries')->onDelete('cascade');
            
            // Indexes for better performance
            $table->index(['customer_id', 'workspace_id']);
            $table->index('site_diary_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_diary_images');
    }
};