@php
  use Illuminate\Support\Facades\DB;
  use App\Models\User;
  
    // Default values
  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      font-family: 'Inter', sans-serif !important;
    }
    
    #email-body {
      min-width: 600px;
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
    }
    
    #email-header {
      padding: 18px 25px;
      background-color: #fff;
    }
    
    #email-content {
      padding: 42px 34px;
    }
    
    .greeting-section {
      font-size: 14px;
      margin-bottom: 18px;
    }
    
    .email-content-area p {
      font-size: 14px;
      margin-bottom: 15px;
      line-height: 1.5;
    }
    
    .pending-title {
      font-size: 20px;
      font-weight: 700;
      margin-bottom: 18px;
      color: #1f2937;
    }
    
    .order-details {
      background-color: #f9f9f9;
      padding: 20px;
      border-radius: 8px;
      margin-bottom: 20px;
      border-left: 4px solid #F59E0B;
    }
    
    .order-details p {
      margin-bottom: 8px;
      font-size: 14px;
    }
    
    .order-details strong {
      font-weight: 600;
      color: #374151;
    }
    
    .bank-details {
      background-color: #fef3c7;
      padding: 20px;
      border-radius: 8px;
      margin-bottom: 20px;
      border: 1px solid #f59e0b;
    }
    
    .bank-details h3 {
      margin-bottom: 12px;
      color: #d97706;
      font-size: 16px;
      font-weight: 600;
    }
    
    .bank-details p {
      margin-bottom: 8px;
      font-size: 14px;
    }
    
    .bank-details strong {
      font-weight: 600;
      color: #92400e;
    }
    
    .reference-highlight {
      background-color: #fed7aa;
      padding: 10px;
      border-radius: 5px;
      margin-top: 10px;
      border-left: 3px solid #ea580c;
    }
    
    .thank-you-section {
      margin-top: 25px;
      margin-bottom: 0;
      font-weight: 500;
    }
    
    #email-footer {
      margin-top: 20px;
    }
    
    #tagline-section {
      background-color: #EDEDED;
      padding: 16px;
      text-align: center;
      font-size: 13px;
      color: #6b7280;
    }
    
    .small-tagline {
      font-size: 13px;
      color: #6b7280;
      margin-bottom: 4px;
    }
    
    .big-tagline {
      font-size: 14px;
      color: #374151;
    }
    
    .big-tagline a {
      color: #787f83;
      font-weight: 600;
      text-decoration: none;
    }
    
    .big-tagline a:hover {
      text-decoration: underline;
    }
    
    .company-details {
      text-align: center;
      padding: 20px 0;
      background-color: #ffffff;
    }
    
    .footer-logo {
      height: 35px;
      margin-bottom: 10px;
      filter: invert(65%);
    }
    
    .company-title {
      font-size: 14px;
      font-weight: 600;
      color: #374151;
      margin-bottom: 5px;
    }
    
    .company-address-contact {
      color: #6b7280;
      font-size: 12px;
      line-height: 1.4;
    }
    
    .status-badge {
      display: inline-block;
      background-color: #fbbf24;
      color: #92400e;
      padding: 4px 8px;
      border-radius: 12px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
    }
  </style>
</head>
<body>
  <div id="email-body">
    <div id="email-header">
      @if(!empty($logoPath) && file_exists(public_path($logoPath)))
        <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
      @else
            <h2 style="color: white; margin: 0; font-weight: 600;">{{ $settingsData['company_company_name'] }}</h2>
      @endif
    </div>
    
    <div id="email-content">
      <div class="greeting-section">Hi, <b>{{ $name }}</b></div>
      
      <div class="email-content-area">
        <p class="pending-title">Your Bank Transfer Request is <span class="status-badge">Pending</span></p>
        
        <p>Thank you for your order. Your bank transfer request has been received and is currently pending approval. Our team will review your request and confirm your payment shortly.</p>
        
        <div class="order-details">
          <p><strong>Plan:</strong> {{ $plan_name }}</p>
          <p><strong>Order ID:</strong> {{ $order_id }}</p>
          <p><strong>Amount:</strong> {{ $price }} {{ $currency }}</p>
          <p><strong>Subscription Period:</strong> {{ $interval }} Month(s)</p>
        </div>
        
        <div class="bank-details">
          <h3>💳 Bank Transfer Instructions</h3>
          <p>Please make your payment to the following bank account:</p>
          <p><strong>Bank Name:</strong> example</p>
          <p><strong>Account Name:</strong> example</p>
          <p><strong>Account Number:</strong> example</p>
          
          <div class="reference-highlight">
            <p><strong>Payment Reference:</strong> {{ $order_id }}</p>
            <p style="font-size: 12px; color: #92400e; margin-top: 5px;">⚠️ Important: Please include this reference number with your payment</p>
          </div>
        </div>
        
        <p>Once your payment is confirmed, your account will be activated and you'll receive a confirmation email. This process typically takes <strong>1-2 business days</strong>.</p>
        
        <p>If you have any questions about your order or need assistance with the payment process, please don't hesitate to contact our customer support team.</p>
        
        <p class="thank-you-section">Thank you,<br>{{ $companyName }} Team</p>
      </div>
    </div>
    
    <div id="email-footer">
      <div id="tagline-section">
        <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
        <p class="big-tagline">For questions or support, contact 
          <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
        </p>
      </div>
      
      <div class="company-details">
        @if(!empty($logoPath) && file_exists(public_path($logoPath)))
          <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
        @endif
        <div class="company-title">{{ $companyName }}</div>
        <div class="company-address-contact">
          {{ $fullAddress }}<br>
          Call: {{ $companyPhone }}
        </div>
      </div>
    </div>
  </div>
</body>
</html>