@php
    use Illuminate\Support\Facades\DB;
    use App\Models\User;

    // Default values
    $logoPath = null;
    $companyName = env('APP_NAME', 'WMS');
    $companyAddress = '';
    $companyCity = '';
    $companyState = '';
    $companyPostCode = '';
    $companyCountry = '';
    $companyPhone = 'Contact Information';
    $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');

    // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
        $settings = DB::table('adminsettings')->where('customer_id', $admin->id)->get();

        // Transform into key-value pairs for easier access
        $settingsData = [];
        foreach ($settings as $setting) {
            $settingsData[$setting->key] = $setting->value;
        }

        // Get logo
        if (isset($settingsData['brand_logo_dark'])) {
            $logoPath = $settingsData['brand_logo_dark'];
        }

        // Get company information
        if (isset($settingsData['company_company_name'])) {
            $companyName = $settingsData['company_company_name'];
        }
        if (isset($settingsData['company_company_address'])) {
            $companyAddress = $settingsData['company_company_address'];
        }
        if (isset($settingsData['company_company_city'])) {
            $companyCity = $settingsData['company_company_city'];
        }
        if (isset($settingsData['company_company_state'])) {
            $companyState = $settingsData['company_company_state'];
        }
        if (isset($settingsData['company_company_post_code'])) {
            $companyPostCode = $settingsData['company_company_post_code'];
        }
        if (isset($settingsData['company_company_country'])) {
            $companyCountry = $settingsData['company_company_country'];
        }
        if (isset($settingsData['company_company_telephone'])) {
            $companyPhone = $settingsData['company_company_telephone'];
        }
        if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: linear-gradient(135deg, #fff 0%, #fff 100%);
            text-align: left;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h2 {
            color: black;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
        }

        #email-content {
            padding: 42px 34px;
            color: #333333;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
            color: #6b7280;
        }

        .welcome-title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 18px;
            color: #1f2937;
        }

        .account-details {
            background-color: #f0f9ff;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #22c55e;
        }

        .account-details h3 {
            color: #22c55e;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .account-details p {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .account-details strong {
            color: #22c55e;
        }

        .account-summary {
            background-color: #f9fafb;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #e5e7eb;
        }

        .account-summary h3 {
            color: #374151;
            margin-bottom: 15px;
            font-size: 16px;
            font-weight: 600;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
            border-bottom: 1px solid #f3f4f6;
        }

        .summary-row:last-child {
            border-bottom: none;
        }

        .summary-label {
            font-weight: 500;
            color: #4b5563;
        }

        .summary-value {
            font-weight: 600;
            color: #1f2937;
        }

        .login-button {
            display: inline-block;
            background-color: #22C55E;
            color: white;
            text-decoration: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: 600;
            margin: 15px 0;
            font-size: 14px;
        }

        .login-button:hover {
            background-color: #16a34a;
        }

        .welcome-notice {
            background-color: #fffbeb;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #fbbf24;
        }

        .welcome-notice p {
            color: #92400e;
            margin-bottom: 5px;
        }

        .welcome-notice strong {
            color: #78350f;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.6;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 25px;
            margin-bottom: 0;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
      background-color: #EDEDED;
      padding: 16px;
      text-align: center;
      font-size: 13px;
      color: #6b7280;
    }
        .small-tagline {
            font-size: 13px;
            color: #6b7280;
            margin-bottom: 5px;
        }

        .big-tagline {
            font-size: 14px;
            color: #374151;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .company-details {
            text-align: center;
            padding: 20px 0;
            background-color: #ffffff;
        }
        
        .footer-logo {
            height: 35px;
            margin-bottom: 12px;
        }

        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.4;
        }
    </style>
</head>
<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
                <h2>{{ $companyName }}</h2>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <strong>{{$name}}</strong>
            </div>

            <div class="welcome-title">
                🎉 Welcome to {{ $companyName }}!
            </div>

            <div class="account-details">
                <h3>🔐 Account Information</h3>
                <p><strong>Name:</strong> {{$name}}</p>
                <p><strong>Email:</strong> {{$email}}</p>
                <p><strong>Workspace:</strong> {{$workspace_name}}</p>
                @if(isset($password))
                <p><strong>Password:</strong> {{$password}}</p>
                <p><small style="color: #6b7280;">(We recommend changing this password after your first login)</small></p>
                @endif
            </div>

            <div class="account-summary">
                <h3>📋 Account Summary</h3>
                <div class="summary-row">
                    <span class="summary-label">Account Status:</span>
                    <span class="summary-value">Active</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Account Type:</span>
                    <span class="summary-value">Customer</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Created Date:</span>
                    <span class="summary-value">{{ date('M d, Y') }}</span>
                </div>
                @if(isset($workspace_name))
                <div class="summary-row">
                    <span class="summary-label">Workspace:</span>
                    <span class="summary-value">{{ $workspace_name }}</span>
                </div>
                @endif
            </div>

            @if(isset($demo_data_created) && $demo_data_created)
            <div class="welcome-notice" style="background-color: #ecfdf5; border-color: #10b981;">
                <p><strong>🎯 Demo Data Imported:</strong> We've pre-populated your workspace with sample data to help you get started quickly!</p>
                <p>Your workspace now includes sample clients, employees, projects, sites, and other essential data to help you understand how the system works.</p>
            </div>
            @endif

            <div class="welcome-notice">
                <p><strong>🔗 Quick Access:</strong> Use the login button below to access your account.</p>
                <p>Save your login credentials in a secure location for future reference.</p>
            </div>

            <div class="email-content-area">
                <p>Your account has been successfully created. You can now log in to access our services and features.</p>
                
                <p>To get started, please click the button below to log in to your account:</p>
                <a href="{{ env('FRONTEND_URL') }}" class="login-button">Login to Your Account</a>
                
                <p>If you have any questions or need assistance, feel free to contact our support team.</p>
                
                <p><strong>Important:</strong> Please keep your login credentials secure and do not share them with anyone.</p>
                
                <p class="thank-you">Thank you,<br>{{ $companyName }} Team</p>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact 
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>
            
            <div class="company-details">
                @if(!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    @if ($companyAddress)
                        {{ $companyAddress }}
                    @endif
                    @if ($companyCity || $companyState || $companyPostCode)
                        @if ($companyAddress), @endif{{ $companyCity }}{{ $companyState ? ', ' . $companyState : '' }}{{ $companyPostCode ? ' ' . $companyPostCode : '' }}
                    @endif
                    @if ($companyCountry)
                        @if ($companyAddress || $companyCity || $companyState || $companyPostCode), @endif{{ $companyCountry }}
                    @endif
                    <br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>
</html> 