@php
    use App\Services\CompanyEmailDetails;

    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails();

    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
    $fullAddress = $companyDetails['companyAddressFull'];
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            font-family: 'Inter', sans-serif !important;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
        }

        #email-header {
            padding: 18px 25px;
            background: #fff !important;
        }

        #email-content {
            padding: 42px 34px;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.5;
        }

        .invitation-title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 18px;
            color: #1f2937;
        }

        .credentials-container {
            background-color: #f0fdf4;
            padding: 30px 20px;
            border-radius: 8px;
            margin: 25px 0;
            border: 2px solid #22C55E;
        }

        .credentials-label {
            font-size: 12px;
            color: #16a34a;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 10px;
        }

        .credentials-item {
            margin-bottom: 15px;
        }

        .credentials-item-label {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .credentials-item-value {
            font-size: 16px;
            color: #15803d;
            background-color: #dcfce7;
            padding: 10px;
            border-radius: 4px;
            font-family: 'Inter', monospace;
        }

        .login-button {
            display: inline-block;
            margin-top: 15px;
            padding: 12px 24px;
            background-color: #22C55E;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            font-weight: 600;
            font-size: 14px;
            text-align: center;
        }

        .security-warning {
            background-color: #fef3c7;
            padding: 15px;
            border-radius: 8px;
            margin: 20px 0;
            border-left: 4px solid #f59e0b;
            font-size: 14px;
            color: #92400e;
        }

        .security-warning strong {
            font-weight: 600;
            color: #d97706;
        }

        .thank-you-section {
            margin-top: 25px;
            margin-bottom: 0;
            font-weight: 500;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 16px;
            text-align: center;
            font-size: 13px;
            color: #6b7280;
        }

        .small-tagline {
            font-size: 13px;
            color: #6b7280;
            margin-bottom: 4px;
        }

        .big-tagline {
            font-size: 14px;
            color: #374151;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .big-tagline a:hover {
            text-decoration: underline;
        }

        .company-details {
            text-align: center;
            padding: 20px 0;
            background-color: #ffffff;
        }

        .footer-logo {
            height: 35px;
            margin-bottom: 10px;
            filter: invert(65%);
        }

        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.4;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
                <h2 style="color: black; margin: 0; font-weight: 600;">{{ $companyName }}</h2>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">Hello!</div>

            <div class="email-content-area">
                <p class="invitation-title">🎉 Welcome to {{ $companyName }}</p>

                <p>You have been invited to join {{ $companyName }} as an employee. We've created an account for you
                    with the following credentials:</p>

                <div class="credentials-container">
                    <div class="credentials-label">Your Login Credentials</div>

                    <div class="credentials-item">
                        <div class="credentials-item-label">Email Address:</div>
                        <div class="credentials-item-value">{{ $email }}</div>
                    </div>

                    <div class="credentials-item">
                        <div class="credentials-item-label">Temporary Password:</div>
                        <div class="credentials-item-value">{{ $password }}</div>
                    </div>

                    @if (env('APP_LINK_APPSTORE'))
                        <div class="credentials-item">
                            <div class="credentials-item-label">Download App:</div>
                            <div class="credentials-item-value">
                                <a href="{{ env('APP_LINK_APPSTORE') }}"
                                    style="text-decoration: none; display: inline-block; margin: 5px 0;">
                                    <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                        alt="Get it on Google Play"
                                        style="height: 40px; width: auto; border-radius: 4px; border: 1px solid #e5e7eb;">
                                </a>
                                <br>
                                <small style="font-size: 10px; color: #6b7280;">
                                    Tap the badge above to download our mobile app
                                </small>
                            </div>
                        </div>
                    @endif
                </div>

                <div class="security-warning">
                    <strong>🔒 Security Notice:</strong> For security reasons, we recommend changing your password after
                    your first login. Keep your credentials secure and do not share them with others.
                </div>

                <p>If you have any questions about your account or need assistance, please contact your administrator or
                    our support team for help.</p>

                <p class="thank-you-section">Welcome aboard!<br>{{ $companyName }} Team</p>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    {{ $fullAddress }}<br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>
