@php
use App\Services\CompanyEmailDetails;

$companyDetails = CompanyEmailDetails::getCompanyEmailDetails();

// Extract variables for easier use in template
$logoPath = $companyDetails['logoPath'];
$companyName = $companyDetails['companyName'];
$companyAddress = $companyDetails['companyAddress'];
$companyCity = $companyDetails['companyCity'];
$companyState = $companyDetails['companyState'];
$companyPostCode = $companyDetails['companyPostCode'];
$companyCountry = $companyDetails['companyCountry'];
$companyPhone = $companyDetails['companyPhone'];
$companyEmail = $companyDetails['companyEmail'];
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: linear-gradient(135deg, #fff 0%, #fff 100%);
            text-align: left;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h2 {
            color: black;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
        }

        #email-content {
            padding: 20px 20px;
            color: #333333;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
            color: #6b7280;
        }

        .onboarding-title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 18px;
            color: #1f2937;
        }

        .welcome-section {
            background-color: #f0f9ff;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 12px;
            border-left: 4px solid #22c55e;
        }

        .welcome-section h3 {
            color: #22c55e;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .welcome-section p {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .welcome-section strong {
            color: #22c55e;
        }

        .employee-details {
            background-color: #f9fafb;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 12px;
            border: 1px solid #e5e7eb;
        }

        .employee-details h3 {
            color: #374151;
            margin-bottom: 8px;
            font-size: 15px;
            font-weight: 600;
        }

        .detail-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 13px;
        }

        .detail-table td {
            padding: 4px 6px;
            border-bottom: 1px solid #f3f4f6;
        }

        .detail-table tr:last-child td {
            border-bottom: none;
        }

        .detail-label {
            font-weight: 500;
            color: #4b5563;
            width: 35%;
        }

        .detail-value {
            font-weight: 600;
            color: #1f2937;
            width: 65%;
        }

        .schedule-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
            margin-top: 8px;
        }

        .schedule-table th {
            background-color: #f3f4f6;
            color: #374151;
            font-weight: 600;
            padding: 6px 4px;
            text-align: left;
            border-bottom: 2px solid #e5e7eb;
            font-size: 11px;
        }

        .schedule-table td {
            padding: 4px;
            border-bottom: 1px solid #f3f4f6;
            vertical-align: top;
            font-size: 11px;
        }

        .schedule-table tr:nth-child(even) {
            background-color: #f9fafb;
        }

        .schedule-table tr:hover {
            background-color: #f0f9ff;
        }

        .important-notice {
            background-color: #fffbeb;
            padding: 10px;
            border-radius: 6px;
            margin-bottom: 12px;
            border: 1px solid #fbbf24;
        }

        .important-notice p {
            color: #92400e;
            margin-bottom: 5px;
        }

        .important-notice strong {
            color: #78350f;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.6;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 25px;
            margin-bottom: 0;
        }

        .login-credentials {
            background-color: #fef3c7;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 12px;
            border: 1px solid #f59e0b;
        }

        .login-credentials h3 {
            color: #d97706;
            margin-bottom: 8px;
            font-size: 15px;
            font-weight: 600;
        }

        .next-steps {
            background-color: #ecfdf5;
            padding: 12px;
            border-radius: 6px;
            margin-bottom: 12px;
            border: 1px solid #22c55e;
        }

        .next-steps h3 {
            color: #22c55e;
            margin-bottom: 8px;
            font-size: 15px;
            font-weight: 600;
        }

        .next-steps ul {
            margin-left: 20px;
        }

        .next-steps li {
            font-size: 14px;
            margin-bottom: 8px;
            color: #1f2937;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
            background-color: #EDEDED;
            padding: 16px;
            text-align: center;
            font-size: 13px;
            color: #6b7280;
        }

        .small-tagline {
            font-size: 13px;
            color: #6b7280;
            margin-bottom: 5px;
        }

        .big-tagline {
            font-size: 14px;
            color: #374151;
            font-weight: 700;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .company-details {
            text-align: center;
            padding: 20px;
            background-color: #ffffff;
        }

        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.4;
        }



        .footer-logo {
            height: 54px;
            width: auto;
        }
    </style>
</head>

<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
            <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
            <h3>{{ $companyName }}</h2>
                @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <span style="font-weight: 600; font-size: 18px;">{{ $employee->first_name ?? '' }}
                    {{ $employee->last_name ?? '' }}</span>
            </div>

            <div class="onboarding-title">
                🎉 Welcome to {{ $companyName }}!
            </div>

            <div class="welcome-section">
                <h3>✅ Registration Complete</h3>
                <p><strong>Status:</strong> Your employee onboarding has been successfully completed!</p>
                <p><strong>Email:</strong> {{ $employeeCompany->employee_email ?? 'N/A' }}</p>
                <p><strong>Team:</strong> {{ $teamName ?? 'N/A' }}</p>
            </div>

            <div class="employee-details">
                <h3>👤 Your Details</h3>
                <table class="detail-table">
                    <tr>
                        <td class="detail-label">Full Name:</td>
                        <td class="detail-value">{{ $employee->first_name ?? '' }} {{ $employee->middle_name ?? '' }}
                            {{ $employee->last_name ?? '' }}
                        </td>
                    </tr>
                    @if (isset($employeeCompany->job_title) && $employeeCompany->job_title)
                    <tr>
                        <td class="detail-label">Job Title:</td>
                        <td class="detail-value">{{ $employeeCompany->job_title }}</td>
                    </tr>
                    @endif

                    @if (isset($workerType->title) && $workerType->title)
                    <tr>
                        <td class="detail-label">Worker Type:</td>
                        <td class="detail-value">{{ $workerType->title }}</td>
                    </tr>
                    @endif

                    <tr>
                        <td class="detail-label">Mobile:</td>
                        <td class="detail-value">{{ $employee->mobile ?? 'N/A' }}</td>
                    </tr>
                    @if (isset($employee->suburb))
                    <tr>
                        <td class="detail-label">Location:</td>
                        <td class="detail-value">{{ $employee->suburb }}, {{ $employee->state ?? '' }}</td>
                    </tr>
                    @endif
                </table>
            </div>

            @if (isset($rosterDetails) && (!empty($rosterDetails['bulk_schedule']) || !empty($rosterDetails['individual_shifts'])))
            <div class="employee-details">
                <h3>📅 Your Work Schedule</h3>

                @if (isset($rosterDetails['bulk_schedule']) && !empty($rosterDetails['bulk_schedule']))
                <!-- Bulk Schedule Overview -->
                <div
                    style="background-color: #ecfdf5; padding: 12px; border-radius: 6px; margin-bottom: 12px; border: 2px solid #22c55e;">
                    <h4 style="color: #22c55e; margin-bottom: 8px; font-size: 15px; font-weight: 600;">📋
                        Schedule Overview</h4>
                    <table class="detail-table">
                        <tr>
                            <td class="detail-label">📅 Period:</td>
                            <td class="detail-value">
                                {{ $rosterDetails['bulk_schedule']['schedule_period_start'] }} to
                                {{ $rosterDetails['bulk_schedule']['schedule_period_end'] }}
                            </td>
                        </tr>
                        <tr>
                            <td class="detail-label">📆 Days:</td>
                            <td class="detail-value">{{ $rosterDetails['bulk_schedule']['working_days'] }}
                                ({{ $rosterDetails['bulk_schedule']['total_days'] }} total)</td>
                        </tr>
                        <tr>
                            <td class="detail-label">⏰ Time:</td>
                            <td class="detail-value">{{ $rosterDetails['bulk_schedule']['daily_start_time'] }}
                                - {{ $rosterDetails['bulk_schedule']['daily_end_time'] }}@if (isset($rosterDetails['bulk_schedule']['daily_break_minutes']) &&
                                $rosterDetails['bulk_schedule']['daily_break_minutes'] > 0)
                                ({{ $rosterDetails['bulk_schedule']['daily_break_minutes'] }}min break)
                                @endif
                            </td>
                        </tr>
                        @if (isset($rosterDetails['bulk_schedule']['shift_notes']) && !empty($rosterDetails['bulk_schedule']['shift_notes']))
                        <tr>
                            <td class="detail-label">📝 Notes:</td>
                            <td class="detail-value">{{ $rosterDetails['bulk_schedule']['shift_notes'] }}
                            </td>
                        </tr>
                        @endif
                    </table>
                </div>
                @endif

                @if (isset($rosterDetails['individual_shifts']) && !empty($rosterDetails['individual_shifts']))
                <!-- Individual Shifts Table - Limited to next 3 shifts -->
                <h4 style="color: #374151; margin-bottom: 8px; font-size: 15px; font-weight: 600;">📋 Next 3
                    Shifts</h4>

                <table class="schedule-table">
                    <thead>
                        <tr>
                            <th>📅 Date</th>
                            <th>⏰ Time</th>
                            <th>☕ Break</th>
                            <th>🕒 Hours</th>
                            <th>📝 Notes</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach (array_slice($rosterDetails['individual_shifts'], 0, 3) as $index => $roster)
                        <tr>
                            <td><strong>{{ $roster['schedule_date'] }}</strong><br><small>{{ $roster['day_name'] }}</small>
                            </td>
                            <td>{{ $roster['start_time'] }} - {{ $roster['end_time'] }}</td>
                            <td>{{ isset($roster['break_minutes']) && $roster['break_minutes'] > 0 ? $roster['break_minutes'] . ' min' : '-' }}
                            </td>
                            <td>{{ isset($roster['working_hours']) && $roster['working_hours'] > 0 ? number_format($roster['working_hours'] / 60, 1) . 'h' : '-' }}
                            </td>
                            <td>{{ isset($roster['shift_notes']) && !empty($roster['shift_notes']) ? $roster['shift_notes'] : '-' }}
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
                @endif
            </div>
            @endif

            @if (isset($password))
            <div class="login-credentials">
                <h3>🔐 Your Login Credentials</h3>
                <table class="detail-table">
                    <tr>
                        <td class="detail-label">Email:</td>
                        <td class="detail-value">{{ $employeeCompany->employee_email ?? 'N/A' }}</td>
                    </tr>
                    <tr>
                        <td class="detail-label">Password:</td>
                        <td class="detail-value"
                            style="font-family: monospace; background-color: #f3f4f6; padding: 4px 8px; border-radius: 4px;">
                            {{ $password }}
                        </td>
                    </tr>
                    @if (env('APP_LINK_APPSTORE'))
                    <tr>
                        <td class="detail-label">Download App:</td>
                        <td class="detail-value">
                            <a href="{{ env('APP_LINK_APPSTORE') }}"
                                style="text-decoration: none; display: inline-block; margin: 5px 0;">
                                <img src="https://play.google.com/intl/en_us/badges/static/images/badges/en_badge_web_generic.png"
                                    alt="Get it on Google Play"
                                    style="height: 40px; width: auto; border-radius: 4px; border: 1px solid #e5e7eb;">
                            </a>
                            <br>
                            <small style="font-size: 10px; color: #6b7280;">
                                Tap the badge above to download our mobile app
                            </small>
                        </td>
                    </tr>
                    @endif
                </table>
            </div>
            @endif

            <div class="next-steps">
                <h3>📋 Next Steps & Important Info</h3>
                <ul style="font-size: 13px;">
                    @if (env('APP_LINK_APPSTORE'))
                    <li>Download the mobile app using the Google Play Store badge above for easy access</li>
                    @endif
                    @if (isset($rosterDetails) && (!empty($rosterDetails['bulk_schedule']) || !empty($rosterDetails['individual_shifts'])))
                    <li>Review your work schedule and arrive on time</li>
                    @endif
                    <li>Keep contact information updated & check emails regularly</li>
                    <li>Contact HR for questions about employment or schedule</li>
                </ul>
                <div
                    style="background-color: #fffbeb; padding: 8px; border-radius: 4px; border: 1px solid #fbbf24; margin-top: 10px;">
                    <p style="color: #92400e; font-size: 12px; margin: 0;">
                        <strong>🔒 Important:</strong> Save this email and keep credentials secure.
                        @if (isset($password))
                        Change password after first login.
                        @endif
                        Your onboarding is complete with login access confirmed.
                    </p>
                </div>
                <p style="font-size: 13px; margin-top: 15px; margin-bottom: 0;">
                    <strong>Welcome aboard!</strong> We're excited to have you join {{ $companyName }}.<br>
                    <span style="color: #6b7280;">Best regards, {{ $companyName }} Team</span>
                </p>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>

            <div class="company-details">
                @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    @if ($companyAddress)
                    {{ $companyAddress }}
                    @endif
                    @if ($companyCity || $companyState || $companyPostCode)
                    @if ($companyAddress)
                    ,
                    @endif
                    {{ $companyCity }}{{ $companyState ? ', ' . $companyState : '' }}{{ $companyPostCode ? ' ' . $companyPostCode : '' }}
                    @endif
                    @if ($companyCountry)
                    @if ($companyAddress || $companyCity || $companyState || $companyPostCode)
                    ,
                    @endif{{ $companyCountry }}
                    @endif
                    <br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>

</html>