@php
    use App\Services\CompanyEmailDetails;

    // Get company details using global helper function
    $companyDetails = CompanyEmailDetails::getCompanyEmailDetails();
    
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
@endphp

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ $subject }}</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet">
    <style>
        * {
            padding: 0;
            margin: 0;
            font-family: 'Inter', sans-serif !important;
            box-sizing: border-box;
        }

        body {
            background-color: #f8f9fa;
            padding: 20px 0;
        }

        #email-body {
            min-width: 600px;
            width: 600px;
            max-width: 600px;
            margin: 0 auto;
            background-color: #ffffff;
            font-family: 'Inter', sans-serif !important;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            overflow: hidden;
        }

        #email-header {
            padding: 18px 25px;
            background: linear-gradient(135deg, #fff 0%, #fff 100%);
            text-align: left;
        }

        #email-header img {
            height: 54px;
            width: auto;
            display: inline-block;
        }

        #email-header h2 {
            color: black;
            margin: 0;
            font-weight: 700;
            font-size: 24px;
        }

        #email-content {
            padding: 42px 34px;
            color: #333333;
        }

        .greeting-section {
            font-size: 14px;
            margin-bottom: 18px;
            color: #6b7280;
        }

        .leave-title {
            font-size: 20px;
            font-weight: 700;
            margin-bottom: 18px;
            color: #1f2937;
        }

        .leave-status {
            background-color: #fffbeb;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #f59e0b;
        }

        .leave-status h3 {
            color: #f59e0b;
            margin-bottom: 8px;
            font-size: 16px;
        }

        .leave-status p {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .leave-status strong {
            color: #f59e0b;
        }

        .leave-summary {
            background-color: #f9fafb;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #e5e7eb;
        }

        .leave-summary h3 {
            color: #374151;
            margin-bottom: 15px;
            font-size: 16px;
            font-weight: 600;
        }

        .summary-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding: 5px 0;
            border-bottom: 1px solid #f3f4f6;
        }

        .summary-row:last-child {
            border-bottom: none;
            font-weight: 600;
            color: #f59e0b;
            font-size: 16px;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #fef3c7;
        }

        .summary-label {
            font-weight: 500;
            color: #4b5563;
        }

        .summary-value {
            font-weight: 600;
            color: #1f2937;
        }

        .important-notice {
            background-color: #fef2f2;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #f87171;
        }

        .important-notice p {
            color: #991b1b;
            margin-bottom: 5px;
        }

        .important-notice strong {
            color: #7f1d1d;
        }

        .email-content-area p {
            font-size: 14px;
            margin-bottom: 15px;
            line-height: 1.6;
        }

        .thank-you {
            font-weight: 600;
            color: #374151;
            margin-top: 25px;
            margin-bottom: 0;
        }

        #email-footer {
            margin-top: 20px;
        }

        #tagline-section {
        background-color: #EDEDED;
        padding: 16px;
        text-align: center;
        font-size: 13px;
        color: #6b7280;
        }

        .small-tagline {
            font-size: 13px;
            color: #6b7280;
            margin-bottom: 5px;
        }

        .big-tagline {
            font-size: 14px;
            color: #374151;
            font-weight: 700;
        }

        .big-tagline a {
            color: #787f83;
            font-weight: 600;
            text-decoration: none;
        }

        .company-details {
            text-align: center;
            padding: 20px;
            background-color: #ffffff;
        }

        .company-title {
            font-size: 14px;
            font-weight: 600;
            color: #374151;
            margin-bottom: 5px;
        }

        .company-address-contact {
            color: #6b7280;
            font-size: 12px;
            line-height: 1.4;
        }
        .footer-logo{
            height: 54px;
            width: auto;
        }
    </style>
</head>
<body>
    <div id="email-body">
        <div id="email-header">
            @if (!empty($logoPath) && file_exists(public_path($logoPath)))
                <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
            @else
                <h2>{{ $companyName }}</h2>
            @endif
        </div>

        <div id="email-content">
            <div class="greeting-section">
                Hello, <strong>{{ $employeeName ?? 'Team Member' }}</strong>
            </div>

            <div class="leave-title">
                📋 Leave Request Notification
            </div>

            <div class="leave-status">
                <h3>🌟 Request Status</h3>
                <p><strong>Status:</strong> Submitted for Approval</p>
                <p><strong>Request ID:</strong> #{{ $leaveRequestId ?? 'N/A' }}</p>
                <p><strong>Submitted On:</strong> {{ date('F d, Y') }}</p>
            </div>

            <div class="leave-summary">
                <h3>📅 Leave Details</h3>
                <div class="summary-row">
                    <span class="summary-label">Employee Name:</span>
                    <span class="summary-value">{{ $employeeName ?? 'N/A' }}</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Leave Type:</span>
                    <span class="summary-value">{{ $leavePackageName ?? 'N/A' }}</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Start Date:</span>
                    <span class="summary-value">{{ $startDate ?? 'N/A' }}</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">End Date:</span>
                    <span class="summary-value">{{ $endDate ?? 'N/A' }}</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Duration:</span>
                    <span class="summary-value">{{ $numberOfDays ?? 'N/A' }} day(s)</span>
                </div>
                @if(isset($teamName) && $teamName)
                <div class="summary-row">
                    <span class="summary-label">Team:</span>
                    <span class="summary-value">{{ $teamName }}</span>
                </div>
                @endif
            </div>

            @if(isset($reason) && $reason)
            <div class="leave-summary">
                <h3>📝 Reason for Leave</h3>
                <p style="margin: 0; color: #4b5563; line-height: 1.6;">{{ $reason }}</p>
            </div>
            @endif

            <div class="important-notice">
                <p><strong>⚠️ Important:</strong> This leave request requires approval from your supervisor.</p>
                <p>You will be notified once your request has been reviewed and a decision has been made.</p>
                <p>If you need to make any changes to this request, please contact your supervisor immediately.</p>
            </div>

            <div class="email-content-area">
                @if($emailType === 'employee')
                    <p>Your leave request has been successfully submitted and is now pending approval from your supervisor.</p>
                    
                    <p>Please ensure you have completed all necessary handover procedures and informed relevant team members about your planned absence.</p>
                    
                    <p>You will receive another notification once your request has been reviewed. If you have any questions or need to make changes to this request, please contact your supervisor or HR department immediately.</p>
                @elseif($emailType === 'supervisor')
                    <p>A leave request has been submitted by {{ $employeeName ?? 'an employee' }} and requires your review and approval.</p>
                    
                    <p>Please review the leave details above and approve or reject this request through the system. Consider the team's workload and any planned projects during the requested period.</p>
                    
                    <p>To take action on this request, please log into your dashboard or contact the employee directly if you need additional information.</p>
                @elseif($emailType === 'cc')
                    <p>This is a notification that {{ $employeeName ?? 'an employee' }} has submitted a leave request for your information.</p>
                    
                    <p>Please review the leave details above and plan accordingly for any team adjustments that may be needed during this period.</p>
                    
                    <p>If you have any concerns about this leave request, please contact the supervisor or the employee directly.</p>
                @else
                    <p>A leave request has been submitted by {{ $employeeName ?? 'an employee' }} for your information.</p>
                    
                    <p>Please review the leave details above and take appropriate action if required.</p>
                @endif

                <p class="thank-you">Best regards,<br>{{ $companyName }} Team</p>
            </div>
        </div>

        <div id="email-footer">
            <div id="tagline-section">
                <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
                <p class="big-tagline">For questions or support, contact 
                    <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
                </p>
            </div>
            
            <div class="company-details">
                @if(!empty($logoPath) && file_exists(public_path($logoPath)))
                    <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
                @endif
                <div class="company-title">{{ $companyName }}</div>
                <div class="company-address-contact">
                    @if ($companyAddress)
                        {{ $companyAddress }}
                    @endif
                    @if ($companyCity || $companyState || $companyPostCode)
                        @if ($companyAddress), @endif{{ $companyCity }}{{ $companyState ? ', ' . $companyState : '' }}{{ $companyPostCode ? ' ' . $companyPostCode : '' }}
                    @endif
                    @if ($companyCountry)
                        @if ($companyAddress || $companyCity || $companyState || $companyPostCode), @endif{{ $companyCountry }}
                    @endif
                    <br>
                    Call: {{ $companyPhone }}
                </div>
            </div>
        </div>
    </div>
</body>
</html>