@php
   use App\Services\CompanyEmailDetails;

   $companyDetails = CompanyEmailDetails::getCompanyEmailDetails($customer_id);
    
    // Extract variables for easier use in template
    $logoPath = $companyDetails['logoPath'];
    $companyName = $companyDetails['companyName'];
    $companyAddress = $companyDetails['companyAddress'];
    $companyCity = $companyDetails['companyCity'];
    $companyState = $companyDetails['companyState'];
    $companyPostCode = $companyDetails['companyPostCode'];
    $companyCountry = $companyDetails['companyCountry'];
    $companyPhone = $companyDetails['companyPhone'];
    $companyEmail = $companyDetails['companyEmail'];
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      margin: 0;
      padding: 0;
      font-family: 'Inter', sans-serif !important;
    }
    
    #email-body {
      min-width: 600px;
      width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
    }
    
    #email-header {
      padding: 18px 25px;
      background: linear-gradient(135deg, #fff 0%, #fff 100%);
    }
    
    #email-content {
      padding: 42px 34px;
    }
    
    .greeting-section {
      font-size: 14px;
      margin-bottom: 18px;
    }
    
    .email-content-area p {
      font-size: 14px;
      margin-bottom: 15px;
      line-height: 1.5;
    }
    
    .otp-title {
      font-size: 20px;
      font-weight: 700;
      margin-bottom: 18px;
      color: #1f2937;
    }
    
    .otp-container {
      background-color: #f0fdf4;
      padding: 30px 20px;
      border-radius: 8px;
      margin: 25px 0;
      text-align: center;
      border: 2px solid #22C55E;
    }
    
    .otp-code {
      font-size: 36px;
      font-weight: 800;
      letter-spacing: 8px;
      color: #15803d;
      margin: 15px 0;
      font-family: 'Inter', monospace;
      text-align: center;
      display: block;
    }
    
    .otp-label {
      font-size: 12px;
      color: #16a34a;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 1px;
      margin-bottom: 10px;
    }
    
    .security-warning {
      background-color: #fef3c7;
      padding: 15px;
      border-radius: 8px;
      margin: 20px 0;
      border-left: 4px solid #f59e0b;
      font-size: 14px;
      color: #92400e;
    }
    
    .security-warning strong {
      font-weight: 600;
      color: #d97706;
    }
    
    .thank-you-section {
      margin-top: 25px;
      margin-bottom: 0;
      font-weight: 500;
    }
    
    #email-footer {
      margin-top: 20px;
    }
    
    #tagline-section {
      background-color: #EDEDED;
      padding: 16px;
      text-align: center;
      font-size: 13px;
      color: #6b7280;
    }
    
    .small-tagline {
      font-size: 13px;
      color: #6b7280;
      margin-bottom: 4px;
    }
    
    .big-tagline {
      font-size: 14px;
      color: #374151;
      font-weight: 700;
    }
    
    .big-tagline a {
      color: #787f83;
      font-weight: 600;
      text-decoration: none;
    }
    
    .big-tagline a:hover {
      text-decoration: underline;
    }
    
    .company-details {
      text-align: center;
      padding: 20px 0;
      background-color: #ffffff;
    }
    
    .footer-logo {
      height: 35px;
      margin-bottom: 10px;
      filter: invert(65%);
    }
    
    .company-title {
      font-size: 14px;
      font-weight: 600;
      color: #374151;
      margin-bottom: 5px;
    }
    
    .company-address-contact {
      color: #6b7280;
      font-size: 12px;
      line-height: 1.4;
    }
    
    .expiry-notice {
      background-color: #f0f9ff;
      padding: 12px;
      border-radius: 6px;
      border-left: 3px solid #0284c7;
      font-size: 13px;
      color: #0369a1;
      margin-top: 15px;
    }
  </style>
</head>
<body>
  <div id="email-body">
    <div id="email-header">
      @if(!empty($logoPath) && file_exists(public_path($logoPath)))
        <img src="{{ url($logoPath) }}" height="54px" width="auto" alt="Logo">
      @else
        <h2 style="color: black; margin: 0; font-weight: 600;">{{ $companyName }}</h2>
      @endif
    </div>
    
    <div id="email-content">
      <div class="greeting-section">Hi, <b>{{ $email }}</b></div>
      
      <div class="email-content-area">
        <p class="otp-title">🔐 Password Reset Verification</p>
        
        <p>Please use the following OTP (One-Time Password) to complete your password reset process:</p>
        
        <div class="otp-container">
          <div class="otp-label">Your OTP Code</div>
          <div class="otp-code">{{ $otp_code }}</div>
          <div class="expiry-notice">
            ⏰ This code will expire in 5 minutes
          </div>
        </div>
        
        <div class="security-warning">
          <strong>🔒 Security Notice:</strong> Never share your OTP with anyone during the password reset process. If you did not request this password reset, please disregard this email and ensure your account is secure.
        </div>
        
        <p>If you're having trouble with the password reset process or have any questions, please contact our support team for assistance.</p>
        
        <p class="thank-you-section">Thank you,<br>{{ $companyName }} Team</p>
      </div>
    </div>
    
    <div id="email-footer">
      <div id="tagline-section">
        <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
        <p class="big-tagline">For questions or support, contact 
          <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
        </p>
      </div>
      
      <div class="company-details">
        @if(!empty($logoPath) && file_exists(public_path($logoPath)))
          <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
        @endif
        <div class="company-title">{{ $companyName }}</div>
        <div class="company-address-contact">
          {{ $fullAddress }}<br>
          Call: {{ $companyPhone }}
        </div>
      </div>
    </div>
  </div>
</body>
</html>