@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\DB;
  use App\Models\User;
  

  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
  // Define color theme for this email
  $themeColor = '#DC2626'; // Dark Red
  $themeBackground = 'linear-gradient(135deg, #FEE2E2 0%, #FCA5A5 100%)';
  $themeIcon = '⛔';


@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      padding: 0;
      margin: 0;
      font-family: 'Inter', sans-serif !important;
      box-sizing: border-box;
    }
    
    body {
      background-color: #f8f9fa;
      padding: 20px 0;
    }
    
    #email-body {
      min-width: 600px;
      width: 600px;
      max-width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      font-family: 'Inter', sans-serif !important;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      border-radius: 8px;
      overflow: hidden;
    }
    
    #email-header {
      padding: 18px 25px;
      background: #fff !important;
      text-align: left;
      position: relative;
    }
    
    #email-header::after {
      content: '';
      position: absolute;
      top: 0;
      right: 0;
      width: 100px;
      height: 100%;
      background: #fff !important;
      transform: skew(-15deg);
      transform-origin: top right;
    }
    
    #email-header img {
      height: 54px;
      width: auto;
      display: inline-block;
    }
    
    #email-header h2 {
      color: white;
      margin: 0;
      font-weight: 700;
      font-size: 24px;
      text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    
    #email-content {
      padding: 42px 34px;
      color: #333333;
    }
    
    .greeting-section {
      font-size: 14px;
      margin-bottom: 18px;
      color: #6b7280;
    }
    
    .greeting-section strong {
      color: #1f2937;
      font-weight: 600;
    }
    
    .notification-title {
      font-size: 22px;
      font-weight: 700;
      margin-bottom: 20px;
      color: {{ $themeColor }};
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .notification-title::before {
      content: "{{ $themeIcon }}";
      font-size: 24px;
    }
    
    .alert-box {
      background: {{ $themeBackground }};
      border: 1px solid {{ $themeColor }};
      border-radius: 8px;
      padding: 16px;
      margin-bottom: 24px;
      position: relative;
    }
    
    .alert-box::before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      bottom: 0;
      width: 4px;
      background: {{ $themeColor }};
      border-radius: 4px 0 0 4px;
    }
    
    .alert-box p {
      margin: 0;
      font-size: 14px;
      color: #991B1B;
      font-weight: 500;
    }
    
    .info-card {
      background: #f9fafb;
      border: 1px solid #e5e7eb;
      border-radius: 8px;
      padding: 20px;
      margin-bottom: 20px;
      position: relative;
      transition: transform 0.2s ease;
    }
    
    .info-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    
    .info-card h3 {
      color: #1f2937;
      margin-bottom: 12px;
      font-weight: 600;
      font-size: 16px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    
    .order-details h3::before {
      content: '📋';
      font-size: 18px;
    }
    
    .info-card p {
      margin-bottom: 8px;
      font-size: 14px;
      color: #374151;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .info-card p:last-child {
      margin-bottom: 0;
    }
    
    .info-card strong {
      font-weight: 600;
      color: #1f2937;
      min-width: 120px;
    }
    
    .info-value {
      font-weight: 500;
      color: #4b5563;
    }
    
    .status-badge {
      display: inline-block;
      padding: 4px 12px;
      border-radius: 20px;
      font-size: 12px;
      font-weight: 600;
      text-transform: uppercase;
      letter-spacing: 0.5px;
      background: {{ $themeBackground }};
      color: #991B1B;
      border: 1px solid {{ $themeColor }};
    }
    
    .email-content-area p {
      font-size: 14px;
      margin-bottom: 15px;
      line-height: 1.6;
      color: #4b5563;
    }
    
    .action-button {
      display: inline-block;
      background-color: {{ $themeColor }};
      color: white !important;
      text-decoration: none;
      padding: 12px 24px;
      border-radius: 6px;
      font-weight: 600;
      margin: 15px 0;
      text-align: center;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
      transition: background-color 0.2s ease;
    }
    
    .action-button:hover {
      background-color: #B91C1C;
    }
    
    .divider {
      height: 1px;
      background: linear-gradient(90deg, transparent 0%, #e5e7eb 50%, transparent 100%);
      margin: 24px 0;
    }
    
    #email-footer {
      margin-top: 20px;
    }
    
    #tagline-section {
      background-color: #EDEDED;
      padding: 16px;
      text-align: center;
      font-size: 13px;
      color: #6b7280;
    }
    
    .big-tagline {
      margin-top: 8px;
      font-size: 14px;
      color: #374151;
    }
    
    .big-tagline a {
      color: #787f83;
      font-weight: 700;
      text-decoration: none;
    }
    
    .company-details {
      padding: 20px;
      text-align: center;
    }
    
    .footer-logo {
      height: 35px;
      filter: invert(65%);
      margin-bottom: 12px;
    }
    
    .company-title {
      font-size: 14px;
      font-weight: 600;
      color: #1f2937;
      margin-bottom: 8px;
    }
    
    .company-address-contact {
      font-size: 12px;
      color: #6b7280;
      line-height: 1.5;
    }
    
    .thank-you {
      font-weight: 600;
      color: #374151;
      margin-top: 25px;
    }
  </style>
</head>
<body>
  <div id="email-body">
    <div id="email-header">
      @if(!empty($logoPath) && file_exists(public_path($logoPath)))
        <img src="{{ url($logoPath) }}" alt="WMS Logo" />
      @else
        <h2>{{ $companyName }}</h2>
      @endif
    </div>

    <div id="email-content">
      <div class="greeting-section">
        Hello, <strong>{{ $name }}</strong>
      </div>

      <div class="notification-title">
        Your Payment Request Has Been Rejected
      </div>

      <div class="alert-box">
        <p>
          Your payment request for the {{ $plan_name }} plan has been reviewed and rejected by our team.
        </p>
      </div>

      <div class="info-card order-details">
        <h3>Order Details</h3>
        <p><strong>Order ID:</strong> <span class="info-value">{{ $order_id }}</span></p>
        <p><strong>Plan:</strong> <span class="info-value">{{ $plan_name }}</span></p>
        <p><strong>Amount:</strong> <span class="info-value">{{ $price }} {{ $currency }}</span></p>
        <p><strong>Payment Type:</strong> <span class="info-value">{{ $payment_type }}</span></p>
        <p><strong>Status:</strong> <span class="status-badge">Rejected</span></p>
      </div>

      <div class="email-content-area">
        <p>Unfortunately, we were unable to process your payment request. This may be due to insufficient information, verification issues, or other problems with the payment method used.</p>
        
        <p>If you still wish to subscribe to our service, please try again with a different payment method or contact our support team for assistance.</p>
        
        <div class="divider"></div>
        
        <p>For any questions about this rejection or to discuss alternative payment options, please contact our customer support team.</p>
        
        <p class="thank-you">Thank you,<br>{{ $companyName }} Team</p>
      </div>
    </div>

    <div id="email-footer">
      <div id="tagline-section">
        <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
        <div class="big-tagline">
          For any questions, contact support
          @if($companyEmail)
            <a href="mailto:{{$companyEmail}}">{{$companyEmail}}</a>
          @endif
        </div>
      </div>

      <div class="company-details">
        @if(!empty($logoPath) && file_exists(public_path($logoPath)))
          <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
        @endif
        <div class="company-title">{{ $companyName }}</div>
        <div class="company-address-contact">
          {{ $fullAddress }}<br />
          Call: {{ $companyPhone }}
        </div>
      </div>
    </div>
  </div>
</body>
</html> 