@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\DB;
  use Illuminate\Support\Facades\Route;
  use Illuminate\Support\Facades\Config;
  use App\Models\User;
  
  // Status configuration for subscription confirmation
  if (!isset($status_config)) {
    $status_config = [
      'subject' => $subject ?? 'Subscription Confirmation',
      'status_text' => 'Active',
      'color' => '#059669', // Green
      'background' => 'linear-gradient(135deg, #ECFDF5 0%, #D1FAE5 100%)',
      'icon' => '✨',
      'message' => 'Your subscription has been successfully activated!',
      'action_required' => false,
      'action_message' => ''
    ];
  }

  $logoPath = null;
  $companyName = env('APP_NAME', 'WMS');
  $companyAddress = '';
  $companyCity = '';
  $companyState = '';
  $companyPostCode = '';
  $companyCountry = '';
  $companyPhone = 'Contact Information';
  $companyEmail = env('EMAIL_ADDRESS', 'support@example.com');
  
  // Get admin settings data
    $admin = User::where('user_type', config('constants.user_types.admin'))->first();
    if ($admin) {
      $settings = DB::table('adminsettings')
          ->where('customer_id', $admin->id)
          ->get();
          
      // Transform into key-value pairs for easier access
      $settingsData = [];
      foreach ($settings as $setting) {
          $settingsData[$setting->key] = $setting->value;
      }
      
      // Get logo
      if (isset($settingsData['brand_logo_dark'])) {
          $logoPath = $settingsData['brand_logo_dark'];
      }
      
      // Get company information
      if (isset($settingsData['company_company_name'])) {
          $companyName = $settingsData['company_company_name'];
      }
      if (isset($settingsData['company_company_address'])) {
          $companyAddress = $settingsData['company_company_address'];
      }
      
      if (isset($settingsData['company_company_city'])) {
          $companyCity = $settingsData['company_company_city'];
      }
      
      if (isset($settingsData['company_company_state'])) {
          $companyState = $settingsData['company_company_state'];
      }
      
      if (isset($settingsData['company_company_post_code'])) {
          $companyPostCode = $settingsData['company_company_post_code'];
      }
      
      if (isset($settingsData['company_company_country'])) {
          $companyCountry = $settingsData['company_company_country'];
      }
      
      if (isset($settingsData['company_company_telephone'])) {
          $companyPhone = $settingsData['company_company_telephone'];
      }
      
      if (isset($settingsData['company_company_email'])) {
          $companyEmail = $settingsData['company_company_email'];
      }
    }
  
  
  // Format full address
  $fullAddress = $companyAddress;
  if (!empty($companyCity)) {
      $fullAddress .= ', ' . $companyCity;
  }
  if (!empty($companyState)) {
      $fullAddress .= ', ' . $companyState;
  }
  if (!empty($companyPostCode)) {
      $fullAddress .= ' ' . $companyPostCode;
  }
  if (!empty($companyCountry)) {
      $fullAddress .= ', ' . $companyCountry;
  }
  // Helper function to determine if a date is valid (not 1970-01-01)
  function isValidDate($date) {
    if (empty($date)) return false;
    if (strpos($date, '1970-01-01') !== false) return false;
    return true;
  }
  
  // Format the next billing date with a fallback
  $formattedNextBillingDate = isValidDate($next_billing_date) ? 
    $next_billing_date : 
    date('Y-m-d', strtotime('+' . $interval . ' months'));
    

@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>{{ $subject }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <style>
    * {
      padding: 0;
      margin: 0;
      font-family: 'Inter', sans-serif !important;
      box-sizing: border-box;
    }
    
    body {
      background-color: #f8f9fa;
      padding: 20px 0;
    }
    
    #email-body {
      min-width: 600px;
      width: 600px;
      max-width: 600px;
      margin: 0 auto;
      background-color: #ffffff;
      font-family: 'Inter', sans-serif !important;
      box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
      border-radius: 8px;
      overflow: hidden;
    }
    
    #email-header {
      padding: 18px 25px;
      background: linear-gradient(135deg, #fff 0%, #fff 100%);
      text-align: left;
      position: relative;
    }
    
    #email-header::after {
      content: '';
      position: absolute;
      top: 0;
      right: 0;
      width: 100px;
      height: 100%;
      background: rgba(255, 255, 255, 0.1);
      transform: skew(-15deg);
      transform-origin: top right;
    }
    
    #email-header img {
      height: 54px;
      width: auto;
      display: inline-block;
    }
    
    #email-header h2 {
      color: white;
      margin: 0;
      font-weight: 700;
      font-size: 24px;
      text-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
    }
    
    #email-content {
      padding: 42px 34px;
      color: #333333;
    }
    
    .greeting-section {
      font-size: 14px;
      margin-bottom: 18px;
      color: #6b7280;
    }
    
    .greeting-section strong {
      color: #1f2937;
      font-weight: 600;
    }
    
    .notification-title {
      font-size: 22px;
      font-weight: 700;
      margin-bottom: 20px;
      color: {{ $status_config['color'] }};
      display: flex;
      align-items: center;
      gap: 10px;
    }
    
    .notification-title::before {
      content: "{{ $status_config['icon'] }}";
      font-size: 24px;
    }
    
    .alert-box {
      background: {{ $status_config['background'] }};
      border: 1px solid {{ $status_config['color'] }};
      border-radius: 8px;
      padding: 16px;
      margin-bottom: 24px;
      position: relative;
    }
    
    .alert-box::before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      bottom: 0;
      width: 4px;
      background: {{ $status_config['color'] }};
      border-radius: 4px 0 0 4px;
    }
    
    .alert-box p {
      margin: 0;
      font-size: 14px;
      color: white;
      font-weight: 500;
    }
    
    .info-card {
      background: #f9fafb;
      border: 1px solid #e5e7eb;
      border-radius: 8px;
      padding: 20px;
      margin-bottom: 20px;
      position: relative;
      transition: transform 0.2s ease;
    }
    
    .info-card:hover {
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
    }
    
    .info-card h3 {
      color: #1f2937;
      margin-bottom: 12px;
      font-weight: 600;
      font-size: 16px;
      display: flex;
      align-items: center;
      gap: 8px;
    }
    
    .subscription-details h3::before {
      content: '💳';
      font-size: 18px;
    }
    
    .info-card p {
      margin-bottom: 8px;
      font-size: 14px;
      color: #374151;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    
    .info-card p:last-child {
      margin-bottom: 0;
    }
    
    .info-card strong {
      font-weight: 600;
      color: #1f2937;
      min-width: 120px;
    }
    
    .info-value {
      font-weight: 500;
      color: #4b5563;
    }
    
    .price-highlight {
      background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
      color: white !important;
      padding: 4px 8px;
      border-radius: 4px;
      font-weight: 600;
    }
    
    .original-price {
      text-decoration: line-through;
      color: #9ca3af !important;
    }
    
    .discount-badge {
      background: linear-gradient(135deg, #EF4444 0%, #DC2626 100%);
      color: white !important;
      padding: 4px 8px;
      border-radius: 4px;
      font-weight: 600;
    }
    
    .billing-date-highlight {
      background: linear-gradient(135deg, #F59E0B 0%, #D97706 100%);
      color: white !important;
      padding: 4px 8px;
      border-radius: 4px;
      font-weight: 600;
    }
    
    .email-content-area p {
      font-size: 14px;
      margin-bottom: 15px;
      line-height: 1.6;
      color: #4b5563;
    }
    
    .login-button {
      display: inline-block;
      background: linear-gradient(135deg, #3B82F6 0%, #1D4ED8 100%);
      color: white;
      text-decoration: none;
      padding: 12px 24px;
      border-radius: 8px;
      font-weight: 600;
      margin: 20px 0;
      box-shadow: 0 4px 6px rgba(59, 130, 246, 0.2);
      transition: all 0.3s ease;
    }
    
    .login-button:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 12px rgba(59, 130, 246, 0.3);
    }
    
    .divider {
      height: 1px;
      background: linear-gradient(90deg, transparent 0%, #e5e7eb 50%, transparent 100%);
      margin: 24px 0;
    }
    
    .footer-message {
      background: #f0f9ff;
      border: 1px solid #0ea5e9;
      border-radius: 8px;
      padding: 16px;
      margin: 24px 0;
      position: relative;
    }
    
    .footer-message::before {
      content: '';
      position: absolute;
      left: 0;
      top: 0;
      bottom: 0;
      width: 4px;
      background: #0ea5e9;
      border-radius: 4px 0 0 4px;
    }
    
    .footer-message p {
      margin: 0;
      font-size: 14px;
      color: #0c4a6e;
      font-weight: 500;
    }
    
    .thank-you {
      margin-top: 25px;
      padding-top: 20px;
      border-top: 1px solid #e5e7eb;
      font-size: 14px;
      color: #374151;
      font-weight: 500;
    }
    
    #email-footer {
      margin-top: 20px;
    }
    
    #tagline-section {
      background-color: #EDEDED;
      padding: 16px;
      text-align: center;
      font-size: 13px;
      color: #6b7280;
    }
    
    .small-tagline {
      font-size: 13px;
      color: #6b7280;
      margin-bottom: 4px;
    }
    
    .big-tagline {
      margin-top: 8px;
      font-size: 14px;
      color: #374151;
      font-weight: 700;
    }
    
    .big-tagline a {
      color: #787f83;
      font-weight: 700;
      text-decoration: none;
    }
    
    .company-details {
      padding: 20px;
      text-align: center;
    }
    
    .footer-logo {
      height: 35px;
      filter: invert(65%);
      margin-bottom: 12px;
    }
    
    .company-title {
      font-size: 14px;
      font-weight: 600;
      color: #1f2937;
      margin-bottom: 8px;
    }
    
    .company-address-contact {
      font-size: 12px;
      color: #6b7280;
      line-height: 1.5;
    }
  </style>
</head>
<body>
  <div id="email-body">
    <div id="email-header">
      @if(!empty($logoPath) && file_exists(public_path($logoPath)))
        <img src="{{ url($logoPath) }}" alt="WMS Logo" />
      @else
        <h2>{{ $companyName }}</h2>
      @endif
    </div>
    
    <div id="email-content">
      <div class="greeting-section">
        Hello, <strong>{{ $name ?? 'Valued Subscriber' }}</strong>
      </div>
      
      <div class="notification-title">
        {{ $subject }}
      </div>
      
      <div class="alert-box">
        <p>{{ $status_config['message'] }}</p>
      </div>
      
      <div class="email-content-area">
        <p>Welcome to our premium subscription service! We're excited to confirm that your subscription has been activated successfully. Below are the details of your subscription:</p>
      </div>
      
      <div class="info-card subscription-details">
        <h3>Subscription Details</h3>
        <p>
          <strong>Plan Name:</strong> 
          <span class="info-value">{{ $plan_name ?? 'N/A' }}</span>
        </p>
        <p>
          <strong>Order ID:</strong> 
          <span class="info-value">{{ $order_id ?? 'N/A' }}</span>
        </p>
        @if(isset($discount_amount) && $discount_amount > 0)
          <p>
            <strong>Original Price:</strong>
            <span class="original-price">{{ number_format($original_price, 2) }} {{ $currency }}</span>
          </p>
          <p>
            <strong>Discount ({{ $coupon_code }}):</strong>
            <span class="discount-badge">-{{ number_format($discount_amount, 2) }} {{ $currency }}</span>
          </p>
          <p>
            <strong>Final Amount:</strong>
            <span class="price-highlight">{{ number_format($price, 2) }} {{ $currency }}</span>
          </p>
        @else
          <p>
            <strong>Amount:</strong>
            <span class="price-highlight">{{ number_format($price, 2) }} {{ $currency }}</span>
          </p>
        @endif
        <p>
          <strong>Subscription Period:</strong> 
          <span class="info-value">{{ $interval ?? 'N/A' }} Month(s)</span>
        </p>
        <p>
          <strong>Next Billing Date:</strong> 
          <span class="billing-date-highlight">{{ $formattedNextBillingDate }}</span>
        </p>
      </div>

      <div class="email-content-area">
        <p>Your subscription is now active and you can start using all the premium features right away. We're committed to providing you with exceptional service throughout your subscription period.</p>
        
        <a href="{{ env('FRONTEND_URL') }}" class="login-button">🚀 Access Your Dashboard</a>
      </div>

      <div class="divider"></div>
      
      <div class="footer-message">
        <p>💡 If you have any questions about your subscription or need assistance with billing, please don't hesitate to contact our customer support team.</p>
      </div>

      <div class="thank-you">
        Thank you,<br>
        <strong>{{ $companyName }} Team</strong>
      </div>
    </div>

    <div id="email-footer">
      <div id="tagline-section">
        <p class="small-tagline">This is an auto-generated email. Please do not reply.</p>
        <p class="big-tagline">For questions or support, contact 
          <a href="mailto:{{ $companyEmail }}">{{ $companyEmail }}</a>
        </p>
      </div>

      <div class="company-details">
        @if(!empty($logoPath) && file_exists(public_path($logoPath)))
          <img src="{{ url($logoPath) }}" class="footer-logo" alt="Logo">
        @endif
        <div class="company-title">{{ $companyName }}</div>
        <div class="company-address-contact">
          {{ $fullAddress }}<br />
          Call: {{ $companyPhone }}
        </div>
      </div>
    </div>
  </div>
</body>
</html> 