<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Inspection Plan Report</title>
    <style>
        @page {
            margin: 0px 30px 0px 30px;
        }

        /* Fixed header that appears on every page */
        header {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            height: 100px;
            background: transparent;
            z-index: 1000;
            padding: 10px 50px 0px 20px;
        }

        .footer {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            height: 60px;
            background: white;
            text-align: center;
            font-size: 16px;
            border-top: 1px solid #cccccc;
            padding: 5px 0;
            z-index: 1000;
        }

        .content {
            position: relative;
            top: 100px;
            padding-bottom: 150px;
        }

        .page-break {
            page-break-before: always;
        }
    </style>
</head>

<body style="margin: 0px;padding: 0px;font-family: 'Poppins', sans-serif;">
    <header style="padding: 10px 20px 0px 20px;">
        <table width="100%" style="border-collapse: collapse;">
            <tr>
                <td>
                    <img src="{{'/assets/img/pdf_logo.png'}}" alt="" width="35%">
                </td>
                <td>
                    <h1 style="font-size: 18px;font-weight: 600;margin: 0px;color: #d2d2d2;text-align: right;">
                        Inspection Plan Report
                    </h1>
                </td>
            </tr>
        </table>
    </header>
    <div class="content">
        <div style="width: 95%;margin: auto;display: flex;align-items: center;background-color: #F3FBFF;padding: 30px 0px;">
            <table width="100%" style="border-collapse: collapse;">
                @if ($report)
                    <tr>
                        <td style="border-right: 1px solid #1E1E1E;padding: 15px 0px;width: 60%;">
                            <div style="width: 90%;margin: auto;">
                                <p style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    TITLE:
                                    @if ($report->title)
                                        <span style="font-weight: 400;color: #595959;">&nbsp;{{ $report->title }}</span>
                                    @else
                                        <span style="font-weight: 400;color: #595959;">&nbsp;N/A</span>
                                    @endif
                                </p>
                            </div>
                        </td>
                        <td style="padding: 15px 0px;width: 40%;">
                            <div style="width: 70%;margin: auto;">
                                <p style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    DOCUMENT NUMBER:
                                    @if ($report->document_number)
                                        <span style="font-weight: 400;color: #595959;">&nbsp;{{ $report->document_number }}</span>
                                    @else
                                        <span style="font-weight: 400;color: #595959;">&nbsp;N/A</span>
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-right: 1px solid #1E1E1E;width: 50%;">
                            <div style="width: 90%;margin: auto">
                                <p style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #059EF3;">
                                    AUTHORIZED BY:
                                    @if ($report->authorised_by_first_name)
                                        <span style="font-weight: 400;color: #595959;">&nbsp;{{ $report->authorised_by_first_name }} {{ $report->authorised_by_last_name }}</span>
                                    @else
                                        <span style="font-weight: 400;color: #595959;">&nbsp;N/A</span>
                                    @endif
                                </p>
                            </div>
                        </td>
                        <td style="width: 50%;">
                            <div style="width: 70%;margin: auto">
                                <p style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #059EF3;">
                                    ISSUE DATE:
                                    @if ($report->issue_date)
                                        <span style="font-weight: 400;color: #595959;">&nbsp;{{ $report->issue_date }}</span>
                                    @else
                                        <span style="font-weight: 400;color: #595959;">&nbsp;N/A</span>
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-right: 1px solid #1E1E1E;width: 50%;padding: 15px 0px;">
                            <div style="width: 90%;margin: auto">
                                <p style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    REVISION NUMBER:
                                    @if ($report->revision_number)
                                        <span style="font-weight: 400;color: #595959;">&nbsp;{{ $report->revision_number }}</span>
                                    @else
                                        <span style="font-weight: 400;color: #595959;">&nbsp;N/A</span>
                                    @endif
                                </p>
                            </div>
                        </td>
                        <td style="width: 50%;padding: 15px 0px;">
                            <div style="width: 70%;margin: auto">
                                <p style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    REVISION DATE:
                                    @if ($report->revision_date)
                                        <span style="font-weight: 400;color: #595959;">&nbsp;{{ $report->revision_date }}</span>
                                    @else
                                        <span style="font-weight: 400;color: #595959;">&nbsp;N/A</span>
                                    @endif
                                </p>
                            </div>
                        </td>
                    </tr>
                @endif
            </table>
        </div>

        <div style="margin: 30px 0px;">
            <table width="100%" style="border-collapse: collapse;">
                @if ($report)
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                PRINCIPAL CONTRACTOR:
                                @if ($report->principal_contractor)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->principal_contractor }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                PROJECT NAME:
                                @if ($report->project_name)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->project_name }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                JOB NUMBER:
                                @if ($report->job_number)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->job_number }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                BUILDING:
                                @if ($report->building)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->building }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                ACTIVITY:
                                @if ($report->activity)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->activity }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                OPEN DATE:
                                @if ($report->open_date)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->open_date }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                ITP:
                                @if ($report->itp_reference_number)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->itp_reference_number }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                CLOSE DATE:
                                @if ($report->close_date)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->close_date }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                Site:
                                @if ($report->sites_title)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;{{ $report->sites_title }}</span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                Supervisor:
                                @if (isset($supervisors) && $supervisors && $supervisors->count() > 0)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;
                                        @foreach ($supervisors as $supervisor)
                                            {{ $supervisor->emp_personal_supervisor_detail_f_name ?? '' }}
                                            {{ $supervisor->emp_personal_supervisor_detail_last_name ?? '' }}
                                            @if (!$loop->last)
                                                ,
                                            @endif
                                        @endforeach
                                    </span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                    </tr>
                    <tr>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                            <p style="font-family: 'Poppins', sans-serif; font-size: 14px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                Forman:
                                @if ($report->emp_personal_forman_detail_f_name)
                                    <span style="font-weight: 400; color: #595959;">&nbsp;
                                        {{ $report->emp_personal_forman_detail_f_name }}
                                        {{ $report->emp_personal_forman_detail_last_name }}
                                    </span>
                                @else
                                    <span style="font-weight: 400; color: #595959;">&nbsp;N/A</span>
                                @endif
                            </p>
                        </td>
                        <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px; width: 50%;">
                        </td>
                    </tr>
                @endif
            </table>
        </div>

        <div>
            @if ($forms)
                <div>
                    @forelse ($forms as $stepName => $steps)
                        <div class="page-break">
                            @php
                                $step = $steps->first();
                                $metaHeaders = $steps->where('is_table', '0')->pluck('meta_title')->unique();
                                $stepImages = $steps->pluck('inspection_image')->unique();
                                $metaValues = $steps->where('is_table', '0')->groupBy('meta_title');
                                $signatures = $steps->pluck('inspection_plan_signature')->unique();
                            @endphp
                            <div style="text-align: center;background-color: #059EF3;padding: 15px;margin-top: 30px;">
                                <h2 style="font-size: 21px;font-weight: 500;margin: 0px;color: #fff;text-transform: uppercase">
                                    {{ str_replace('_', ' ', $stepName) }}
                                </h2>
                            </div>
                            <table width="100%" style="border-collapse: collapse;">
                                @if ($step)
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                LEVEL:
                                                @if ($step->level)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->level }}</span>
                                                @endif
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                TO LEVEL:
                                                @if ($step->to_level)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->to_level }}</span>
                                                @endif
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                POUR:
                                                @if ($step->pour)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->pour }}</span>
                                                @endif
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                ARCHITECTURAL DRAWING NUMBER:
                                                @if ($step->architectural_drawing_number)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->architectural_drawing_number }}</span>
                                                @endif
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                STRUCTURAL DRAWING NUMBER:
                                                @if ($step->structectural_drawing_number)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->structectural_drawing_number }}</span>
                                                @endif
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                            <span style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                POST TENSION DRAWING NUMBER:
                                                @if ($step->Post_Tension_Drawing_Number)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->Post_Tension_Drawing_Number }}</span>
                                                @endif
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                PARTIAL HANDOVER:
                                                @if ($step->partial_handover)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;Yes</span>
                                                @endif
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                            <span style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                PARTIAL HANDOVER DATE:
                                                @if ($step->partial_Handover_date)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->partial_Handover_date }}</span>
                                                @endif
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                PARTIAL HANDOVER TIME:
                                                @if ($step->partial_Handover_time)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->partial_Handover_time }}</span>
                                                @endif
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                            <span style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                PARTIAL HANDOVER LOCATION:
                                                @if ($step->partial_Handover_location)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->partial_Handover_location }}</span>
                                                @endif
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                COMPLETE HANDOVER:
                                                @if ($step->complete_handover)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;Yes</span>
                                                @endif
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                COMPLETE HANDOVER DATE:
                                                @if ($step->complete_handover_date)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->complete_handover_date }}</span>
                                                @endif
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                COMPLETE HANDOVER TIME:
                                                @if ($step->complete_handover_time)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->complete_handover_time }}</span>
                                                @endif
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                            <span style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                COMPLETE HANDOVER LOCATION:
                                                @if ($step->complete_handover_Location)
                                                    <span style="font-weight: 400;color: #595959;">&nbsp;{{ $step->complete_handover_Location }}</span>
                                                @endif
                                            </span>
                                        </td>
                                    </tr>
                                @endif
                            </table>

                            {{-- Blue header bar at the top --}}
                            <div style="text-align: center; background-color: #059EF3; padding: 15px;">
                                <h5 style="font-size: 21px; font-weight: 500; margin: 0; color: #fff; text-transform: uppercase;">
                                    Tables
                                </h5>
                            </div>

                            @if ($metaHeaders->isNotEmpty())
                                @php
                                    $uniqueMetaValues = $metaValues->map(function ($values) {
                                        return $values->pluck('meta_value')->unique()->values();
                                    });
                                    $maxRows = $uniqueMetaValues->map->count()->max();
                                @endphp

                                {{-- Table container --}}
                                <div style="padding: 20px;">
                                    @php
                                        $rowsPerTable = 3;
                                        $totalTables = ceil($maxRows / $rowsPerTable);
                                    @endphp

                                    @for ($tableIndex = 0; $tableIndex < $totalTables; $tableIndex++)
                                        @if ($tableIndex > 0)
                                            <hr style="border: 1px solid #ccc; margin: 20px 0;">
                                        @endif

                                        <table style="width: 100%; border-collapse: collapse; margin-bottom: 20px; table-layout: fixed;">
                                            <tbody>
                                                @foreach ($metaHeaders as $header1)
                                                    <tr>
                                                        <th style="padding: 10px; border: 1px solid #1E1E1E; background-color: #059EF3; color: #fff; text-align: left;">
                                                            {{ $header1 }}
                                                        </th>
                                                        @for ($rowIndex = $tableIndex * $rowsPerTable; $rowIndex < min(($tableIndex + 1) * $rowsPerTable, $maxRows); $rowIndex++)
                                                            <td style="padding: 10px; border: 1px solid #1E1E1E; word-wrap: break-word;">
                                                                @if ($uniqueMetaValues->has($header1) && isset($uniqueMetaValues[$header1][$rowIndex]))
                                                                    {{ $uniqueMetaValues[$header1][$rowIndex] }}
                                                                @else
                                                                    --
                                                                @endif
                                                            </td>
                                                        @endfor
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    @endfor
                                </div>
                            @else
                                <p style="margin: 0;">No Table data available.</p>
                            @endif
                        </div>

                        @if ($signatures->isNotEmpty())
                            <div style="padding:30px 0;">
                                <table style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif;">
                                    <tr>
                                        <th colspan="2" style="border: 1px solid #ddd; background-color: #ccc; text-align: center; padding: 8px;">
                                            Fastform Group Australia Pty Ltd
                                        </th>
                                        <th colspan="2" style="border: 1px solid #ddd; background-color: #ccc; text-align: center; padding: 8px;">
                                            Principal Contractor
                                        </th>
                                    </tr>

                                    @foreach ($steps->unique('inspection_plan_employee_name')->chunk(2) as $pair)
                                        <tr>
                                            <td style="border: 1px solid #ddd; background-color: #f2f2f2; padding: 8px; width: 120px;">
                                                Name:
                                            </td>
                                            <td style="border: 1px solid #ddd; padding: 8px; width: 180px;">
                                                {{ $pair[0]->inspection_plan_employee_name ?? '' }}
                                            </td>
                                            <td style="border: 1px solid #ddd; background-color: #f2f2f2; padding: 8px; width: 120px;">
                                                Name:
                                            </td>
                                            <td style="border: 1px solid #ddd; padding: 8px; width: 180px;">
                                                @if(isset($pair[1]))
                                                    {{ $pair[1]->inspection_plan_employee_name }}
                                                @endif
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="border: 1px solid #ddd; background-color: #f2f2f2; padding: 8px;">
                                                Signature:
                                            </td>
                                            <td style="border: 1px solid #ddd; padding: 8px;">
                                                @php 
                                                    $leftSignature = $pair[0]->inspection_plan_signature;
                                                @endphp
                                                @if(is_string($leftSignature) && !empty($leftSignature))
                                                    <img src="{{ asset($leftSignature) }}" 
                                                        alt="Signature" 
                                                        style="max-width: 100px; max-height: 50px;">
                                                @else
                                                    No signature available
                                                @endif
                                            </td>
                                            <td style="border: 1px solid #ddd; background-color: #f2f2f2; padding: 8px;">
                                                Signature:
                                            </td>
                                            <td style="border: 1px solid #ddd; padding: 8px;">
                                                @if(isset($pair[1]))
                                                    @php 
                                                        $rightSignature = $pair[1]->inspection_plan_signature; 
                                                    @endphp
                                                    @if(is_string($rightSignature) && !empty($rightSignature))
                                                        <img src="{{ asset($rightSignature) }}"
                                                            alt="Signature"
                                                            style="max-width: 100px; max-height: 50px;">
                                                    @else
                                                        No signature available
                                                    @endif
                                                @endif
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="border: 1px solid #ddd; background-color: #f2f2f2; padding: 8px;">
                                                Date:
                                            </td>
                                            <td style="border: 1px solid #ddd; padding: 8px;">
                                                {{ $pair[0]->inspection_plan_date ?? 'N/A' }}
                                            </td>
                                            <td style="border: 1px solid #ddd; background-color: #f2f2f2; padding: 8px;">
                                                Date:
                                            </td>
                                            <td style="border: 1px solid #ddd; padding: 8px;">
                                                @if(isset($pair[1]))
                                                    {{ $pair[1]->inspection_plan_date ?? 'N/A' }}
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </table>
                            </div>
                        @else
                            <p class="text-center">No signatures available for this section.</p>
                        @endif
                        <div class="page-break"></div>

                        @if ($stepImages->isNotEmpty())
                            <div style="padding: 0px 20px 20px;">
                                <div style="text-align: center;background-color: #059EF3;padding: 15px;">
                                    <h5 style="font-size: 21px;font-weight: 500;margin: 0px;color: #fff;text-transform: uppercase">
                                        Inspection Files
                                    </h5>
                                </div>
                                <div style="height:50px;"></div>
                                <div style="display: flex; flex-wrap: wrap; justify-content: flex-start;">
                                    @foreach ($stepImages as $file)
                                        @php
                                            $extension = strtolower(pathinfo($file, PATHINFO_EXTENSION));
                                            $filename = pathinfo($file, PATHINFO_FILENAME);
                                        @endphp

                                        @if ($extension === 'pdf')
                                            <div style="width: 150px; height: 150px; margin-right: 10px; margin-bottom: 10px; display: inline-block; text-align: center;">
                                                <a href="{{ asset($file) }}" target="_blank" style="display: block;">
                                                    <img src="{{ asset('/assets/img/pdf_logo.png') }}" alt="PDF Icon" 
                                                        style="width: 100px; height: 100px; margin-top: 20px;">
                                                </a>
                                                <div style="font-size: 14px; margin-top: 5px;">
                                                    {{ $filename }}
                                                </div>
                                            </div>
                                        @else
                                            <div style="width: 150px; height: 150px; margin-right: 10px; margin-bottom: 10px; display: inline-block;">
                                                <img src="{{ asset($file) }}" alt="Inspection Image" 
                                                    style="width: 100%; height: 100%; object-fit: cover;">
                                            </div>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        @else
                            <p>No inspection images available for this step.</p>
                        @endif
                    @empty
                        <p style="margin:0px;"></p>
                    @endforelse
                    <div style="text-align: center; padding: 15px;">
                        <h5 style="font-size: 21px;font-weight: 500;margin: 0px;color: #000000;text-transform: uppercase">
                            Details
                        </h5>
                    </div>
                    <table style="width:100%;">
                        <tr>
                            <p>{{$report->description ?? ''}}</p>
                        </tr>
                    </table>
                </div>
            @endif
        </div>
    </div>
    <div class="footer">
        <div style="margin-left: 30px;margin-right: 30px;">
            <table style="width:100%;">
                <tr>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Title:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ $report->title ?? 'N/A' }}
                    </td>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">SWMS Number:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ $report->document_number ?? 'N/A' }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Revision Number:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ $report->revision_number }}
                    </td>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Authorized By:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ trim(($report->authorised_by_first_name ?? '') . ' ' . ($report->authorised_by_last_name ?? '')) }}
                    </td>
                </tr>
                <tr>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Issue Date:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ $report->issue_date }}
                    </td>
                    <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Revision Date:</td>
                    <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                        {{ $report->revision_date }}
                    </td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>