@extends('includes/layout')
@section('main-page-content')
     <!-- add html here--->

    <div class="container-xxl flex-grow-1 container-p-y">
      <div class="row gy-4">
        <!-- Four Cards -->
        <div class="col-xl-12">
          <div class="row gy-4">
            <div class="col-sm-3">
              <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                  <div class="avatar">
                    <div class="avatar-initial bg-secondary rounded-circle shadow">
                      <i class="mdi mdi-account-multiple mdi-24px"></i>
                    </div>
                  </div>
                </div>
                <div class="card-body mt-mg-1">
                  <h6 class="mb-2">Total Employees</h6>
                  <div class="d-flex flex-wrap align-items-center mb-2 pb-1">
                    <h2 class="mb-0 me-2 mt-2">{{$data['total_employees']}}</h2>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                  <div class="avatar">
                    <div class="avatar-initial bg-primary rounded-circle shadow-sm">
                      <i class="mdi mdi-account-box-outline mdi-24px"></i>
                    </div>
                  </div>
                </div>
                <div class="card-body mt-mg-1">
                  <h6 class="mb-2">Total Clients</h6>
                  <div class="d-flex flex-wrap align-items-center mb-2 pb-1">
                    <h2 class="mb-0 me-2 mt-2">{{$data['total_clients']}}</h2>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                  <div class="avatar">
                    <div class="avatar-initial bg-primary rounded-circle shadow-sm">
                      <i class="mdi mdi-access-point mdi-24px"></i>
                    </div>
                  </div>
                </div>
                <div class="card-body mt-mg-1">
                  <h6 class="mb-2">Total Sites</h6>
                  <div class="d-flex flex-wrap align-items-center mb-2 pb-1">
                    <h2 class="mb-0 me-2 mt-2">{{$data['total_sites']}}</h2>
                  </div>
                </div>
              </div>
            </div>
            <div class="col-sm-3">
              <div class="card h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                  <div class="avatar">
                    <div class="avatar-initial bg-secondary rounded-circle shadow">
                      <i class="mdi mdi-professional-hexagon mdi-24px"></i>
                    </div>
                  </div>
                </div>
                <div class="card-body mt-mg-1">
                  <h6 class="mb-2">Total Projects</h6>
                  <div class="d-flex flex-wrap align-items-center mb-2 pb-1">
                    <h2 class="mb-0 me-2 mt-2">{{$data['total_projects']}}</h2>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- Four Cards -->

        <!--------------- TEAMS -------------------->
        <div class="col-lg-12">
          <div class="card">
            <div class="card-header">
              <div class="d-flex align-items-center justify-content-between">
                <h5 class="card-title m-0 me-2">Teams Attendance</h5>
              </div>
              <p class="mt-3"><span class="fw-medium">Total teams attendance details for today</span></p>
            </div>
            <div class="card-body">
              <div class="row g-3">
                <div class="col-12">
                  <div class="table-responsive text-nowrap border-bottom mt-1" style="min-height: auto !important">
                    <table class="table table-striped">
                        <thead class="table-head-color bg-primary">
                          <tr>
                            <th class="text-center">Team</th>
                            <th class="text-center">Employees</th>
                            <th class="text-center">Check-ins</th>
                            <th class="text-center">Not Available</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0 table-body">
                          @if (count($data['teams']) > 0)
                          @php $row_count = 0; @endphp
                            @foreach($data['teams'] as $key => $team)
                              @if ($team['total_employees_with_attendance'] != 0)
                                @php $row_count++; @endphp
                                <tr>
                                  <td class="text-center">{{ $team['team_title'] }}</td>
                                  <td class="text-center">{{ $team['total_employees_with_roster'] }}</td>
                                  <td class="text-center">{{ $team['total_employees_with_attendance'] }}</td>
                                  <td class="text-center">{{ $team['total_employees_without_attendance'] }}</td>
                                </tr>
                              @endif
                            @endforeach
                            @if ($row_count == 0)
                              <tr>
                                <td colspan="4" class="text-center">No record found.</td>
                              </tr>
                            @endif
                          @else
                            <tr>
                              <td colspan="4" class="text-center">No record found.</td>
                            </tr>
                          @endif
                            
                        </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <!--------------- TEAMS ----------------------->

        <!--------------- ATTENDANCE -------------------->
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="d-flex align-items-center justify-content-between">
                <h5 class="card-title m-0 me-2">Attendance</h5>
              </div>
              <div class="card-body">
                <div class="row g-3">
                  <div class="col-md-3 col-6">
                    <div class="d-flex">
                      <div class="avatar">
                        <div class="avatar-initial bg-primary rounded shadow">
                          <i class="mdi mdi-account-box mdi-24px" style="color:white !important"></i>
                        </div>
                      </div>
                      <div class="ms-3">
                        <div class="small mb-1">Total Employees</div>
                        <h5 class="mb-0">{{$data['total_roster_employees']}}</h5>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3 col-6">
                    <div class="d-flex">
                      <div class="avatar">
                        <div class="avatar-initial bg-success rounded shadow">
                          <i class="mdi mdi-account-check mdi-24px"></i>
                        </div>
                      </div>
                      <div class="ms-3">
                        <div class="small mb-1">Present</div>
                        <h5 class="mb-0">{{$data['total_present']}}</h5>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3 col-6">
                    <div class="d-flex">
                      <div class="avatar">
                        <div class="avatar-initial bg-warning rounded shadow">
                          <i class="mdi mdi-account-minus mdi-24px"></i>
                        </div>
                      </div>
                      <div class="ms-3">
                        <div class="small mb-1">Absent</div>
                        <h5 class="mb-0">{{$data['total_absent']}}</h5>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-3 col-6">
                    <div class="d-flex">
                      <div class="avatar">
                        <div class="avatar-initial bg-info rounded shadow">
                          <i class="mdi mdi-account-plus mdi-24px"></i>
                        </div>
                      </div>
                      <div class="ms-3">
                        <div class="small mb-1">Leave</div>
                        <h5 class="mb-0">{{$data['total_leaves']}}</h5>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <p class="mt-3"><span class="fw-medium">Total attendance details for today</span></p>
              <div class="nav-align-top">
                <ul class="nav nav-tabs" role="tablist">
                  <li class="nav-item border-end my-1" role="presentation">
                    <button type="button" class="nav-link waves-effect active" role="tab" data-bs-toggle="tab" data-bs-target="#present_employees" aria-controls="present_employees" aria-selected="true">
                      Present
                    </button>
                  </li>
                  <li class="nav-item  border-end my-1" role="presentation">
                    <button type="button" class="nav-link waves-effect" role="tab" id="absentEmployeeTabBtn" data-bs-toggle="tab" data-bs-target="#absent_employees" aria-controls="absent_employees" aria-selected="false" tabindex="-1">
                      Absent
                    </button>
                  </li>
                  <li class="nav-item border-end my-1" role="presentation">
                    <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#leave_employees" aria-controls="leave_employees" aria-selected="false" tabindex="-1">
                      Leave
                    </button>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-body">
              <div class="tab-content p-0">
                <div class="tab-pane fade active show" id="present_employees" role="tabpanel">

                  <div class="table-responsive text-nowrap border-bottom mt-1"  style="min-height: auto !important">
                    <table class="table table-striped">
                        <thead class="table-head-color bg-primary">
                          <tr>
                            <th class="text-center">Sites</th>
                            <th class="text-center">Number of Employees</th>
                            <th class="text-center">Number of Check-ins</th>
                            <th class="text-center">Number of Check-outs</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0 table-body">
                          @if (count($data['sites_employee']) > 0)
                            @foreach($data['sites_employee'] as $siteName => $counts)
                              <tr>
                                <td class="text-center">{{ $siteName }}</td>
                                <td class="text-center">{{ $counts['employee_count'] }}</td>
                                <td class="text-center">{{ $counts['check_in_count'] }}</td>
                                <td class="text-center">{{ $counts['check_out_count'] }}</td>
                              </tr>
                            @endforeach
                          @else
                            <tr>
                              <td colspan="4" class="text-center">No record found.</td>
                            </tr>
                          @endif
                            
                        </tbody>
                    </table>
                  </div>

                  <div class="table-responsive text-nowrap border-bottom mt-4"  style="min-height: auto !important">
                    <table class="table table-striped">
                        <thead class="table-head-color bg-primary">
                          <tr>
                            <th>Name</th>
                            <th>Site</th>
                            <th>Date</th>
                            <th>Check-in</th>
                            <th>Check-out</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0 table-body present-employees">
                          {{-- @if (count($data['sites_employee']) > 0)
                            @foreach ($data['today_present'] as $key=>$value)
                              <tr>
                                <td>{{$value->present_employee_details->first_name}} {{$value->present_employee_details->middle_name}} {{$value->present_employee_details->last_name}}</td>
                                <td>{{$value->employee_site->title}}</td>
                                <td>{{formatDate($value->date)}}</td>
                                <td>{{formatTime($value->check_in)}}</td>
                                <td>{{formatTime($value->check_out)}}</td>
                              </tr>
                            @endforeach
                          @else
                            <tr>
                              <td colspan="5" class="text-center">No record found.</td>
                            </tr>
                          @endif --}}
                        </tbody>
                    </table>
                  </div>
                  <nav aria-label="Page navigation" class="mt-3">
                    <ul class="pagination justify-content-md-end justify-content-center present_pages_btn">
                    </ul>
                  </nav>
                </div>
                <div class="tab-pane fade" id="absent_employees" role="tabpanel">
                  <div class="table-responsive text-nowrap border-bottom" style="min-height: auto !important">
                    <table class="table table-striped">
                        <thead class="table-head-color bg-primary">
                          <tr>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Details</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0 table-body absent-employees">
                        </tbody>
                    </table>
                  </div>
                  <nav aria-label="Page navigation" class="mt-3">
                    <ul class="pagination justify-content-md-end justify-content-center absent_pages_btn">
                    </ul>
                  </nav>
                </div>
                <div class="tab-pane fade" id="leave_employees" role="tabpanel">
                  <div class="table-responsive text-nowrap border-bottom" style="min-height: auto !important">
                    <table class="table table-striped">
                        <thead class="table-head-color bg-primary">
                          <tr>
                            <th>Name</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Status</th>
                            <th>Reason</th>
                            <th>Details</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0 table-body">
                          @if (count($data['today_leaves']) > 0)
                            @foreach ($data['today_leaves'] as $key=>$value)
                              <tr>
                                <td>{{$value->leave_employee_details->first_name}} {{$value->leave_employee_details->middle_name}} {{$value->leave_employee_details->last_name}}</td>
                                <td>{{$value->from}}</td>
                                <td>{{$value->to}}</td>
                                <td>
                                  @if ($value->status == 0)
                                    <span class="badge rounded-pill bg-label-info me-1">Pending</span>
                                  @elseif ($value->status == 1)
                                    <span class="badge rounded-pill bg-label-success me-1">Approved</span>
                                  @elseif ($value->status == 2)
                                    <span class="badge rounded-pill bg-label-danger me-1">Rejected</span>
                                  @elseif ($value->status == 3)
                                    <span class="badge rounded-pill bg-label-warning me-1">Expired</span>
                                  @endif
                                </td>
                                <td>{{substr($value->reason,0,100)}}</td>
                                <td>
                                  <a href="{{url('/user-profile/'.$value->leave_employee_details->emp_id)}}"><span class="mdi mdi-eye text-primary"></span></a>
                                </td>
                              </tr>
                            @endforeach
                              @else
                              <tr>
                                <td colspan="5" class="text-center">No record found.</td>
                              </tr>
                            @endif
                        </tbody>
                    </table>
                  </div>
                </div>
              </div>
            </div>

          </div>
        </div>
        <!--------------- ATTENDANCE -------------------->

        <!--------------- DOCUMENTS -------------------->
        <div class="col-12">
          <div class="card">
            <div class="card-header">
              <div class="d-flex align-items-center justify-content-between">
                <h5 class="card-title m-0 me-2">Documents</h5>
              </div>
              <p class="mt-3"><span class="fw-medium">Employee Documents Details</span></p>
              <div class="nav-align-top">
                <ul class="nav nav-tabs" role="tablist">
                  <li class="nav-item border-end my-1" role="presentation">
                    <button type="button" class="nav-link waves-effect active" role="tab" data-bs-toggle="tab" data-bs-target="#expiring_documents" aria-controls="expiring_documents" aria-selected="true">
                      Expiring
                    </button>
                  </li>
                  <li class="nav-item border-end my-1" role="presentation">
                    <button type="button" class="nav-link waves-effect" role="tab" id="missingTabBtn" data-bs-toggle="tab" data-bs-target="#missing_documents" aria-controls="missing_documents" aria-selected="false" tabindex="-1">
                      Missing
                    </button>
                  </li>
                </ul>
              </div>
            </div>
            <div class="card-body">
              <div class="tab-content p-0">
                <div class="tab-pane fade active show" id="expiring_documents" role="tabpanel">
                  <div class="table-responsive text-nowrap border-bottom mt-4"  style="min-height: auto !important">
                    <table class="table table-striped">
                        <thead class="table-head-color bg-primary">
                          <tr>
                            <th>Name</th>
                            <th>Team</th>
                            <th>Document Name</th>
                            <th>Expiry Date</th>
                            <th>Pending Days</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0 table-body expiring-documents">
                          
                        </tbody>
                    </table>
                  </div>
                  <nav aria-label="Page navigation" class="mt-3">
                    <ul class="pagination justify-content-md-end justify-content-center expiring_pages_btn">
                    </ul>
                  </nav>
                </div>
                <div class="tab-pane fade" id="missing_documents" role="tabpanel">
                  <div class="table-responsive text-nowrap border-bottom missing-document-loader" style="min-height: auto !important">
                    <table class="table table-striped">
                        <thead class="table-head-color bg-primary">
                          <tr>
                            <th>Name</th>
                            <th>Team</th>
                            <th>Document Name</th>
                            <th>User Type</th>
                            <th>Action</th>
                          </tr>
                        </thead>
                        <tbody class="table-border-bottom-0 table-body missing-documents">
                        </tbody>
                    </table>
                  </div>
                  <nav aria-label="Page navigation" class="mt-3">
                    <ul class="pagination justify-content-md-end justify-content-center missing_pages_btn">
                    </ul>
                  </nav>
                </div>
              </div>
            </div>

          </div>
        </div>
        <!--------------- DOCUMENTS -------------------->


        <!-- Data Tables -->
        {{-- <div class="col-12">
          <div class="card">
            <div class="table-responsive">
              <table class="table">
                <thead class="table-light">
                  <tr>
                    <th class="text-truncate">User</th>
                    <th class="text-truncate">Email</th>
                    <th class="text-truncate">Role</th>
                    <th class="text-truncate">Age</th>
                    <th class="text-truncate">Salary</th>
                    <th class="text-truncate">Status</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/1.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Jordan Stevenson</h6>
                          <small class="text-truncate">@amiccoo</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">susanna.Lind57@gmail.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-laptop mdi-24px text-danger me-1"></i> Admin
                    </td>
                    <td class="text-truncate">24</td>
                    <td class="text-truncate">34500$</td>
                    <td><span class="badge bg-label-warning rounded-pill">Pending</span></td>
                  </tr>
                  <tr>
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/3.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Benedetto Rossiter</h6>
                          <small class="text-truncate">@brossiter15</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">estelle.Bailey10@gmail.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-pencil-outline text-info mdi-24px me-1"></i> Editor
                    </td>
                    <td class="text-truncate">29</td>
                    <td class="text-truncate">64500$</td>
                    <td><span class="badge bg-label-success rounded-pill">Active</span></td>
                  </tr>
                  <tr>
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/2.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Bentlee Emblin</h6>
                          <small class="text-truncate">@bemblinf</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">milo86@hotmail.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-cog-outline text-warning mdi-24px me-1"></i> Author
                    </td>
                    <td class="text-truncate">44</td>
                    <td class="text-truncate">94500$</td>
                    <td><span class="badge bg-label-success rounded-pill">Active</span></td>
                  </tr>
                  <tr>
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/5.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Bertha Biner</h6>
                          <small class="text-truncate">@bbinerh</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">lonnie35@hotmail.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-pencil-outline text-info mdi-24px me-1"></i> Editor
                    </td>
                    <td class="text-truncate">19</td>
                    <td class="text-truncate">4500$</td>
                    <td><span class="badge bg-label-warning rounded-pill">Pending</span></td>
                  </tr>
                  <tr>
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/4.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Beverlie Krabbe</h6>
                          <small class="text-truncate">@bkrabbe1d</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">ahmad_Collins@yahoo.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-chart-donut mdi-24px text-success me-1"></i> Maintainer
                    </td>
                    <td class="text-truncate">22</td>
                    <td class="text-truncate">10500$</td>
                    <td><span class="badge bg-label-success rounded-pill">Active</span></td>
                  </tr>
                  <tr>
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/7.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Bradan Rosebotham</h6>
                          <small class="text-truncate">@brosebothamz</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">tillman.Gleason68@hotmail.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-pencil-outline text-info mdi-24px me-1"></i> Editor
                    </td>
                    <td class="text-truncate">50</td>
                    <td class="text-truncate">99500$</td>
                    <td><span class="badge bg-label-warning rounded-pill">Pending</span></td>
                  </tr>
                  <tr>
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/6.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Bree Kilday</h6>
                          <small class="text-truncate">@bkildayr</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">otho21@gmail.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-account-outline mdi-24px text-primary me-1"></i> Subscriber
                    </td>
                    <td class="text-truncate">23</td>
                    <td class="text-truncate">23500$</td>
                    <td><span class="badge bg-label-success rounded-pill">Active</span></td>
                  </tr>
                  <tr class="border-transparent">
                    <td>
                      <div class="d-flex">
                        <div class="avatar avatar-sm me-3">
                          <img src="assets/img/avatars/1.png" alt="Avatar" class="rounded-circle" />
                        </div>
                        <div>
                          <h6 class="mb-0 text-truncate">Breena Gallemore</h6>
                          <small class="text-truncate">@bgallemore6</small>
                        </div>
                      </div>
                    </td>
                    <td class="text-truncate">florencio.Little@hotmail.com</td>
                    <td class="text-truncate">
                      <i class="mdi mdi-account-outline mdi-24px text-primary me-1"></i> Subscriber
                    </td>
                    <td class="text-truncate">33</td>
                    <td class="text-truncate">20500$</td>
                    <td><span class="badge bg-label-secondary rounded-pill">Inactive</span></td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div> --}}
        <!--/ Data Tables -->
      </div>
    </div>


@endsection






@section('css-js')
    <script>
      function loader_table(show) {
        if(show == true)
        {
          $('.missing-documents').html(`<tr><td colspan="4">Please Wait...</td></tr>`);
          $('.table_loader').removeClass('d-none');
        }
        else
        {
          $('.table_loader').addClass('d-none');
        }
      }

      $(document).ready(function () {
        loader_table(false);
        get_expiring_document(0);
        get_present_employee(0);
      });
      
      $('#missingTabBtn').on('click', function() {
          // Call your custom function here
          get_missing_document(0);
      });

      $('#absentEmployeeTabBtn').on('click', function() {
          // Call your custom function here
          get_absent_employee(0);
      });

      function get_expiring_document(from)
      {
        loader_table(true);              
        $.ajax({
          type: "GET",
          url: `{{url('/get-expiring-document')}}?from=${from}`,
          headers: {
              'X-CSRF-TOKEN': '{{csrf_token()}}'
          },
          success: function(response) {
            var documents = response.data.expiring_documents;

            var html = ``;
            var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
            count = Math.ceil(count);

            var pages_btn = ``;

            pages_btn += `<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="get_expiring_document(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                          </li>
                          <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                          </li>`;
            $('.p-btn').removeClass('active');

            var c = 0;
            for (c = 0; c < count; c++) {
                if (
                    (from == (c - 3) * 10) ||
                    (from == (c - 2) * 10) ||
                    (from == (c - 1) * 10) ||
                    (from == (c - 0) * 10) ||
                    (from == (c + 1) * 10) ||
                    (from == (c + 2) * 10) ||
                    (from == (c + 3) * 10)
                ) {
                    pages_btn += `
                      <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="get_expiring_document(${c*10});">
                        <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                      </li>`;
                }

            }

            pages_btn += `<li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                          </li>
                          <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="get_expiring_document(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                          </li>`;

            $('.expiring_pages_btn').html(pages_btn);
            for (var i = 0; i < documents.length; i++) {
              html += `
                    <tr>
                      <td><span class="fw-medium">${documents[i].first_name !== null ? documents[i].first_name : ''} ${documents[i].middle_name !== null ? documents[i].middle_name : ''} ${documents[i].last_name !== null ? documents[i].last_name : ''}</span></td>
                      <td><span class="fw-medium">${documents[i].team_titles?.replace(/,/g, "<br>")}</span></td>
                      <td><span class="fw-medium">${documents[i].document_title}</span></td>
                      <td><span class="fw-medium">${documents[i].expiry_date}</span></td>
                      <td><span class="fw-medium">${documents[i].remaining_days}</span></td>
                      <td>
                        <span class="fw-medium">
                          <a class="dropdown-item py-1 ps-2"  target="_blank" href="{{ url('/') }}/${documents[i].document_path}" ><span class="mdi mdi-eye mdi-20px text-warning"></span></a>
                        </span>
                      </td>
                    </tr>`;
            }

            $('.expiring-documents').html(html);

            if (html == ``) {
                $('.expiring-documents').html(
                    `<tr><td colspan="8" class="text-center">No record found.</td></tr>`);
            }

            loader_table(false);

          },
          error: function(response) {
            loader_table(false);
            if (response.status == 422) {
            var errors = response.responseJSON.data;                    
            $.each(errors, function(field, messages) {
                  error_msg = messages[0]; 
                  toastr.error(error_msg);
            });
            } else  if (response.status == 500) {
              toastr.error("Something went wrong")
            } else {
              toastr.error(response.responseJSON.message)
            }
          }
        });

      }

      function get_missing_document(from){

        loader_table(true);              
        $.ajax({
          type: "GET",
          url: `{{url('/get-missing-document')}}?from=${from}`,
          headers: {
              'X-CSRF-TOKEN': '{{csrf_token()}}'
          },
          success: function(response) {
            var documents = response.data.missing_documents;

            var html = ``;
            var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
            count = Math.ceil(count);

            var pages_btn = ``;

            pages_btn += `<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="get_missing_document(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                          </li>
                          <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                          </li>`;
            $('.p-btn').removeClass('active');

            var c = 0;
            for (c = 0; c < count; c++) {
                if (
                    (from == (c - 3) * 10) ||
                    (from == (c - 2) * 10) ||
                    (from == (c - 1) * 10) ||
                    (from == (c - 0) * 10) ||
                    (from == (c + 1) * 10) ||
                    (from == (c + 2) * 10) ||
                    (from == (c + 3) * 10)
                ) {
                    pages_btn += `
                      <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="get_missing_document(${c*10});">
                        <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                      </li>`;
                }

            }

            pages_btn += `<li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                          </li>
                          <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="get_missing_document(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                          </li>`;

            $('.missing_pages_btn').html(pages_btn);
            for (var i = 0; i < documents.length; i++) {
              html += `
                    <tr>
                      <td><span class="fw-medium">${documents[i].first_name !== null ? documents[i].first_name : ''} ${documents[i].middle_name !== null ? documents[i].middle_name : ''} ${documents[i].last_name !== null ? documents[i].last_name : ''}</span></td>
                      <td><span class="fw-medium">${documents[i].team_titles?.replace(/,/g, "<br>")}</span></td>
                      <td><span class="fw-medium">${documents[i].document_title}</span></td>
                      <td><span class="fw-medium">${documents[i].user_type == 0 ? '<span class="badge rounded-pill bg-label-success me-1">Internal</span>' : '<span class="badge rounded-pill bg-label-warning me-1">External</span>'}</span></td>
                      <td>
                        <a class="dropdown-item py-1 ps-2" onclick="window.location.href='{{ url('/') }}${documents[i].user_type == 0  ? '/employee-onboarding/create/documents-certifications/' : '/edit-external-employee/'  }${documents[i]?.emp_id}'">
                          <span class="mdi mdi-cloud-upload mdi-20px text-info"></span>
                        </a>
                      </td>
                    </tr>`;
            }

            $('.missing-documents').html(html);

            if (html == ``) {
                $('.missing-documents').html(
                    `<tr><td colspan="8" class="text-center">No record found.</td></tr>`);
            }

            loader_table(false);

          },
          error: function(response) {
            loader_table(false);
            if (response.status == 422) {
            var errors = response.responseJSON.data;                    
            $.each(errors, function(field, messages) {
                  error_msg = messages[0]; 
                  toastr.error(error_msg);
            });
            } else  if (response.status == 500) {
              toastr.error("Something went wrong")
            } else {
              toastr.error(response.responseJSON.message)
            }
          }
        });
      }

      function get_present_employee(from){
        loader_table(true);              
        $.ajax({
          type: "GET",
          url: `{{url('/get-present-employees')}}?from=${from}`,
          headers: {
              'X-CSRF-TOKEN': '{{csrf_token()}}'
          },
          success: function(response) {
            var today_present = response.data.today_present;

            var html = ``;
            var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
            count = Math.ceil(count);

            var pages_btn = ``;

            pages_btn += `<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="get_present_employee(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                          </li>
                          <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                          </li>`;
            $('.p-btn').removeClass('active');

            var c = 0;
            for (c = 0; c < count; c++) {
                if (
                    (from == (c - 3) * 10) ||
                    (from == (c - 2) * 10) ||
                    (from == (c - 1) * 10) ||
                    (from == (c - 0) * 10) ||
                    (from == (c + 1) * 10) ||
                    (from == (c + 2) * 10) ||
                    (from == (c + 3) * 10)
                ) {
                    pages_btn += `
                      <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="get_present_employee(${c*10});">
                        <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                      </li>`;
                }

            }

            pages_btn += `<li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                          </li>
                          <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="get_present_employee(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                          </li>`;

            $('.present_pages_btn').html(pages_btn);
            for (var i = 0; i < today_present.length; i++) {
              html += `
                    <tr>
                      <td><span class="fw-medium">${today_present[i].present_employee_details.first_name !== null ? today_present[i].present_employee_details.first_name : ''} ${today_present[i].present_employee_details.middle_name !== null ? today_present[i].present_employee_details.middle_name : ''} ${today_present[i].present_employee_details.last_name !== null ? today_present[i].present_employee_details.last_name : ''}</span></td>
                      <td><span class="fw-medium">${today_present[i].employee_site.title}</span></td>
                      <td><span class="fw-medium">${today_present[i].formatted_date}</span></td>
                      <td><span class="fw-medium">${today_present[i].formatted_check_in}</span></td>
                      <td><span class="fw-medium">${today_present[i].formatted_check_out}</span></td>
                    </tr>`;
            }

            $('.present-employees').html(html);

            if (html == ``) {
                $('.present-employees').html(
                    `<tr><td colspan="8" class="text-center">No record found.</td></tr>`);
            }

            loader_table(false);

          },
          error: function(response) {
            loader_table(false);
            if (response.status == 422) {
            var errors = response.responseJSON.data;                    
            $.each(errors, function(field, messages) {
                  error_msg = messages[0]; 
                  toastr.error(error_msg);
            });
            } else  if (response.status == 500) {
              toastr.error("Something went wrong")
            } else {
              toastr.error(response.responseJSON.message)
            }
          }
        });
      }

      function get_absent_employee(from){
        loader_table(true);              
        $.ajax({
          type: "GET",
          url: `{{url('/get-absent-employees')}}?from=${from}`,
          headers: {
              'X-CSRF-TOKEN': '{{csrf_token()}}'
          },
          success: function(response) {
            var absent_employees = response.data.absent_employees;

            var html = ``;
            var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
            count = Math.ceil(count);

            var pages_btn = ``;

            pages_btn += `<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="get_absent_employee(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                          </li>
                          <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                          </li>`;
            $('.p-btn').removeClass('active');

            var c = 0;
            for (c = 0; c < count; c++) {
                if (
                    (from == (c - 3) * 10) ||
                    (from == (c - 2) * 10) ||
                    (from == (c - 1) * 10) ||
                    (from == (c - 0) * 10) ||
                    (from == (c + 1) * 10) ||
                    (from == (c + 2) * 10) ||
                    (from == (c + 3) * 10)
                ) {
                    pages_btn += `
                      <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="get_absent_employee(${c*10});">
                        <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                      </li>`;
                }

            }

            pages_btn += `<li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                          </li>
                          <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="get_absent_employee(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                          </li>`;

            $('.absent_pages_btn').html(pages_btn);
            for (var i = 0; i < absent_employees.length; i++) {
              html += `
                    <tr>
                      <td><span class="fw-medium">${absent_employees[i].first_name !== null ? absent_employees[i].first_name : ''} ${absent_employees[i].middle_name !== null ? absent_employees[i].middle_name : ''} ${absent_employees[i].last_name !== null ? absent_employees[i].last_name : ''}</span></td>
                      <td><span class="fw-medium">${absent_employees[i].employee_email}</span></td>
                      <td><span class="fw-medium">${absent_employees[i].title}</span></td>
                      <td>
                        <a href="${'/user-profile/'}${absent_employees[i]?.id}" class="dropdown-item py-1 ps-2" target="_blank" onclick="window.location.href='{{ url('/') }}${'/user-profile/'}${absent_employees[i]?.id}'">
                          <span class="mdi mdi-cloud-upload mdi-20px text-info"></span>
                        </a>
                      </td>
                    </tr>`;
            }

            $('.absent-employees').html(html);

            if (html == ``) {
                $('.absent-employees').html(
                    `<tr><td colspan="8" class="text-center">No record found.</td></tr>`);
            }

            loader_table(false);

          },
          error: function(response) {
            loader_table(false);
            if (response.status == 422) {
            var errors = response.responseJSON.data;                    
            $.each(errors, function(field, messages) {
                  error_msg = messages[0]; 
                  toastr.error(error_msg);
            });
            } else  if (response.status == 500) {
              toastr.error("Something went wrong")
            } else {
              toastr.error(response.responseJSON.message)
            }
          }
        });
      }

    </script>
    <style>
     /* css js here*/
    </style>
@endsection
