<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Email Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f5f5f5;
            padding-top: 30px;
        }
        .email-test-container {
            max-width: 700px;
            margin: 0 auto;
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
        }
        .form-group {
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container email-test-container">
        <h1 class="mb-4">Email Test Tool</h1>
        
        <div id="response-message" class="alert d-none mb-4"></div>
        
        <form id="email-test-form">
            <div class="form-group">
                <label for="customer_id">Customer ID</label>
                <input type="number" class="form-control" id="customer_id" required>
            </div>
            
            <div class="form-group">
                <label for="to">To Email</label>
                <input type="email" class="form-control" id="to" required>
            </div>
            
            <div class="form-group">
                <label for="name">Recipient Name (optional)</label>
                <input type="text" class="form-control" id="name">
            </div>
            
            <div class="form-group">
                <label for="custom_message">Custom Message (optional)</label>
                <textarea class="form-control" id="custom_message" rows="3"></textarea>
            </div>
            
            <div class="form-group">
                <label for="cc">CC (optional)</label>
                <input type="email" class="form-control" id="cc">
            </div>
            
            <div class="form-group">
                <label for="bcc">BCC (optional)</label>
                <input type="email" class="form-control" id="bcc">
            </div>
            
            <button type="submit" class="btn btn-primary">Send Test Email</button>
        </form>
    </div>

    <script>
        document.getElementById('email-test-form').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Get form data
            const formData = {
                customer_id: document.getElementById('customer_id').value,
                to: document.getElementById('to').value,
                name: document.getElementById('name').value || null,
                custom_message: document.getElementById('custom_message').value || null,
                cc: document.getElementById('cc').value || null,
                bcc: document.getElementById('bcc').value || null
            };
            
            // Show loading state
            const submitBtn = this.querySelector('button[type="submit"]');
            const originalBtnText = submitBtn.innerHTML;
            submitBtn.innerHTML = 'Sending...';
            submitBtn.disabled = true;
            
            // Send API request
            fetch('/api/test-email', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                body: JSON.stringify(formData)
            })
            .then(response => response.json())
            .then(data => {
                // Show response message
                const msgElement = document.getElementById('response-message');
                msgElement.classList.remove('d-none', 'alert-success', 'alert-danger');
                
                if (data.success) {
                    msgElement.classList.add('alert-success');
                    msgElement.textContent = 'Email sent successfully!';
                } else {
                    msgElement.classList.add('alert-danger');
                    msgElement.textContent = data.message || 'Failed to send email.';
                }
                
                // Reset button
                submitBtn.innerHTML = originalBtnText;
                submitBtn.disabled = false;
            })
            .catch(error => {
                // Show error message
                const msgElement = document.getElementById('response-message');
                msgElement.classList.remove('d-none', 'alert-success', 'alert-danger');
                msgElement.classList.add('alert-danger');
                msgElement.textContent = 'An error occurred while sending the email.';
                
                // Reset button
                submitBtn.innerHTML = originalBtnText;
                submitBtn.disabled = false;
                
                console.error('Error:', error);
            });
        });
    </script>
</body>
</html> 