@if (isset($data))


    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Incident Report</title>
        <style>
            /* Reset styles */
            @page {
                padding: 20px 0px 80px 0px;
            }

            * {
                margin: 0;
                padding: 0;
                box-sizing: border-box;
            }

            /* Page layout */
            body {
                font-family: 'Poppins', sans-serif;
                margin: 0;
                padding: 0;
            }

            .header {
                position: fixed;
                top: 0;
                width: 100%;
                background: transparent;
                padding: 40px 50px;
                z-index: 1000;
            }

            /* Content area */
            .content {
                padding-top: 20px;
                padding-bottom: 60px;
                margin: 0px;
                padding-left: 0px;
                padding-right: 0px;
            }

            /* Footer styles */
            .footer {
                position: fixed;
                bottom: 0;
                width: 100%;
                background-color: #fff;
                font-size: 16px;
                padding: 10px 0;
                border-top: 1px solid #cccccc;
                z-index: 1000;
            }

            /* Page break for large content */
            .page-break {
                page-break-before: always;
            }

            .wrapper {
                position: relative;
                top: 100px;
                padding-bottom: 150px;

            }
        </style>
    </head>

    <body style="margin: 0px;padding: 0px;font-family: 'Poppins', sans-serif;">
        <div class="header">
            <table width="100%" style="border-collapse: collapse;">
                <tr>
                    <td style="width: 35%; padding-right: 10px;">
                        <img src="{{'/assets/img/pdf_logo.png'}}" alt="" width="55%">
                    </td>
                    <td style="text-align: center; font-size: 18px; font-weight: 600; margin: 0; color: #d2d2d2; word-wrap: break-word; overflow-wrap: break-word;">
                        Incident Investigation Report
                    </td>
                </tr>
            </table>
        </div>
        <div class="wrapper">
            <div class="content">
                <div
                    style="width: 95%;margin: auto;display: flex;align-items: center;background-color: #F3FBFF;padding: 30px 0px;">
                    <table width="100%" style="border-collapse: collapse;">
                        <tr>
                            <td style="border-right: 1px solid #1E1E1E;padding: 15px 30px;width: 50%;">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        TITLE:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->title ?? 'N/A' }}</span>
                                    </p>
                                </div>
                            </td>
                            <td style="padding: 15px 30px;width: 50%;">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        DOCUMENT NUMBER:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->document_number ?? 'N/A' }}</span>
                                    </p>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 50%;border-right: 1px solid #1E1E1E;padding: 0px 30px;">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #059EF3;">
                                        AUTHORISED BY:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->main_details_first_name ?? 'N/A' }}
                                            {{ $data->main_details_last_name ?? '' }}</span>
                                    </p>
                                </div>
                            </td>
                            <td style="width: 50%;padding: 0px 30px">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #059EF3;">
                                        ISSUE DATE:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->issue_date ?? 'N/A' }}</span>
                                    </p>
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <!--  -->
                            <td style="width: 50%;padding: 15px 30px;border-right: 1px solid #1E1E1E;">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        REVISION DATE:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->revision_date ?? 'N/A' }}</span>
                                    </p>
                                </div>
                            </td>
                            <td style="width: 50%;padding: 15px 30px;">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        REVISION NUMBER:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->revision_number ?? 'N/A' }}</span>
                                    </p>
                                </div>

                            </td>
                        </tr>

                        <tr>
                            <td style="width: 50%;padding: 15px 30px;border-right: 1px solid #1E1E1E;">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        Site:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->site_title ?? 'N/A' }}</span>
                                    </p>
                                </div>
                            </td>
                            @if ($supervisors && $supervisors->count() > 0)
                                <td style="width: 10%; padding: 15px 30px; border-right: 1px solid #1E1E1E;">
                                    <div>
                                        <p
                                            style="font-family: 'Poppins', sans-serif; font-size: 16px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                            Supervisors:
                                            <span style="font-weight: 400; color: #595959;">
                                                &nbsp;
                                                @foreach ($supervisors as $supervisor)
                                                    {{ $supervisor->emp_personal_supervisor_detail_f_name }}
                                                    {{ $supervisor->emp_personal_supervisor_detail_last_name }}
                                                    @if (!$loop->last), @endif  
                                                @endforeach
                                            </span>
                                        </p>
                                    </div>
                                </td>
                            @else
                                <td style="width: 50%; padding: 15px 30px; border-right: 1px solid #1E1E1E;">
                                    <div>
                                        <p
                                            style="font-family: 'Poppins', sans-serif; font-size: 16px; font-weight: 600; margin: 0px; color: #1E1E1E;">
                                            Supervisors:
                                            <span style="font-weight: 400; color: #595959;">
                                                &nbsp; N/A
                                            </span>
                                        </p>
                                    </div>
                                </td>
                            @endif


                        </tr>
                        <tr>
                            <td style="width: 50%;padding: 15px 30px;border-right: 1px solid #1E1E1E;">
                                <div>
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        Forman:
                                        <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->emp_personal_forman_detail_f_name ?? 'N/A' }}
                                            {{ $data->emp_personal_forman_detail_last_name ?? '' }}</span>
                                    </p>
                                </div>
                            </td>
                        </tr>

                    </table>
                </div>
                <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                    <h2 style="font-size: 21px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">PART A –
                        Incident Details (Must be completed for all Injuries / Incidents)</h2>
                </div>
                <div style="margin: 15px 0px;">
                    <table width="100%" style="border-collapse: collapse;">
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding-left: 30px;padding-bottom: 15px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    PROJECT INCIDENT INVESTIGATION NUMBER: <span
                                        style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->investigation_number ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 0px 30px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    OFFICE NUMBER: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->office_number ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    PROJECT NAME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->project_title ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    PROJECT NUMBER: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->project_numbers ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    REPORT COMPILED BY: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->reported_by_first_name ?? 'N/A' }}
                                        {{ $data->reported_by_last_name ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    ROLE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->reported_bys_title ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    END DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->date ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    DATE OF INCIDENT: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_date ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            {{-- <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    INCIDENT REPORT TO: <span style="font-weight: 400;color: #595959;">&nbsp; {{
                                        $data->roles_reported_to_first_name ?? 'N/A' }}
                                        {{ $data->roles_reported_to_last_name ?? 'N/A' }}</span>
                                </p>

                            </td> --}}
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    INCIDENT REPORT TO: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->reported_by_first_name ?? 'N/A' }}
                                        {{ $data->reported_by_last_name ?? '' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    REPORT TO COMPANY NAME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_report_to_company_name ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                @if ($data->roles_reported_to_last_name_reported_to && !is_numeric($data->roles_reported_to_last_name_reported_to))
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        REPORT TO POSITION: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->roles_reported_to_last_name_reported_to ?? 'N/A' }}
                                        </span>
                                    </p>
                                @else
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        REPORT TO POSITION: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->roles_reported_to_first_name ?? 'N/A' }}
                                            {{ $data->reported_tos_title ?? 'N/A' }}</span>
                                    </p>
                                @endif

                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    REPORT TO CONTACT NUMBER: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_report_to_contact_number ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    TIME OF INCIDENT: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_time ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    DATE INCIDENT REPORTED: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->date_incident_reported ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    TIME INCIDENT REPORTED : <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->time_incident_reported ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    INCIDENT REPORT BY: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{$data->reported_by_first_name ?? 'N/A' }}
                                        {{$data->reported_by_last_name ?? ''}}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;" colspan="2">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    INCIDENT REPORT BY COMPANY NAME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_report_bys_company_name ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>

                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px;" colspan="2">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    INCIDENT REPORT BY CONTACT NUMBER: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_report_bys_contact_number ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                    </table>
                </div>
                <div style="position:fixed;width:100%;padding:5px 0px; bottom:0;border-top:1px solid #cccccc">
                    <div style="margin-left: 30px;margin-right: 30px;">
                        <table style="width:100%;">
                            <tr>
                                <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Title:</td>
                                <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                                    {{ $data->title ?? 'N/A' }}
                                </td>
                                <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Document Number:
                                </td>
                                <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                                    {{ $data->document_number ?? 'N/A' }}
                                </td>
                            </tr>
                            <tr>
                                <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Revision Number:
                                </td>
                                <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                                    {{ $data->revision_number ?? 'N/A' }}
                                </td>
                                <td style="width: 45%; font-weight:600; text-align:left;font-size:14px;">Revision Date:</td>
                                <td style="width: 55%; color:#7a7a7a; font-weight: 300; text-align:left;font-size:14px;">
                                    {{ $data->revision_date ?? 'N/A' }}
                                </td>
                            </tr>
                        </table>
                    </div>

                </div>
                <!-- <div class="page-break"></div> -->
                <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">

                    <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Initial
                        injury classification</h2>
                </div>
                <table width="100%" style="border-collapse: collapse;">
                    <tbody>
                        <tr>
                            <td style="padding: 15px 30px;">
                                @if ($dataClassifications->isNotEmpty()) <!-- Check if the collection is not empty -->
                                    @foreach($dataClassifications as $data_classification)
                                        @if($data_classification->incident_injury_classifications_title)
                                            <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                                <div
                                                    style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                    <div style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                    </div>
                                                </div>
                                                {{ $data_classification->incident_injury_classifications_title }}
                                            </label>
                                        @endif

                                    @endforeach
                                @else
                                    <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                        <div
                                            style="border: 1px solid #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                            <div style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                            </div>
                                        </div>
                                        N/A
                                    </label>
                                @endif
                            </td>
                        </tr>
                    </tbody>
                </table>

                <div>
                    <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                        <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                            Notifiable Incident Classification
                        </h2>
                    </div>
                    <table width="100%" style="border-collapse: collapse;">
                        <tbody>
                            <tr>
                                <td style="padding: 15px 30px;">
                                    @if ($data->incident_notified_tos_ohs_regulator == 1)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Serious Injury Illness Of A Person
                                            (Refer To Section 36 Of The WHS Act For A Definition Of SeriousInjury Illness Of A
                                            Person)
                                        </label>
                                    @elseif($data->incident_notified_tos_ohs_regulator == 2)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Dangerous Incident
                                            (Refer To Section 37 Of The WHS Act For A Definition Of Dangerous Incident)
                                        </label>
                                    @elseif($data->incident_notified_tos_ohs_regulator == 3)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Death
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            N/A
                                        </label>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div>
                    <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                        <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">OHS
                            Regulator (Refer To Section 35 Of The WHS Act For A Definition Of Notifiable Incident)</h2>
                    </div>
                    <table width="100%" style="border-collapse: collapse;">
                        <tr>
                            @if ($data->notifiable_classification_id)
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                        <div
                                            style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                            <div style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                            </div>
                                        </div>
                                        {{ $data->notifiable_classification_title ?? 'N/A' }}
                                    </label>
                                </td>
                            @endif
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    REFERENCE NUMBER: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_notified_tos_reference_number ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    CONTACT NAME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_notified_tos_contact_name ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_notified_tos_date ?? 'N/A' }}</span>
                                </p>
                            </td>
                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    TIME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                        {{ $data->incident_notified_tos_time ?? 'N/A' }}</span>
                                </p>
                            </td>
                        </tr>
                    </table>
                </div>
                <div>
                    <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                        <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">Was
                            there more than one person injured / Involved?
                        </h2>
                    </div>
                    <table width="100%" style="border-collapse: collapse;">
                        <tbody>
                            <tr>
                                <td style="padding: 15px 30px;">
                                    @if ($data->involved_persons)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Yes (If Yes, Then Complete An Incident Investigation Report For Each Injured /
                                            Involved
                                            Person).
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            No
                                        </label>
                                    @endif
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div>
                    <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                        <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                            Injured / Involved Persons Details </h2>
                    </div>
                    {{-- @dd($incident_involved_person_details); --}}

                    {{-- <table width="100%" style="border-collapse: collapse; border: 1px solid #1E1E1E;">
                        @foreach ($incident_involved_person_details['incident_involved'] as $key => $incident_involved)
                                        <tr>
                                            <td colspan="2" style="border-bottom: 1px solid #1E1E1E; padding: 15px 30px;">
                                                <h5
                                                    style="font-size: 18px; font-weight: 600; margin: 0; color: #000000; text-transform: uppercase;">
                                                    Number #{{$key + 1}}
                                                </h5>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>EMPLOYEE:</strong> {{ $incident_involved['injured_employee_first_name'] }}
                                                {{ $incident_involved['injured_employee_last_name'] }}
                                            </td>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <!-- <strong>SURNAME:</strong> {{ $incident_involved['surname'] }} -->
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>Age:</strong> {{ $incident_involved['age'] }}
                                            </td>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>DOB:</strong> {{ $incident_involved['dob'] }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>OCCUPATION:</strong> {{ $incident_involved['occupation'] }}
                                            </td>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>LANGUAGE:</strong> {{ $incident_involved['language'] }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>GENDER:</strong>
                                                @if ($incident_involved['gender'] == 0) Male
                                                @elseif ($incident_involved['gender'] == 1) Female
                                                @else N/A @endif
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2"
                                                style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E; color: #059EF3; font-size: 16px; font-weight: 600;">
                                                Experience In Task (when Incident Occurred)
                                            </td>
                                        </tr>

                                        <tr>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>MONTHS:</strong> {{ $incident_involved['experience_months'] }}
                                            </td>
                                            <td style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>YEARS:</strong> {{ $incident_involved['experience_years'] }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>REFERENCE NUMBER:</strong>
                                                {{ $incident_involved['incident_notified_tos_reference_number'] }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2"
                                                style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E; color: #059EF3; font-size: 16px; font-weight: 600;">
                                                TYPE OF EMPLOYMENT
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                @if ($incident_involved['employee_types_title'])
                                                    <div style="display: inline-block; background: #059EF3; padding: 5px; margin-right: 15px;">
                                                        <div style="width: 12px; height: 12px; background-color: #fff; border-radius: 50%;">
                                                        </div>
                                                    </div>
                                                @endif
                                                {{ $incident_involved['employee_types_title'] }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2"
                                                style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E; color: #059EF3; font-size: 16px; font-weight: 600;">
                                                TYPE OF EMPLOYEE
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                @if ($incident_involved['employee_type'])
                                                    <div style="display: inline-block; background: #059EF3; padding: 5px; margin-right: 15px;">
                                                        <div style="width: 12px; height: 12px; background-color: #fff; border-radius: 50%;">
                                                        </div>
                                                    </div>
                                                @endif
                                                {{ $incident_involved['employee_type'] }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                <strong>SUPERVISOR:</strong> {{ $incident_involved['supervisor_first_name'] ?? '' }}
                                                {{ $incident_involved['supervisor_last_name'] ?? '' }}
                                            </td>
                                        </tr>

                                        <tr>
                                            <td colspan="2"
                                                style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E; color: #059EF3; font-size: 16px; font-weight: 600;">
                                                Training Provided to Injured / Involved Person
                                            </td>
                                        </tr>

                                        @php
                                            $titles = explode(',', $incident_involved['employee_trainings_title']);
                                            $notes = $incident_involved['training_other_note'] ?? '';
                                        @endphp

                                        @foreach ($titles as $title)
                                            <tr>
                                                <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                    <strong>{{ trim($title) }}</strong>
                                                </td>
                                            </tr>
                                            @if (trim($title) == 'Other' && $notes)
                                                <tr>
                                                    <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                        <strong>Note:</strong> {{ $notes }}
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach

                                        <tr>

                                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;" colspan="2">
                                                <p
                                                    style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #059EF3;">
                                                    SUPERVISOR (OF INJURED / INVOLVED WORKER): <span
                                                        style="font-weight: 400;color: #595959;">&nbsp;
                                                        {{ $incident_involved['incident_notified_tos_time']}}</span>
                                                </p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                                <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">

                                                    {{ $incident_involved['supervisor_first_name'] ?? '' }}
                                                    {{ $incident_involved['supervisor_last_name'] ?? '' }}
                                                </label>
                                            </td>
                                            <td></td>
                                        </tr>
                                        <tr>
                                            <td>
                                                <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;width:100vw">
                                                    <h2
                                                        style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                                        Training Provided to Injured / Involved Person: </h2>
                                                </div>
                                            </td>
                                        </tr>
                                        @php
                                            $titles = explode(',', $incident_involved['employee_trainings_title']);
                                            $notes = $incident_involved['training_other_note'] ?? '';  // Assuming this field exists and is formatted similarly
                                        @endphp

                                        @foreach ($titles as $index => $title)
                                            @php $trimmedTitle = trim($title); @endphp
                                            <tr>
                                                <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 0px 15px 30px;" colspan="2">
                                                    <label for="" style="font-size: 16px; font-weight: 600; color: #1E1E1E;">
                                                        {{ $trimmedTitle }}
                                                    </label>
                                                </td>
                                            </tr>
                                            @if ($trimmedTitle == 'Other' && $notes)
                                                <tr>
                                                    <td style="border-bottom: 1px solid #1E1E1E; padding: 15px 0px 15px 30px;" colspan="2">
                                                        <label for="" style="font-size: 16px; font-weight: 600; color: #1E1E1E;">
                                                            Note: {{ $notes }}
                                                        </label>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach



                                        @foreach ($incident_involved['incident_employee_injury_types'] as $incident_employee_injury_types)  
                                                                                                                                                                                        <tr>
                                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                                    <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                                        @if ($incident_employee_injury_types->option)
                                                            <div
                                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                                <div style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                                </div>
                                                            </div>
                                                        @endif
                                                        {{ ucwords(str_replace('_', ' ', $incident_employee_injury_types->option)) }}:
                                                        <span
                                                            style="font-weight: 400;color: #595959;">&nbsp;{{ $incident_employee_injury_types->value ?? '' }}</span>
                                                    </label>
                                                </td>
                                            </tr>
                                        @endforeach
                                        @foreach ($incident_involved['incident_employee_injury_types'] as $injury)
                                            <tr>
                                                <td colspan="2" style="padding: 15px 30px; border-bottom: 1px solid #1E1E1E;">
                                                    @if ($injury->option)
                                                        <div style="display: inline-block; background: #059EF3; padding: 5px; margin-right: 15px;">
                                                            <div style="width: 12px; height: 12px; background-color: #fff; border-radius: 50%;">
                                                            </div>
                                                        </div>
                                                    @endif
                                                    <strong>{{ ucwords(str_replace('_', ' ', $injury->option)) }}:</strong>
                                                    {{ $injury->value ?? '' }}
                                                </td>
                                            </tr>
                                        @endforeach
                        @endforeach
                    </table> --}}

                    {{-- <table width="100%" style="border-collapse: collapse;">
                        <tr>

                            <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px;">
                                <p
                                    style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                    Is Employer Of The Worker : <span style="font-weight: 400;color: #595959;">&nbsp; {{
                                        $data->incident_employer_details_is_employer_worker??'' }}</span>
                                </p>
                            </td>
                        </tr>
                    </table> --}}
                </div>
                <div>



                    <div>

                        {{-- <table width="100%" style="border-collapse: collapse;"> --}}
                            {{-- <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                        @if ($data->employee_trainings_title)
                                        <div
                                            style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                            <div
                                                style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                            </div>
                                        </div>
                                        @endif
                                        {{ $data->employee_trainings_title ?? 'N/A' }}
                                    </label>
                                </td>
                            </tr> --}}
                            {{-- <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        Nature of Injury: <span style="font-weight: 400;color: #595959;">&nbsp; {{
                                            $data->incident_notified_tos_reference_number ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        BODILY LOCATION: <span style="font-weight: 400;color: #595959;">&nbsp; {{
                                            $data->incident_notified_tos_date ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        NATURE OF DISEASE: <span style="font-weight: 400;color: #595959;">&nbsp; {{
                                            $data->incident_employee_injury_types_options ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        BREAKDOWN OF INJURY / AGENCY OF INJURY: <span
                                            style="font-weight: 400;color: #595959;">&nbsp; {{
                                            $data->incident_notified_tos_time
                                            ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        MECHANISM OF INJURY / DISEASE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{
                                            $data->incident_notified_tos_time ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        INCIDENT EMPLOYEE INJURY TYPES EMPLOYER NAME: <span
                                            style="font-weight: 400;color: #595959;">&nbsp; {{
                                            $data->incident_employer_details_employer_name ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table> --}}
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Shift / Part of Shift</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding:15px 30px 15px;" colspan="2">
                                    <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                        @if (isset($data->incident_report_employee_shift_type))
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                        @endif
                                        {{ $data->incident_report_employee_shift_type ?? 'N/A' }}
                                    </label>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding:15px 30px 15px;" colspan="2">
                                    <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                        @if (isset($data->incident_report_employee_shift_time))
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                        @endif
                                        {{ $data->incident_report_employee_shift_time ?? 'N/A' }}
                                    </label>
                                </td>
                            </tr>
                            @foreach ($questionsAndAnswers as $qa)
                                <tr>
                                    <td style="border-bottom: 1px solid #1E1E1E;padding:15px 30px 15px;" colspan="2">
                                        <p
                                            style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                            {{ $qa->question }}: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                {{ $qa->answer ?? 'N/A' }}</span>
                                        </p>
                                    </td>
                                </tr>
                            @endforeach
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Incident Involving Plant / Property.</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    @if ($data->plant_name == 0)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Fastform Plant / Equipment
                                        </label>
                                    @elseif ($data->plant_name == 1)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Contractor Plant / Equipment
                                        </label>
                                    @elseif ($data->plant_name == 2)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Contractor Plant / Equipment
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            N/A
                                        </label>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        EQUIPMENT TYPE OR PROPERTY DESCRIPTION: <span
                                            style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_report_employee_equipment_type ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        DAMAGE / LOSS: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_report_employee_damage ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        APPROX COST / VALUE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_report_employee_cost ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Is a
                                corrective action(s) required for this incident?</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 30px 0px 15px 30px;">
                                    @if ($data->is_correct_action_required)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Yes (List the CAR’s in Part D of the Incident Investigation Report)
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            No
                                        </label>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    <!-- <div class="page-break"></div> -->
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Incident Response (Describe the immediate response to the incident / Injury)</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 30px 0px 15px 30px;" colspan="2">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        {{ $data->incident_response }}
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 30px 0px 15px 30px;" colspan="2">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 16px;font-weight: 600;margin: 0px;color: #059EF3;">
                                        REFER RETURN TO WORK / REHABILITATION PROCEDURE
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    @if ($data->is_injury_management)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Yes
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            No
                                        </label>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        NAME OF MANAGEMENT REPRESENTATIVE: <span
                                            style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_representative_name }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        NAME OF INJURED WORKERS SUPERVISOR: <span
                                            style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_injured_names }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_date ?? ' N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        TIME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_time ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Outcome of Treatment and Work Status</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->incident_injury_managements_is_first_aid)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            First Aid & Return to Work
                                        </label>
                                    @else
                                        {{-- <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            First Aid & Return to Work
                                        </label> --}}
                                    @endif
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    @if ($data->incident_injury_managements_is_referred)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Medical - Referred to
                                        </label>
                                    @else
                                        {{-- <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Medical - Referred to
                                        </label> --}}
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->incident_injury_managements_is_doctor)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Doctor
                                        </label>
                                    @else
                                        {{-- <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Doctor
                                        </label> --}}
                                    @endif
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    @if ($data->incident_injury_managements_is_clinic)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Clinic / Hospital
                                        </label>
                                    @else
                                        {{-- <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Clinic / Hospital
                                        </label> --}}
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    @if ($data->incident_injury_managements_is_admit)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Outpatient
                                        </label>
                                    @else
                                        {{-- <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="border: 1px solid #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Inpatient
                                        </label> --}}
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="page-break"></div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Doctor Details</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        NAME OF DOCTOR: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_doctor_name ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        CONTACT NO: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_doctor_number ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        ADDRESS OF DOCTOR: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_doctor_address ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Hospital Details</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        NAME OF HOSPITAL: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_hospital_name ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        CONTACT NO: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_hospital_number ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        ADDRESS OF HOSPITAL: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_hospital_address ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Is
                                this a recurrence of a previous injury</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    @if ($data->incident_injury_managements_is_recurrence_injury)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="border: 1px solid #059EF3;background-color: #059EF3; display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #ffffff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Yes
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="border: 1px solid #059EF3; background-color: #059EF3; display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #ffffff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            No
                                        </label>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_previous_injury_date ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        PREVIOUS INCIDENT INVESTIGATION REPORT NUMBER: <span
                                            style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_injury_managements_previous_report_number }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div style="background-color: #059EF3;padding: 30px 30px;margin-top: 15px;">
                        <h2
                            style="font-size: 21px;font-weight: 600;margin: 0px 0px 10px 0px;color: #fff;text-transform: uppercase;">
                            PART C – Close Out (Must be completed for all Injuries / Incidents)</h2>
                        <p style="font-size: 16px;font-weight: 500;color: #fff;margin: 0px;">Completion of this section,
                            including necessary signatures, denotes closure of this incident report.</p>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Final Classifications</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->is_final_injury_classification)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            First Aid – No Investigation
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            NO
                                        </label>
                                    @endif
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        OTHER DETAIL: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_incident_details }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Final Incident Classification.</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->is_final_incident_classification)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Plant
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Property
                                        </label>
                                    @endif
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        OTHER DETAIL: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_incident_details }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="page-break"></div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Complete for LTI or RWI (Lost Time Injury / Restricted Work Injury)</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->lti_or_rwi)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            LTI
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            RWI
                                        </label>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>

                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Is
                                rehabilitation likely?</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->final_incident_details_is_rehabilitation == 1)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Yes
                                        </label>
                                    @elseif ($data->final_incident_details_is_rehabilitation == 0)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            No
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="border: 1px solid #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            N/A
                                        </label>
                                    @endif
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Return to Full duties on Date (if known)</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        DATE OF RTW (IF KNOW): <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_return_to_duty_date ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        NO OF LOST DAYS (IF KNOW): <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_rtw_date ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        NO OF LOST DAYS (IF KNOW): <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_total_lost_days ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Has the Workers Comp body been notified?</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->final_incident_details_is_worker_notified == 1)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Yes
                                        </label>
                                    @elseif ($data->final_incident_details_is_worker_notified == 0)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            No
                                        </label>
                                    @else
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Not Required
                                        </label>
                                    @endif
                                </td>

                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        BY WHOM?: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->emp_personal_forman_notified_by_whom_f_name ?? 'N/A' }}{{' ' . $data->emp_personal_forman_notified_by_whom_l_name ?? '' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_date ?? 'N/A' }}</span>
                                    </p>
                                </td>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        TIME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_time ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;" colspan="2">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        OTHER DETAILS: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->final_incident_details_details ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        {{-- <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Sign Off for All Incidents</h2>
                        </div>
                        @foreach ($incidentSignoffs as $signoff)
                                    @if ($signoff->inc_signoffs_role_code == 'FM')
                                                <table width="100%" style="border-collapse: collapse;">
                                                    <tr>
                                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                                            <p
                                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                                NAME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                                    {{ $signoff->emp_personal_details_first_name ?? 'N/A' }}
                                                                    {{' ' . $signoff->emp_personal_details_last_name ?? '' }}</span>
                                                            </p>
                                                        </td>
                                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                                            <p
                                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                                SIGNATURE: <span style="font-weight: 400;color: #595959;">
                                                                    @php
                                                                        $imagePath = $signoff->inc_signoffs_signature;
                                                                       @endphp
                                                                    @if (!empty($imagePath))
                                                                        <img src="{{ get_signed_document_url($imagePath) }}" alt="No signature" width="100px" height="100px" style="object-fit: cover;">
                                                                            height="100px" style="object-fit: cover;">
                                                                    @else
                                                                        <span>No signature yet.</span>
                                                                    @endif  

                                                            </p>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                                            <p
                                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                                DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                                    {{ $signoff->inc_signoffs_date ?? 'N/A' }}</span>
                                                            </p>
                                                        </td>
                                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                                            <p
                                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                                TIME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                                    {{ $signoff->inc_signoffs_time ?? 'N/A' }}</span>
                                                            </p>
                                                        </td>
                                                    </tr>
                                                </table>
                                    @endif
                        @endforeach
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Safety Manager</h2>
                        </div>
                        @foreach ($incidentSignoffs as $signoff)
                            @if ($signoff->inc_signoffs_role_code == 'SSO')
                                <table width="100%" style="border-collapse: collapse;">
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                NAME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->emp_personal_details_first_name ?? 'N/A' }}
                                                    {{ $signoff->emp_personal_details_last_name ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                SIGNATURE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->inc_signoffs_signature ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->inc_signoffs_date ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                TIME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->inc_signoffs_time ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                            @endif
                        @endforeach
                    </div>
                    <!-- <div class="page-break"></div> -->
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                Director</h2>
                        </div>
                        @foreach ($incidentSignoffs as $signoff)
                            @if ($signoff->inc_signoffs_role_code == 'Dir')
                                <table width="100%" style="border-collapse: collapse;">
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                NAME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->emp_personal_details_first_name ?? 'N/A' }}
                                                    {{ $signoff->emp_personal_details_last_name ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                SIGNATURE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->inc_signoffs_signature ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                DATE: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->inc_signoffs_date ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                        <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 30px 15px 30px;">
                                            <p
                                                style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                                TIME: <span style="font-weight: 400;color: #595959;">&nbsp;
                                                    {{ $signoff->inc_signoffs_time ?? 'N/A' }}</span>
                                            </p>
                                        </td>
                                    </tr>
                                </table>
                            @endif
                        @endforeach
                    </div> --}}
                    <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                        <h2
                            style="font-size: 21px;font-weight: 600;margin: 0px 0px 10px 0px;color: #fff;text-transform: uppercase;">
                            PART D – Additional Information to Incident Investigation Report</h2>
                        <p style="font-size: 16px;font-weight: 500;color: #fff;margin: 0px;">High Risk Category (the most
                            significant risk category, if any, that relates to the incident) (Refer to
                            291 Meaning of “high risk construction work”)</p>
                    </div>
                    <div>
                        <table width="100%" style="border-collapse: collapse;">
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    @if ($data->incident_risk_category_details_incident_risk_category_id == 1)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Involves a risk of a person falling more than 2
                                            metres
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 2)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out on a telecommunication tower
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 3)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Involves demolition of an element of a structure that is
                                            load-bearing or otherwise related to the physical integrity of the
                                            structure
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 4)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Involves, or is likely to involve, the disturbance of
                                            asbestos
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 5)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Involves structural alterations or repairs that require
                                            temporary support to prevent collapse
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 6)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out in or near a confined space
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 7)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out in or near a shaft or trench with an
                                            excavated
                                            depth greater than 1.5 metres, or a tunnel
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 8)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out on or near pressurised gas distribution mains or piping
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 9)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out on or near chemical, fuel or refrigerant
                                            lines
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 10)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out on or near energised electrical installations or services
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 11)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Involves tilt-up or precast concrete
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 12)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out on, in or adjacent to a road, railway, shipping lane or other traffic
                                            corridor that is in use by traffic other than pedestrians
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 13)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out in an area at a workplace in which there is any movement of powered
                                            mobile plant
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 14)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Is carried out in an area in which there are artificial
                                            extremes of temperature
                                        </label>
                                    @elseif($data->incident_risk_category_details_incident_risk_category_id == 15)
                                        <label for="" style="font-size: 16px;font-weight: 600;color: #1E1E1E;">
                                            <div
                                                style="background: #059EF3;display: inline-block;margin-right: 15px;padding: 5px;margin-bottom: -5px;">
                                                <div
                                                    style="width: 12px;height: 12px;background-color: #fff;border-radius: 50%;">
                                                </div>
                                            </div>
                                            Involves diving work
                                        </label>
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <td style="border-bottom: 1px solid #1E1E1E;padding: 15px 0px 15px 30px;">
                                    <p
                                        style="font-family: 'Poppins', sans-serif;font-size: 14px;font-weight: 600;margin: 0px;color: #1E1E1E;">
                                        OTHER DETAILS: <span style="font-weight: 400;color: #595959;">&nbsp;
                                            {{ $data->incident_risk_category_details_details ?? 'N/A' }}</span>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div>
                        <div style="background-color: #059EF3;padding: 15px 30px;margin-top: 15px;">
                            <h2 style="font-size: 18px;font-weight: 600;margin: 0px;color: #fff;text-transform: uppercase;">
                                ATTACH ALL WITNESS STATEMENT / DOCUMENTS TO THIS INCIDENT REPORT</h2>
                        </div>
                        <table width="100%" style="border-collapse: collapse;">
                            <thead>
                                <tr>
                                    <th
                                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;width: 25%;border-right: 1px solid #898989;">
                                        Witness Name</th>
                                    <th
                                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;width: 25%;border-right: 1px solid #898989;">
                                        Witness Statement Number</th>
                                    <th
                                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;width: 25%;border-right: 1px solid #898989;">
                                        Date Taken</th>
                                    <th
                                        style="font-size: 16px;font-weight: 600;color: #1E1E1E;background-color: #F1F1F1;padding: 10px 0px;text-align: center;width: 25%;border-right: 1px solid #898989;">
                                        Time Taken</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                        {{ $data->incident_witness_name ?? 'N/A' }}
                                    </td>
                                    <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                        {{ $data->incident_witness_statement_number ?? 'N/A' }}
                                    </td>
                                    <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                        {{ $data->incident_witness_date ?? 'N/A' }}
                                    </td>
                                    <td style="text-align: center;padding: 20px 0px;border-bottom: 1px solid #1E1E1E;">
                                        {{ $data->incident_witness_time ?? 'N/A' }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>

                    </div>
                    <div class="page-break"></div>
                    <br>
                    <div style="text-align: center;background-color: #059EF3;padding: 15px 0px;">
                        <h1 style="font-size: 24px;font-weight: 400;margin: 0px;color: #fff; margin-bottom:10px">
                            Incident Images</h1>

                    </div>
                    <div style="height:60px;"></div>
                    <div style="padding: 25px 5px; margin-top:25px;">
                        @if($reportImages->isNotEmpty())
                            @foreach($reportImages as $image)
                                @php
                                    $imageUrl = get_signed_document_url($image->image);
                                @endphp
                                <img src="{{ $imageUrl }}" alt="image loading..." style="margin: 10px;margin-top:117px;" height="350px" width="350px" />
                            @endforeach
                        @else
                            <div>No images available for this report.</div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="footer">
            <div style="margin-left: 30px; margin-right: 30px;">
                <table style="width: 100%;">
                    <tr style="text-align: start;">
                        <td style="width: 45%; font-weight: 600; text-align: left; font-size: 14px;">Document Title:</td>
                        <td style="width: 55%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                            {{ $data->title ?? 'N/A' }}
                        </td>
                        <td style="width: 45%; font-weight: 600; text-align: left; font-size: 14px;">Document Number:</td>
                        <td style="width: 55%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                            {{ $data->document_number ?? 'N/A' }}
                        </td>
                    </tr>
                    <tr style="text-align: end;">
                        <td style="width: 45%; font-weight: 600; text-align: left; font-size: 14px;">Revision Number:</td>
                        <td style="width: 55%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                            {{ $data->revision_number ?? 'N/A' }}
                        </td>
                        <td style="width: 45%; font-weight: 600; text-align: left; font-size: 14px;">Authorised By:</td>
                        <td style="width: 55%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                            {{ trim(($data->main_details_first_name ?? '') . ' ' . ($data->main_details_last_name ?? '')) }}
                        </td>
                    </tr>
                    <tr style="text-align: end;">
                        <td style="width: 45%; font-weight: 600; text-align: left; font-size: 14px;">Issue Date:</td>
                        <td style="width: 55%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                            {{ $data->issue_date ?? 'N/A' }}
                        </td>
                        <td style="width: 45%; font-weight: 600; text-align: left; font-size: 14px;">Revision Date:</td>
                        <td style="width: 55%; color: #7a7a7a; font-weight: 300; text-align: left; font-size: 14px;">
                            {{ $data->revision_date ?? 'N/A' }}
                        </td>
                    </tr>
                </table>
            </div>
        </div>
    </body>

    </html>
@else
    <center>
        <h1>No record found</h1>
        <span>Downloaded record has incomplete records found against please complete then download </span>
    </center>
@endif
