<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Subscription Test</title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Stripe JS -->
    <script src="https://js.stripe.com/v3/"></script>
    
    <style>
        .container {
            max-width: 800px;
            margin: 50px auto;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        #card-element {
            padding: 12px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            background-color: white;
        }
        
        #card-errors {
            color: #dc3545;
            font-size: 14px;
            margin-top: 10px;
        }
        
        .subscription-success {
            background-color: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 4px;
            margin: 20px 0;
        }
        
        .plan-selection {
            margin-bottom: 30px;
        }
        
        .plan-card {
            border: 1px solid #ddd;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 15px;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .plan-card.selected {
            border-color: #007bff;
            box-shadow: 0 0 0 2px rgba(0, 123, 255, 0.25);
        }
        
        .plan-card:hover {
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            border: 3px solid rgba(255,255,255,.3);
            border-radius: 50%;
            border-top-color: #fff;
            animation: spin 1s ease-in-out infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1 class="text-center mb-4">Subscription Test</h1>
        
        <div id="subscription-form" class="card">
            <div class="card-body">
                <h3 class="card-title mb-4">Select a Subscription Plan</h3>
                
                <div class="plan-selection">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="plan-card" data-plan-id="price_1ROBVlD3PGBfmS0nK5rhkNrz">
                                <h4>Monthly Plan</h4>
                                <p class="lead">$19.99/month</p>
                                <ul>
                                    <li>Feature 1</li>
                                    <li>Feature 2</li>
                                    <li>Feature 3</li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="plan-card" data-plan-id="price_yearly">
                                <h4>Yearly Plan</h4>
                                <p class="lead">$199.99/year</p>
                                <p class="text-success">Save 17%</p>
                                <ul>
                                    <li>Feature 1</li>
                                    <li>Feature 2</li>
                                    <li>Feature 3</li>
                                    <li>Premium Support</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                
                <form id="payment-form">
                    <div class="form-group">
                        <label for="name">Full Name</label>
                        <input type="text" id="name" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" id="email" class="form-control" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="card-element">Credit or Debit Card</label>
                        <div id="card-element"></div>
                        <div id="card-errors" role="alert"></div>
                    </div>
                    
                    <button type="submit" id="submit-button" class="btn btn-primary btn-lg w-100">
                        <span id="button-text">Subscribe Now</span>
                        <span id="spinner" class="spinner d-none"></span>
                    </button>
                </form>
            </div>
        </div>
        
        <div id="subscription-success" class="subscription-success d-none">
            <h3>Thank you for subscribing!</h3>
            <p>Your subscription has been processed successfully. You should receive a confirmation email shortly.</p>
            <p>Subscription ID: <strong id="subscription-id"></strong></p>
            <button id="manage-subscription" class="btn btn-outline-primary mt-3">Manage Subscription</button>
        </div>
    </div>
    
    <script>
// Replace with your publishable key
const stripe = Stripe('{{ env('STRIPE_KEY') }}');

// Create an instance of Elements
const elements = stripe.elements();

// Custom styling for the card Element
const style = {
    base: {
        color: '#32325d',
        fontFamily: '"Helvetica Neue", Helvetica, sans-serif',
        fontSmoothing: 'antialiased',
        fontSize: '16px',
        '::placeholder': {
            color: '#aab7c4'
        }
    },
    invalid: {
        color: '#fa755a',
        iconColor: '#fa755a'
    }
};

// Create a card Element and mount it to the div
const cardElement = elements.create('card', {style: style});
cardElement.mount('#card-element');

// Handle real-time validation errors from the card Element
cardElement.addEventListener('change', function(event) {
    const displayError = document.getElementById('card-errors');
    if (event.error) {
        displayError.textContent = event.error.message;
    } else {
        displayError.textContent = '';
    }
});

// Handle form submission
const form = document.getElementById('payment-form');
const submitButton = document.getElementById('submit-button');
const spinner = document.getElementById('spinner');
const buttonText = document.getElementById('button-text');

// Plan selection
let selectedPlanId = null;
const planCards = document.querySelectorAll('.plan-card');

planCards.forEach(card => {
    card.addEventListener('click', function() {
        // Remove selected class from all cards
        planCards.forEach(c => c.classList.remove('selected'));
        
        // Add selected class to clicked card
        this.classList.add('selected');
        
        // Store the selected plan ID
        selectedPlanId = this.getAttribute('data-plan-id');
    });
});

form.addEventListener('submit', async function(event) {
    event.preventDefault();
    
    if (!selectedPlanId) {
        alert('Please select a subscription plan');
        return;
    }
    
    // Disable the submit button and show spinner
    submitButton.disabled = true;
    spinner.classList.remove('d-none');
    buttonText.classList.add('d-none');
    
    // Create a token from the card element
    const { token, error } = await stripe.createToken(cardElement, {
        name: document.getElementById('name').value,
        email: document.getElementById('email').value
    });
    
    if (error) {
        // Show error to customer
        const errorElement = document.getElementById('card-errors');
        errorElement.textContent = error.message;
        
        // Re-enable the submit button
        submitButton.disabled = false;
        spinner.classList.add('d-none');
        buttonText.classList.remove('d-none');
        return;
    }
    
    // Send the token to your server
    try {
        const response = await fetch('/api/subscriptions/create', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                stripe_token: token.id,
                price_id: selectedPlanId, // Use the selected plan ID
                email: document.getElementById('email').value,
                name: document.getElementById('name').value
            })
        });
        
        const subscription = await response.json();
        
        if (subscription.error) {
            // Show error to customer
            const errorElement = document.getElementById('card-errors');
            errorElement.textContent = subscription.error;
            
            // Re-enable the submit button
            submitButton.disabled = false;
            spinner.classList.add('d-none');
            buttonText.classList.remove('d-none');
            return;
        }
        
        // Show success message
        document.getElementById('subscription-form').classList.add('d-none');
        document.getElementById('subscription-success').classList.remove('d-none');
        document.getElementById('subscription-id').textContent = subscription.subscription_id;
        
    } catch (error) {
        const errorElement = document.getElementById('card-errors');
        errorElement.textContent = "An error occurred. Please try again.";
        
        // Re-enable the submit button
        submitButton.disabled = false;
        spinner.classList.add('d-none');
        buttonText.classList.remove('d-none');
    }
});

// Manage subscription
document.getElementById('manage-subscription').addEventListener('click', function() {
    const subscriptionId = document.getElementById('subscription-id').textContent;
    window.location.href = `/subscriptions/manage/${subscriptionId}`;
});
    </script>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>