<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\PlanController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\SiteController;
use App\Http\Controllers\TierController;
use App\Http\Controllers\FundsController;
use App\Http\Controllers\LeadController;
use App\Http\Controllers\LeaveController;
use App\Http\Controllers\ModuleController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\EmpTeamController;
use App\Http\Controllers\EmpTypeController;
use App\Http\Controllers\MeetingController;
use App\Http\Controllers\ProjectController;
use App\Http\Controllers\ReferralController;
use App\Http\Controllers\AdminReferralController;
use App\Http\Controllers\WarningController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\EmployeeController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\WhsStepsController;
use App\Http\Controllers\AdminAuthController;
use App\Http\Controllers\ContactUsController;
use App\Http\Controllers\EmpPermitController;
use App\Http\Controllers\LeaveTypeController;
use App\Http\Controllers\SubModuleController;
use App\Http\Controllers\SwmsStepsController;
use App\Http\Controllers\AttendanceController;
use App\Http\Controllers\PermissionsController;
use App\Http\Controllers\TierPackageController;
use App\Http\Controllers\LeavePackageController;
use App\Http\Controllers\LeaveRequestController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\AdminsettingsController;
use App\Http\Controllers\BankAccountController;
use App\Http\Controllers\CouponsController;
use App\Http\Controllers\EmpWorkerTypeController;
use App\Http\Controllers\HelpdeskTicketController;
use App\Http\Controllers\IncidentReportController;
use App\Http\Controllers\InspectionPlanController;
use App\Http\Controllers\LinkManagementController;
use App\Http\Controllers\RosterTemplateController;
use App\Http\Controllers\RequiredDocumentController;
use App\Http\Controllers\EmpWorkExperienceController;
use App\Http\Controllers\EmployeeOnboardingController;
use App\Http\Controllers\CustomDomainRequestController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\DemoController;
use App\Http\Controllers\DemoRequestController;
use App\Http\Controllers\UserCommentManagementController;
use App\Http\Controllers\InspectionPlanSetttingsController;
use App\Http\Controllers\HelpdeskTicketCategoriesController;
use App\Http\Controllers\ExternalEmployeeOnboardingController;
use App\Http\Controllers\WhsReportController;
use App\Http\Controllers\WhsReportSettingController;
use App\Http\Controllers\IncidentInjuryClassificationController;
use App\Http\Controllers\IncidentInjuryTypeController;
use App\Http\Controllers\IncidentReportQuestionController;
use App\Http\Controllers\IncidentRiskCategoryController;
use App\Http\Controllers\NotifiableClassificationController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\SubscriptionController;
use App\Http\Controllers\SWMSReportController;
use App\Http\Controllers\PasswordResetController;
use App\Http\Controllers\SafetyDataSheetController;
use App\Http\Controllers\SiteSafetyAuditController;
use App\Http\Controllers\TrainingController;
use App\Http\Controllers\WHSQController;
use App\Http\Controllers\WHSQEReportLogController;
use App\Http\Controllers\WhsqReportSettingController;
use App\Http\Controllers\PayrollController;
use App\Http\Controllers\OvertimeController;
use App\Http\Controllers\FAQController;
use App\Http\Controllers\AiDataController;
use App\Http\Controllers\AssetController;
use App\Http\Controllers\DefectController;
use App\Http\Controllers\SiteDiaryController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\PresenceController;
use App\Http\Controllers\WebhookController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/roster-clean-api/{id}', [RosterTemplateController::class, 'rosterDataCleanApi']);
// loop badge and limit 
Route::get('/roster-clean-api-loop/{limit}/{badge}', [RosterTemplateController::class, 'rosterDataCleanApiloop']);
Route::post('/steps', [InspectionPlanController::class, 'inspection_plan_next']);
Route::get('/assignShift', [ExternalEmployeeOnboardingController::class, 'assignShift']);
Route::post('/external-employee-onboarding-store', [ExternalEmployeeOnboardingController::class, 'externalEmployeeOnboardingsStore']);
Route::post('/delete-medical-attachment', [ExternalEmployeeOnboardingController::class, 'deleteMedicalAttachment']);
Route::get('/required/data/external', [ExternalEmployeeOnboardingController::class, 'required_external_data']);
// Login APIs for different platforms
Route::post('/login', [AdminAuthController::class, 'login'])->name('admin.login'); // Legacy API
Route::post('/mobile/login', [AdminAuthController::class, 'mobileLogin'])->name('admin.mobile.login');
Route::middleware(['auth:admin', 'admin'])->group(function () {
    // subscription Plan 
    Route::get('/admin/plan', [PlanController::class, 'index']);
    Route::post('/admin/plan/create', [PlanController::class, 'store']);
    Route::get('/admin/plan/{plan}', [PlanController::class, 'show']);
    Route::post('/admin/plan/update', [PlanController::class, 'update']);
    Route::delete('/admin/plan/{plan}', [PlanController::class, 'destroy']);
    Route::post('/admin/plan/update-status', [PlanController::class, 'updateStatus']);
    Route::post('/admin/plan/cancel', [PlanController::class, 'cancelUserSubscription']);
    /////// coupon routes
    Route::get('/admin/coupon', [CouponsController::class, 'index']);
    Route::get('/admin/coupon/{coupon}', [CouponsController::class, 'show']);
    Route::post('/admin/create/coupon', [CouponsController::class, 'store']);
    Route::post('/admin/update/coupon', [CouponsController::class, 'update']);
    Route::delete('/admin/coupon/{coupon}', [CouponsController::class, 'destroy']);
    Route::get('/admin/coupon/status/{code}', [CouponsController::class, 'toggleStatus']);
    // Module routes 
    Route::get('/admin/module', [ModuleController::class, 'index']);
    Route::post('/admin/module/create', [ModuleController::class, 'store']);
    Route::get('/admin/module/{module}', [ModuleController::class, 'show']);
    Route::post('/admin/module/update', [ModuleController::class, 'update']);
    Route::delete('/admin/module/{module}', [ModuleController::class, 'destroy']);
    // Sub Module routes 
    Route::get('/admin/submodule', [SubModuleController::class, 'index']);
    Route::post('/admin/submodule/create  ', [SubModuleController::class, 'store']);
    Route::get('/admin/submodule/{subModule}', [SubModuleController::class, 'show']);
    Route::post('/admin/submodule/update', [SubModuleController::class, 'update']);
    Route::delete('/admin/submodule/{subModule}', [SubModuleController::class, 'destroy']);
    // Admin Customer route
    Route::post('/admin/create/customer', [CustomerController::class, 'store']);
    Route::get('/admin/customer/show', [CustomerController::class, 'show']);
    Route::post('/admin/reset-password', [CustomerController::class, 'passwordReset']);
    Route::post('/admin/customer-edit', [CustomerController::class, 'editCustomer']);
    Route::delete('/admin/customer-delete/{id}', [CustomerController::class, 'deleteCustomer']);
    Route::post('admin/customers/toggle-login', [CustomerController::class, 'toggleUserLogin']);
    Route::post('admin/assign-plan', [CustomerController::class, 'assignPlan']);
    Route::post('admin/company/login', [CustomerController::class, 'companyLogin']);
    // Custome Domain 
    Route::get('/admin/custom-domain-list', [CustomDomainRequestController::class, 'index']);
    Route::post('/admin/create/custom-domain', [CustomDomainRequestController::class, 'store']);
    Route::post('/admin/update/custom-domain-status', [CustomDomainRequestController::class, 'updateStatus']);
    Route::delete('admin/custom-domain-delete/{id}', [CustomDomainRequestController::class, 'destroy']);
    // Helpdesk Categories
    Route::get('/admin/show/helpdesk-category', [HelpdeskTicketCategoriesController::class, 'index']);
    Route::post('/admin/create/helpdesk-category', [HelpdeskTicketCategoriesController::class, 'store']);
    Route::get('/admin/helpdesk-category/{category}', [HelpdeskTicketCategoriesController::class, 'show']);
    Route::post('/admin/update/helpdesk-category/', [HelpdeskTicketCategoriesController::class, 'update']);
    Route::delete('/admin/delete/helpdesk-category/{category}', [HelpdeskTicketCategoriesController::class, 'destroy']);
    Route::post('/admin/search/helpdesk-category', [HelpdeskTicketCategoriesController::class, 'search']);
    // Admin General Settings
    Route::post('/admin/general-settings/store', [AdminsettingsController::class, 'store']);
    Route::post('/admin/general-settings/update', [AdminsettingsController::class, 'update']);
    Route::get('/admin/general-settings', [AdminsettingsController::class, 'show']);
    //Permissions
    Route::resource('/admin/permission', PermissionsController::class);
    Route::post('/admin/tier-related-data', [RoleController::class, 'tierRelatedData']);
    Route::post('/admin/add-permissions', [PermissionsController::class, 'addPermissionModule']);
    Route::get('/admin/edit-permissions/{id}', [PermissionsController::class, 'getModuleById']);
    Route::post('/admin/update-permissions/{id}', [PermissionsController::class, 'updatePermissionModule']);
    Route::post('/admin/delete-permissions/{id}', [PermissionsController::class, 'deletePermissionModule']);
    Route::get('/admin/get-allPermissions', [PermissionsController::class, 'getAllModules']);
    // Helpdesk
    Route::get('/admin/show/helpdesk', [HelpdeskTicketController::class, 'index']);
    Route::post('/admin/create/helpdesk', [HelpdeskTicketController::class, 'store']);
    Route::get('/admin/helpdesk/{id}', [HelpdeskTicketController::class, 'show']);
    Route::post('/admin/update/helpdesk/', [HelpdeskTicketController::class, 'update']);
    Route::delete('/admin/delete/helpdesk/{id}', [HelpdeskTicketController::class, 'destroy']);
    Route::post('/admin/reply/helpdesk/', [HelpdeskTicketController::class, 'reply']);
    Route::get('/customer/show/helpdesk', [HelpdeskTicketController::class, 'customerHelpdeskList']);
    Route::get('/helpdesk/download/{id}', [HelpdeskTicketController::class, 'download']);
    //Dynamic Pages
    Route::resource('admin/pages', PageController::class);
    //FAQ Management
    Route::get('admin/faq', [FAQController::class, 'index']);
    Route::post('admin/faq/create', [FAQController::class, 'store']);
    Route::get('admin/faq/{id}', [FAQController::class, 'show']);
    Route::post('admin/faq/update/', [FAQController::class, 'update']);
    Route::delete('admin/faq/{id}', [FAQController::class, 'destroy']);
    Route::get('admin/faq/update-status/{id}', [FAQController::class, 'updateStatus']);
    Route::get('admin/faq/module/{moduleId}', [FAQController::class, 'getByModule']);
    // Admin notification endpoints
    Route::get('/admin/notifications/all', [NotificationController::class, 'getAdminNotifications']);
    Route::get('/admin/notifications/unread-count', [NotificationController::class, 'getAdminUnreadNotificationCount']);
    Route::post('/admin/notifications/mark-read', [NotificationController::class, 'markAdminNotificationAsRead']);
    Route::post('/admin/notifications/mark-all-read', [NotificationController::class, 'markAllAdminNotificationsAsRead']);
    Route::get('/admin/notifications/by-type', [NotificationController::class, 'getAdminNotificationsByType']);
    Route::get('/admin/notifications/paginated', [NotificationController::class, 'getAdminNotificationsPaginated']);
    Route::delete('/admin/notifications/delete', [NotificationController::class, 'deleteAdminNotification']);
    Route::delete('/admin/notifications/clear-all', [NotificationController::class, 'clearAllAdminNotifications']);
    //Bank Account
    Route::resource('admin/bank', BankAccountController::class);
    Route::post('admin/bank/{id}/status', [BankAccountController::class, 'updateStatus']);
    // Admin subscription Request
    Route::get('/admin/bank-transfer/order', [PlanController::class, 'showRequestOrder']);
    Route::get('/admin/bank-transfer/request-list', [PlanController::class, 'bankTransferRequestList']);
    Route::delete('/admin/bank-transfer/delete/{id}', [PlanController::class, 'bankTransferRequestDelete']);
    Route::post('/admin/bank-transfer/order-status', [PlanController::class, 'bankTransferRequestOrderStatus']);
    Route::post('/admin/mark-all-notifications-read', [NotificationController::class, 'markAllNotificationsAsRead']);
    Route::post('/admin/mark-notification-read', [NotificationController::class, 'markNotificationAsRead']);
    Route::get('admin/employee-notifications', [NotificationController::class, 'getEmployeeNotifications']);

    // Admin Referral management routes
    Route::prefix('admin/referrals')->group(function () {
        Route::get('/', [ReferralController::class, 'index']);
        Route::post('/store', [ReferralController::class, 'store']);
        Route::get('/{id}', [ReferralController::class, 'show']);
        Route::put('/{id}', [ReferralController::class, 'update']);
        Route::delete('/{id}', [ReferralController::class, 'destroy']);
        Route::get('/{id}/leads', [ReferralController::class, 'getLeads']);
    });
    // Lead management routes
    Route::prefix('admin/leads')->group(function () {
        Route::get('/', [LeadController::class, 'index']);
        Route::get('/{id}', [LeadController::class, 'show']);
        Route::put('/{id}', [LeadController::class, 'update']);
        Route::delete('/{id}', [LeadController::class, 'destroy']);
    });
    // Demo Request routes (Admin only)
    Route::get('/admin/demo-requests', [DemoRequestController::class, 'index']);
    Route::get('/admin/demo-requests/{id}', [DemoRequestController::class, 'show']);
    Route::delete('/admin/demo-requests/{id}', [DemoRequestController::class, 'destroy']);
    Route::fallback(function () {
        return response()->json([
            'message' => 'Route not found.'
        ], 404);
    });
    Route::prefix('admin/referral')->group(function () {
        Route::get('/dashboard', [AdminReferralController::class, 'adminDashboard']);
        Route::get('/users/{user_id}', [AdminReferralController::class, 'getReferralUsers']);
        Route::post('/payout/approve/{payout_id}', [AdminReferralController::class, 'approvePayout']);
        Route::get('/payouts/{payoutId}', [AdminReferralController::class, 'getPayoutDetails']);
        Route::get('/settings', [AdminReferralController::class, 'getSettings']);
        Route::post('/settings', [AdminReferralController::class, 'updateSettings']);
    });
});
// Customer All Routes
Route::post('/customer/signup', [CustomerController::class, 'signup']);

// Referral Routes (Public)
Route::post('/referral/signup', [ReferralController::class, 'signup']);
Route::post('/referral/track-click', [ReferralController::class, 'trackClick']);

// Referral Partner Routes (Protected)
Route::prefix('referral')->middleware(['auth:referral', 'referral'])->group(function () {
    Route::get('/dashboard', [ReferralController::class, 'dashboard']);
    Route::post('/payout/request', [ReferralController::class, 'requestPayout']);
});
Route::middleware(['auth:admin,api', 'customer'])->group(function () {
    // Check user authorization
    Route::get('/check-authorization', function () {
        $isAuthorized = Auth::guard('admin')->check() || Auth::guard('api')->check();
        return response()->json(['authorized' => $isAuthorized]);
    });
    
    Route::post('/logout', [AuthController::class, 'logout']);
    /////Pusher Routes
    Route::post('/broadcasting/auth', [App\Http\Controllers\PusherController::class, 'authenticate']);
    Route::get('customer/employee-notifications', [NotificationController::class, 'getEmployeeNotifications']);
    Route::post('customer/mark-all-notifications-read', [NotificationController::class, 'markAllNotificationsAsRead']);
    Route::post('customer/mark-notification-read', [NotificationController::class, 'markNotificationAsRead']);
    /////Pusher Routes

    // customer helpdesk routes
    Route::get('/customer/coupon/code/{code}', [CouponsController::class, 'getCouponByCode']);
    Route::get('/conversations', [MessageController::class, 'getConversations']);
    Route::get('/conversations/{conversationId}/messages', [MessageController::class, 'getMessages']);
    Route::post('/conversations/start', [MessageController::class, 'startConversation']);
    Route::post('/messages/send', [MessageController::class, 'sendMessage']);
    
    // Presence/Online status endpoints
    Route::get('/presence/channels', [PresenceController::class, 'getPresenceChannels']);
    Route::get('/presence/data', [PresenceController::class, 'getPresenceData']);
    Route::post('/update-profile-password', [AuthController::class, 'updateprofilePassword'])->name('updateprofilePassword');
    Route::post('check/roster', [AttendanceController::class, 'check_roster']);
    Route::get('/customer/show/helpdesk-category', [HelpdeskTicketCategoriesController::class, 'index']);
    Route::get('/customer/show/helpdesk', [HelpdeskTicketController::class, 'showCustomerTickets']);
    Route::post('/customer/create/helpdesk', [HelpdeskTicketController::class, 'store']);
    Route::get('/customer/helpdesk/{id}', [HelpdeskTicketController::class, 'show']);
    Route::post('/customer/update/helpdesk/', [HelpdeskTicketController::class, 'update']);
    Route::delete('/customer/delete/helpdesk/{id}', [HelpdeskTicketController::class, 'destroy']);
    Route::post('/customer/reply/helpdesk/', [HelpdeskTicketController::class, 'reply']);
    Route::get('/helpdesk/download/{id}', [HelpdeskTicketController::class, 'download']);
    // Admin subscription Request
    // Route::get('/admin/bank-transfer/order', [PlanController::class, 'showRequestOrder']);
    // Route::get('/admin/bank-transfer/delete/{id}', [PlanController::class, 'bankTransferRequestDelete']);
    // Customer profile management
    Route::get('/customer/profile', [CustomerController::class, 'getProfile']);
    Route::post('/customer/profile/update', [CustomerController::class, 'updateProfile']);

    // Customer Referral System
    Route::get('/customer/referral-dashboard', [ReferralController::class, 'dashboard']);
    Route::post('/payout/request', [ReferralController::class, 'requestPayout']);

    // Employee password management
    Route::post('/employee/change-password', [EmployeeController::class, 'changePassword']);
    // Customer subscription Request
    Route::post('/customer/subscription/request', [PlanController::class, 'subscriptionRequest']);
    Route::post('/customer/subscriptions/cancel', [PlanController::class, 'cancelUserSubscription']);
    // Customer site 
    Route::get('/customer/plan', [PlanController::class, 'indexForCusomer']);
    Route::post('customer/site-store', [SiteController::class, 'store']);
    Route::get('customer/sites-get', [SiteController::class, 'index']);
    Route::delete('customer/site-delete/{id}', [SiteController::class, 'destroy']);
    Route::get('customer/sites-edit/{id}', [SiteController::class, 'siteEdit']);
    Route::post('customer/site-update/{id}', [SiteController::class, 'siteUpdate']);
    Route::put('customer/site/{id}/update-status', [SiteController::class, 'updateStatus']);
    Route::get('customer/site-view/{id}', [SiteController::class, 'view']); //->middleware('Permissions:Sites View');
    Route::get('customer/sso-list', [SiteController::class, 'ssoList']);
    
    // Site Document Routes
    Route::post('customer/site-document', [SiteController::class, 'siteDocument']);
    Route::get('customer/site-documents/{site_id}', [SiteController::class, 'siteDocuments']);
    Route::post('customer/update-site-document', [SiteController::class, 'updateSiteDocument']);
    Route::post('customer/delete-site-document', [SiteController::class, 'deleteSiteDocument']);
    Route::get('customer/document-types', [SiteController::class, 'getDocumentTypes']);
    // ======================= AI DATA GENERATION ===========================
    Route::prefix('ai')->group(function () {
        Route::post('/generate-report-data', [AiDataController::class, 'generateReportData']);
        // =======================  Unified AI Data Generation ===========================
        Route::post('/generate-ai-data', [AiDataController::class, 'generateUnifiedAiData']);
        Route::get('/test-australian-standards', [AiDataController::class, 'testAustralianStandardsValidation']);
    });
    Route::prefix('customer')->group(function () {
        ///////////////////// notificaiton /////////////


        
        // Customer notification endpoints
        Route::get('/notifications/all', [NotificationController::class, 'getCustomerNotifications']);
        Route::get('/notifications/unread-count', [NotificationController::class, 'getCustomerUnreadNotificationCount']);
        Route::post('/notifications/mark-read', [NotificationController::class, 'markCustomerNotificationAsRead']);
        Route::post('/notifications/mark-all-read', [NotificationController::class, 'markAllCustomerNotificationsAsRead']);
        Route::get('/notifications/by-type', [NotificationController::class, 'getCustomerNotificationsByType']);
        Route::get('/notifications/paginated', [NotificationController::class, 'getCustomerNotificationsPaginated']);
        Route::delete('/notifications/delete', [NotificationController::class, 'deleteCustomerNotification']);
        Route::delete('/notifications/clear-all', [NotificationController::class, 'clearAllCustomerNotifications']);
        // =======================  company route ======================= 
        Route::post('companie-store', [CompanyController::class, 'store']);
        Route::get('companie-client-get', [CompanyController::class, 'index']);
        Route::get('companie-client-show/{id}', [CompanyController::class, 'show']);
        Route::delete('companie-delete/{id}', [CompanyController::class, 'destroy']);
        Route::post('company-update', [CompanyController::class, 'update']);
        Route::post('company/update-status', [CompanyController::class, 'updateStatus']);
        Route::post('client-document', [CompanyController::class, 'clientdocument']);
        Route::post('client-delete-document/{id}', [CompanyController::class, 'deletedocument']);
        Route::post('client-show-document/{id}', [CompanyController::class, 'showClinetDocument']);
        Route::delete('client-delete-person/{id}', [CompanyController::class, 'destroyCompanyPerson']);
        // =======================  Projects Route =======================  
        Route::post('projects-store', [ProjectController::class, 'store']);
        Route::get('projects-get', [ProjectController::class, 'index']);
        Route::delete('projects-delete/{id}', [ProjectController::class, 'destroy']);
        Route::post('projects-update', [ProjectController::class, 'update']);
        Route::get('project-list', [ProjectController::class, 'project_list']);
        Route::get('project/show/{id}', [ProjectController::class, 'show']);
        Route::post('project-document', [ProjectController::class, 'projectdocument']);
        Route::post('delete-document', [ProjectController::class, 'deletedocument']);
        Route::post('update-project-document', [ProjectController::class, 'updateprojectdocument']);
        Route::post('view-project-document-history', [ProjectController::class, 'viewdocumenthistory']);
        Route::post('projects/update-status', [ProjectController::class, 'updateStatus']);
        // =======================  Attendance route ======================= 
        Route::get('attendance-get', [AttendanceController::class, 'index']);
        Route::post('attendance/store', [AttendanceController::class, 'store']);
        Route::get('attendance/employee/{id}', [AttendanceController::class, 'getEmployeeAttendance']);
        Route::post('attendance/update', [AttendanceController::class, 'update']);
        Route::delete('attendance/delete/{id}', [AttendanceController::class, 'destroy']);
        Route::delete('delete-break/{id}', [AttendanceController::class, 'deleteBreak']);
        Route::get('attendance_request', [AttendanceController::class, 'attendance_request']);
        Route::post('attendance/update-status', [AttendanceController::class, 'updateStatus']);
        Route::get('attendance/approved-all', [AttendanceController::class, 'approved_all']);
        Route::post('attendance/approve-selected', [AttendanceController::class, 'approveSelected']);
        Route::get('attendance-portal-employee', [AttendanceController::class, 'attendance_portal_employee']);
        Route::get('employe-attendance', [AttendanceController::class, 'employe_attendance']);
        Route::post('attendance/checkin', [AttendanceController::class, '_check_in']);
        Route::post('attendance/check_in', [AttendanceController::class, '_check_in']);
        Route::post('attendance/checkout', [AttendanceController::class, '_check_out']);
        Route::get('attendance/last-checkin', [AttendanceController::class, 'last_check_in']);
        Route::post('attendance/breakin', [AttendanceController::class, 'break_in']);
        Route::get('attendance/last-breakin', [AttendanceController::class, 'last_break_in']);
        Route::post('attendance/breakout', [AttendanceController::class, 'break_out']);
        Route::post('attendance/checkin-history', [AttendanceController::class, 'checkin_history']);
        Route::post('attendance/attendance-list', [AttendanceController::class, 'attendance_list']);
        Route::post('/attendance/download', [AttendanceController::class, 'attendanceDownload']);
        // =======================  Meeting Routes ======================= 
        Route::post('meeting/store', [MeetingController::class, 'store']);
        Route::get('meeting', [MeetingController::class, 'index']);
        Route::get('meeting/show', [MeetingController::class, 'show']);
        Route::post('meeting/update', [MeetingController::class, 'updateMeeting']);
        Route::delete('meeting-delete/{id}', [MeetingController::class, 'destroy']);
        Route::get('meeting/search/employees', [MeetingController::class, 'searchEmployees']);
        Route::post('meeting/document/store', [MeetingController::class, 'storeMeetingDocument']);
        Route::delete('meetings/document/delete', [MeetingController::class, 'deleteMeetingDocument']);
        Route::post('/meetings/get-employee', [MeetingController::class, 'getEmployeeMeetings']);
        Route::post('/meeting/attendance', [MeetingController::class, 'addMeetingAttendance']);
        Route::post('/meeting/sign-document', [MeetingController::class, 'signDocument']);
        Route::post('meeting/guest/add', [MeetingController::class, 'addMeetingGuestUser']);
        Route::post('meeting/guest/update', [MeetingController::class, 'updateMeetingGuestUser']);
        Route::delete('meeting/guest-user/delete', [MeetingController::class, 'deleteMeetingGuestUser']);
        Route::post('meeting/portal', [MeetingController::class, 'meetingPortal']);
        Route::post('/meetings/get-employee-meetings', [MeetingController::class, 'getEmployeeMeetingBeforeCheckIn']);
        Route::get('/meeting/guest', [MeetingController::class, 'addGuestUser']);
        Route::get('meetings/attendance-details', [MeetingController::class, 'getMeetingAttendanceDetails']);
        Route::get('meeting/generate-pdf', [MeetingController::class, 'generateSignedDocumentPDF']);
        Route::post('/meeting/notes/store', [MeetingController::class, 'addMeetingNotes']);
        Route::post('meeting/settings/store', [MeetingController::class, 'meetingSettingsStore']);
        Route::delete('meeting/settings/delete/{id}', [MeetingController::class, 'meetingSettingsDelete']);
        Route::get('meeting/settings', [MeetingController::class, 'meetingSettings']);
        Route::post('/meeting/settings/update', [MeetingController::class, 'meetingSettingsUpdate']);
        Route::post('/meeting-documents-store-step1', [MeetingController::class, 'meetingDocumentStep1Store']);
        Route::get('/meeting-documents-step1-edit', [MeetingController::class, 'meetingDocumentStep1Edit']);
        Route::post('/meeting-documents-store-step2', [MeetingController::class, 'meetingDocumentStep2Store']);
        Route::post('/meeting-note-data', [MeetingController::class, 'meetingDocumentStep2Store']);
        Route::post('/upload-meeting-document', [MeetingController::class, 'uploadMeetingDocument']);
        Route::post('/upload-report-pdf', [IncidentReportController::class, 'uploadReportPdf']);
        Route::post('/meeting-documents-step2-edit', [MeetingController::class, 'meetingDocumentStep2Edit']);
        Route::delete('/meetings/document/delete/{id}', [MeetingController::class, 'meetingDocumentStep2Delete']);
        Route::get('/meetings/document/pdf/download/{id}', [MeetingController::class, 'MeetingNotePDFRegenerate']);
        Route::post('/meeting-documents-store-step3', [MeetingController::class, 'meetingDocumentStep3Store']);
        Route::post('/meeting-documents-step3-edit', [MeetingController::class, 'meetingDocumentStep3Edit']);
        Route::delete('/meetings/document/{type}/{id}', [MeetingController::class, 'MeetingStep3Delete']);
        Route::get('/meetings-notes-manager-pdf-list', [MeetingController::class, 'meetingReportList']);
        Route::post('/meetings/document/note/delete', [MeetingController::class, 'MeetingNoteDocumentDelete']);
        // =======================  inspection plan routes ======================= 
        Route::get('/inspection-plans', [InspectionPlanController::class,  'index']);
        Route::post('/inspection-plan-store-step1', [InspectionPlanController::class, 'saveStep1']);
        Route::post('/inspection-plan-edit-step1', [InspectionPlanController::class, 'editStep1']);
        Route::post('/inspection-plan-store-step2', [InspectionPlanController::class,  'saveStep2']);
        Route::post('/inspection-plan-edit-step2', [InspectionPlanController::class,  'editStep2']);
        Route::delete('Inspection-plan-delete/{id}', [InspectionPlanController::class,  'destroy']);
        Route::delete('inspection-plan-signature/{id}', [InspectionPlanController::class,  'destroySignature']);
        Route::get('inspection-plan-signature-view/{id}', [InspectionPlanController::class,  'inspectionReportViewSignature']);
        Route::get('/inspection-plan-pdf', [InspectionPlanController::class, 'inspectionReportDownloadPdf']);
        Route::post('/inspection-plan-save-step', [InspectionPlanController::class,  'inspectionPlanSaveStep']);
        Route::post('/inspection-plan-formstep-data', [InspectionPlanController::class,  'inspectionPlanFormStepData']);
        Route::get('inspection-plan/employees-list', [InspectionPlanController::class, 'inspectionPlanSettingaEmployeeList']);
        Route::get('/inspection-report-pdf-list', [InspectionPlanController::class, 'InspectionReportPdfFiles']);
        Route::get('/inspection/files/download/{filename}', [InspectionPlanController::class, 'downloadPdfFile'])->name('download.pdf');
        Route::get('/inspection-report-pdf-publish/{id}', [InspectionPlanController::class, 'inspectionReportPublishReport']);
        Route::get('/inspection-plan-pdf-regenerate/{id}', [InspectionPlanController::class, 'inspectionReportDownloadPdfRegenerate']);
        Route::post('/inspection-report-image-store', [InspectionPlanController::class, 'imageStore']);
        Route::post('/inspection-report-images-list', [InspectionPlanController::class, 'getImages']);
        Route::delete('/inspection-report-delete-image/{id}', [InspectionPlanController::class, 'deleteImage']);
        Route::post('/inspection-report-description-store', [InspectionPlanController::class, 'step4Store']);
        Route::get('/inspection-plan-report-duplicate/{id}', [InspectionPlanController::class, 'copyInspectionPlanReport']);
        Route::delete('/whs-report-delete-image/{id}', [WhsStepsController::class, 'deleteImage']);
        Route::get('/inspection-plan-form-pages/{step}/{inspection_plan_id}', [InspectionPlanController::class, 'inspectionPlanFormPages']);
        Route::post('/inspection-report-description-list', [InspectionPlanController::class, 'getDescription']);
        Route::post('/inspection-plan-quick-entry', [InspectionPlanController::class, 'inspectionPlanQuickEntryStore']);
        Route::post('/inspection-plan-quick-entry-edit', [InspectionPlanController::class, 'inspectionPlanQuickEntryEdit']);
        Route::post('/inspection-plan-quick-entry-update', [InspectionPlanController::class, 'inspectionPlanQuickEntryUpdate']);

        // ======================= inspection plan setting routes ======================= 
        Route::post('/inspection-plan-selcted-checklist-get', [InspectionPlanSetttingsController::class,  'inspectionPlanChecklistGet']);
        Route::post('/inspection-plan-settings-store', [InspectionPlanSetttingsController::class,  'inspectionPlanSettingStore']);
        Route::post('/inspection-plan-settings-update', [InspectionPlanSetttingsController::class, 'inspectionPlanSettingUpdate']);
        Route::delete('/inspection-plan-settings-delete-item/{id}', [InspectionPlanSetttingsController::class, 'inspectionPlanSettingsDelete']);
        Route::post('/inspection-plan-settings-metatable-formdata-delete', [InspectionPlanSetttingsController::class, 'inspectionPlanSettingMetaTableFormDataDelete']);
        Route::post('/inspection-plan-settings-metatable-save', [InspectionPlanSetttingsController::class, 'inspectionPlanSettingMetaTableSave']);
        Route::post('/inspection-plan-settings-metatable', [InspectionPlanSetttingsController::class, 'inspectionPlanSettingMetaTable']);
        Route::delete('/inspection-plan-settings-delete/{id}', [InspectionPlanSetttingsController::class, 'indexDelete']);
        Route::get('/inspection-plan-formsteps-get', [InspectionPlanSetttingsController::class,  'inspectionPlanFormOptions']);
        Route::get('/inspection-plan-settings-get', [InspectionPlanSetttingsController::class,  'inspectionPlanSettingGet']);
        Route::get('/inspection-plan-settings-edit-data/{id}', [InspectionPlanSetttingsController::class, 'settingsTableEditData']);
        Route::get('/inspection-plan-settings-edit/{id}', [InspectionPlanSetttingsController::class, 'indexedit']);
        // need to confirm this routes
        Route::post('/inspection-plan-settings-metatable-formdata', [InspectionPlanSetttingsController::class, 'inspectionPlanSettingMetaTableFormData']);
        // ======================= WHS REPORT ROUTE ===========================
        Route::post('/whs-report-store-step1', [WhsStepsController::class, 'whsStep1Store']);
        Route::post('/whs-report-edit-step1', [WhsStepsController::class, 'whsStep1Edit']);
        Route::post('/whs-report-store-step2', [WhsStepsController::class, 'whsStep2Store']);
        Route::post('/whs-report-edit-step2', [WhsStepsController::class, 'whsStep2Edit']);
        Route::post('/whs-report-store-step3', [WhsStepsController::class, 'whsStep3Store']);
        Route::post('/whs-report-edit-step3', [WhsStepsController::class, 'whsStep3Edit']);
        Route::post('/whs-report-store-step4', [WhsStepsController::class, 'whsStep4Store']);
        Route::post('/whs-report-edit-step4', [WhsStepsController::class, 'whsStep4Edit']);
        Route::post('/whs-report-store-step5', [WhsStepsController::class, 'whsStep5Store']);
        Route::post('/whs-report-edit-step5', [WhsStepsController::class, 'whsStep5Edit']);
        Route::get('/whs-report-list-data', [WhsStepsController::class, 'whsReportListData']);
        Route::post('/whs-report-store-step6', [WhsStepsController::class, 'whsStep6Store']);
        Route::post('/whs-report-edit-step6', [WhsStepsController::class, 'whsStep6Edit']);
        Route::delete('/whs-report-delete-list-record/{id}', [WhsStepsController::class,  'destroy']);
        Route::post('/whs-report-quick-entry', [WhsStepsController::class, 'whsQuickEntryStore']);
        Route::post('whs-quick-entry-edit', [WhsStepsController::class, 'whsQuickEntryEdit']);
        Route::post('whs-quick-entry-update', [WhsStepsController::class, 'whsQuickEntryUpdate']);
        Route::get('/role-list', [WhsStepsController::class, 'whsPlanSettingRoleList']);
        Route::delete('/whs-report-delete-hazards-step4/{id}', [WhsStepsController::class, 'whsStep3HazardsDelete']);
        Route::post('/whs-report-image-store', [WhsStepsController::class, 'imageStore']);
        Route::post('/whs-report-images-list', [WhsStepsController::class, 'getImages']);
        Route::get('whs-files/download/{id}/{filename}', [WhsStepsController::class, 'fileManagerdownloadWhsPdfFile']);
        Route::get('/whs-report-duplicate/{id}', [WhsStepsController::class, 'whsReportDuplicate']);
        //Hazard Obs
        Route::get('whm-hazard-obs-reports',  [WhsReportController::class, 'whsHazardOBSDataIndex']);
        Route::post('hazard-obs-report-data',  [WhsReportController::class, 'whsHazardOBSData']);
        Route::post('hazard-obs-report-store',  [WhsReportController::class, 'whsHazardOBSStore']);
        Route::post('/hazard-obs-report-image-store', [WhsReportController::class, 'hazardOBSImageStore'])->name('hazaedOBSImages.store');
        Route::post('hazard-obs-report-data',  [WhsReportController::class, 'whsHazardOBSData']);
        Route::delete('/whs-obs-delete/{id}',  [WhsReportController::class, 'whsHazardOBSDelete']);
        Route::delete('/hazard-obs-delete-image/{id}',  [WhsReportController::class, 'whsHazardOBSDeleteImage']);
        Route::get('/whs-obs-report-status-update/{id}', [WhsReportController::class, 'updateHazardOBSStatus']);
        //Site Safety Audit
        Route::get('/safety-audits-index', [SiteSafetyAuditController::class,  'siteSafetyIndex']);
        Route::get('get-safety-audit', [SiteSafetyAuditController::class, 'getAuditDetails']);
        Route::post('site-safety-audit-step-get', [SiteSafetyAuditController::class, 'siteSafetyAuditStepData']);
        Route::post('/site-safety-audit-step-store', [SiteSafetyAuditController::class, 'siteSafetyAuditImageStore'])->name('siteSafety.image');
        Route::post('site-safety-audit-step-save', [SiteSafetyAuditController::class, 'siteSafetyAuditStepSave']);
        Route::post('save-safety-audit', [SiteSafetyAuditController::class, 'saveAuditDetails']);
        Route::post('/site-safety-audit-step-delete-image', [SiteSafetyAuditController::class, 'siteSafetyAuditImageDelete'])->name('siteSafetyDelete.image');
        Route::post('/site-safety-audit-step-delete-card', [SiteSafetyAuditController::class, 'siteSafetyAuditCardDelete'])->name('siteSafetyDelete.card');
        Route::delete('/site-safety-audit-delete/{id}', [SiteSafetyAuditController::class,  'siteSafetyDelete']);
        Route::get('/site-safety-audit-pdf-download/{id}', [SiteSafetyAuditController::class, 'site_safty_audit_pdf']);
        Route::get('/whs-report-pdf-list', [WhsStepsController::class, 'whsReportPdfFilesManager']);
        Route::delete('/whs-report-delete-image-step6/{id}', [WhsStepsController::class, 'whsStep3HazardsDelete']);
        // =======================  WHS Item ======================= 
        Route::post('/whs-item-store', [WhsReportSettingController::class, 'whsItemStore']);
        Route::get('/whs-item-get', [WhsReportSettingController::class, 'whsItemGet']);
        Route::post('/whs-item-update', [WhsReportSettingController::class, 'whsItemUpdate']);
        Route::delete('/whs-item-delete/{id}', [WhsReportSettingController::class, 'whsItemDelete']);
        // =======================  WHS Reposrt PDF ======================= 
        Route::get('/whs-report-pdf-regenerate/{id}', [WhsReportController::class, 'whsReportDownloadPdfRegenerate']);
        Route::get('/whs-report-pdf/{id}', [WhsReportController::class, 'whsReportDownloadPdf']);
        Route::get('/whs-report-pdf-publish/{id}', [WhsReportController::class, 'whsReportPublishReport']);
        Route::get('/whs-report-view-signature/{id}', [WhsReportController::class, 'whsReportViewSignature']);
        // ====================== Incident Report ========================
        Route::get('incident-reports', [IncidentReportController::class,  'index']);
        Route::delete('incident-reports/{id}', [IncidentReportController::class,  'destroy']);
        Route::post('incident-report-store-step1', [IncidentReportController::class, 'storeStep1']);
        Route::post('incident-report-edit-step1', [IncidentReportController::class,  'editStep1']);
        Route::post('incident-report-store-step2', [IncidentReportController::class, 'storeStep2']);
        Route::post('incident-report-edit-step2', [IncidentReportController::class,  'editStep2']);
        Route::post('incident-report-store-step3', [IncidentReportController::class, 'storeStep3']);
        Route::post('incident-report-edit-step3', [IncidentReportController::class,  'editStep3']);
        Route::post('incident-report-edit-step4', [IncidentReportController::class,  'editStep4']);
        Route::post('incident-report-store-step4', [IncidentReportController::class, 'storeStep4']);
        Route::get('incident-report-listing-step4/{id}', [IncidentReportController::class,  'listingStep4']);
        Route::post('incident-report-delete-step4', [IncidentReportController::class, 'deleteStep4']);
        Route::post('incident-report-store-step5', [IncidentReportController::class, 'storeStep5']);
        Route::post('incident-report-edit-step5', [IncidentReportController::class,  'editStep5']);
        Route::post('incident-report-store-step6', [IncidentReportController::class, 'storeStep6']);
        Route::post('incident-report-edit-step6', [IncidentReportController::class,  'editStep6']);
        Route::post('incident-report-store-step7', [IncidentReportController::class, 'storeStep7']);
        Route::post('incident-report-edit-step7', [IncidentReportController::class,  'editStep7']);
        Route::post('incident-report-store-step8', [IncidentReportController::class, 'storeStep8']);
        Route::post('incident-report-edit-step8', [IncidentReportController::class,  'editStep8']);
        Route::post('incident-report-edit-step9', [IncidentReportController::class,  'editStep9']);
        Route::post('incident-report-store-step9', [IncidentReportController::class, 'storeStep9']);
        Route::post('incident-report-store-step10', [IncidentReportController::class, 'storeStep10']);
        Route::post('incident-report-check-sign-off', [IncidentReportController::class, 'checkSignOffApi']);
        Route::post('report-sign-off-save', [IncidentReportController::class, 'signOffApi']);
        Route::get('copy-incident-report/{parent_incident_id}', [IncidentReportController::class, 'copyIncidentReport']);
        Route::post('report-sign-off-files', [IncidentReportController::class, 'SignOffAllFiles']);
        Route::get('incident-report-pdf/{id}', [IncidentReportController::class, 'incidentReportDownloadPdf']);
        Route::get('incident-report-pdf-regenerate/{id}', [IncidentReportController::class, 'incidentReportDownloadPdfRegenerate']);
        Route::get('incident-report-pdf-list', [IncidentReportController::class, 'IncidentReportPdfFiles']);
        Route::post('incident-report-images-list', [IncidentReportController::class, 'getImages']);
        Route::post('incident-report-image-store', [IncidentReportController::class, 'imageStore']);
        Route::delete('incident-report-delete-image', [IncidentReportController::class, 'deleteImage']);
        Route::get('incident-report-pdf-publish/{id}', [IncidentReportController::class, 'incidentReportPublishReport']);
        Route::get('incident-report-view-signature/{id}', [IncidentReportController::class, 'incidentReportViewSignature']);
        Route::post('update-report-status', [IncidentReportController::class, 'updateReportStatus']);
        Route::post('incident-report-quick-entry', [IncidentReportController::class, 'incidentQuickEntryStore']);
        Route::post('incident-quick-entry-edit', [IncidentReportController::class, 'incidentQuickEntryEdit']);
        Route::post('incident-quick-entry-update', [IncidentReportController::class, 'incidentQuickEntryUpdate']);
        // ====================== WHSQ Quick Entry Routes ========================
        Route::post('whsq-report-quick-entry', [App\Http\Controllers\WHSQController::class, 'whsqQuickEntryStore']);
        Route::post('whsq-quick-entry-edit', [App\Http\Controllers\WHSQController::class, 'whsqQuickEntryEdit']);
        Route::post('whsq-quick-entry-update', [App\Http\Controllers\WHSQController::class, 'whsqQuickEntryUpdate']);
        // ====================== Incident Injury Classification ========================
        Route::get('incident-injury-classification', [IncidentInjuryClassificationController::class, 'index']);
        Route::get('incident-injury-classification/show', [IncidentInjuryClassificationController::class, 'show']);
        Route::post('incident-injury-classification/store', [IncidentInjuryClassificationController::class, 'store']);
        Route::post('incident-injury-classification/update', [IncidentInjuryClassificationController::class, 'update']);
        Route::delete('incident-injury-classification/{id}', [IncidentInjuryClassificationController::class, 'destroy']);
        // ====================== Incident Injury Type ==================================
        Route::get('incident-injury-type', [IncidentInjuryTypeController::class, 'index']);
        Route::get('incident-injury-type/show', [IncidentInjuryTypeController::class, 'show']);
        Route::post('incident-injury-type/store', [IncidentInjuryTypeController::class, 'store']);
        Route::post('incident-injury-type/update', [IncidentInjuryTypeController::class, 'update']);
        Route::delete('incident-injury-type/{id}', [IncidentInjuryTypeController::class, 'destroy']);
        // ====================== Incident Injury Type ==================================
        Route::get('incident-report-question', [IncidentReportQuestionController::class, 'index']);
        Route::get('incident-report-question/show', [IncidentReportQuestionController::class, 'show']);
        Route::post('incident-report-question/store', [IncidentReportQuestionController::class, 'store']);
        Route::post('incident-report-question/update', [IncidentReportQuestionController::class, 'update']);
        Route::delete('incident-report-question/{id}', [IncidentReportQuestionController::class, 'destroy']);
        // ====================== Incident Risk Category ==================================
        Route::get('incident-risk-category', [IncidentRiskCategoryController::class, 'index']);
        Route::get('incident-risk-category/show', [IncidentRiskCategoryController::class, 'show']);
        Route::post('incident-risk-category/store', [IncidentRiskCategoryController::class, 'store']);
        Route::post('incident-risk-category/update', [IncidentRiskCategoryController::class, 'update']);
        Route::delete('incident-risk-category/{id}', [IncidentRiskCategoryController::class, 'destroy']);
        // ====================== Incident Notifiable Classification  ==================================
        Route::get('incident-notifi-classification', [NotifiableClassificationController::class, 'index']);
        Route::get('incident-notifi-classification/show', [NotifiableClassificationController::class, 'show']);
        Route::post('incident-notifi-classification/store', [NotifiableClassificationController::class, 'store']);
        Route::post('incident-notifi-classification/update', [NotifiableClassificationController::class, 'update']);
        Route::delete('incident-notifi-classification/{id}', [NotifiableClassificationController::class, 'destroy']);
        Route::get('training', [TrainingController::class, 'index']);
        Route::get('training/show/{id}', [TrainingController::class, 'show']);
        Route::post('training/store', [TrainingController::class, 'store']);
        Route::post('training/update/{id}', [TrainingController::class, 'update']);
        Route::delete('training/delete/{id}', [TrainingController::class, 'destroy']);
        // customer General Settings
        Route::post('general-settings/store', [AdminsettingsController::class, 'store']);
        Route::post('general-settings/update', [AdminsettingsController::class, 'update']);
        Route::get('general-settings', [AdminsettingsController::class, 'show']);

        // ====================== SafetyDataSheetController ==================================
        Route::get('data/sheet/get', [SafetyDataSheetController::class, 'index']);
        Route::post('data/sheet/store', [SafetyDataSheetController::class, 'store']);
        Route::post('data/sheet/update', [SafetyDataSheetController::class, 'update']);
        Route::delete('data/sheet/delete/{id}', [SafetyDataSheetController::class, 'delete']);
        Route::get('data/sheet/show/{id}', [SafetyDataSheetController::class, 'show']);
        //Attendance Logs
        Route::post('get-attendance-logs', [SettingsController::class, 'getAttendanceLogs']);
        //Roster Leave
        Route::post('edit-leave-for-roster', [LeaveRequestController::class, 'edit_leave_for_roster']);
        Route::post('leave-request-update', [LeaveRequestController::class, 'update']);
        Route::post('leave-view', [LeaveRequestController::class, 'leave_view'])->middleware('Permissions:Leave Request View');
        // ====================== SWMS report  ==================================
        Route::get('/swms-report-settings', [SWMSReportController::class, 'index']);
        //////////////////////////////////////////////// settings /////////////////////////////
        Route::post('/swms-report-settings-store', [SWMSReportController::class, 'swmsHazardRiskStore']);
        Route::get('/swms-report-settings-get', [SWMSReportController::class, 'swmsHazardRiskGet']);
        Route::post('/swms-report-settings-update', [SWMSReportController::class, 'swmsHazardRiskUpdate']);
        Route::delete('/swms-report-settings-delete/{id}', [SWMSReportController::class, 'swmsHazardRiskDelete']);
        Route::post('/swms-report-question-settings-store', [SWMSReportController::class, 'swmsHazardRiskQuestionStore']);
        Route::get('/swms-report-question-settings-get', [SWMSReportController::class, 'swmsQuestionGet']);
        Route::post('/swms-report-question-settings-update', [SWMSReportController::class, 'swmsQuestionUpdate']);
        Route::delete('/swms-report-question-settings-delete/{id}', [SWMSReportController::class, 'swmsQuestionDelete']);
        Route::post('/swms-safty-planning-question-settings-store', [SWMSReportController::class, 'swmsSafetyPlanningQuestionStore']);
        Route::get('/swms-safty-planning-settings-get', [SWMSReportController::class, 'swmsSafetyPlanningQuestionGet']);
        Route::post('/swms-safty-planning-settings-update', [SWMSReportController::class, 'swmsSafetyPlanningQuestionUpdate']);
        Route::delete('/swms-safty-planning-settings-delete/{id}', [SWMSReportController::class, 'swmsSafetyPlanningQuestionDelete']);
        Route::post('/swms-general-notes-settings-store', [SWMSReportController::class, 'swmsGeneralNotesStore']);
        Route::get('/swms-general-notes-settings-get', [SWMSReportController::class, 'swmsGeneralNotesGet']);
        Route::post('/swms-general-notes-update', [SWMSReportController::class, 'swmsGeneralNotesUpdate']);
        Route::delete('/swms-general-notes-settings-delete/{id}', [SWMSReportController::class, 'swmsGeneralNotesDelete']);
        Route::post('/swms-protection-tool-settings-store', [SWMSReportController::class, 'swmsProtectionToolStore']);
        Route::get('/swms-protection-tool-settings-get', [SWMSReportController::class, 'swmsProtectionToolGet']);
        Route::post('/swms-protection-tool-update   ', [SWMSReportController::class, 'swmsProtectionTOolUpdate']);
        Route::delete('/swms-protection-tool-settings-delete/{id}', [SWMSReportController::class, 'swmsProtectionToolDelete']);
        Route::get('/swms-report-list', [SwmsStepsController::class, 'index']);
        Route::get('/swms-report-list/create/{step}/{swms_report_id}', [SwmsStepsController::class, 'stepsHome']);
        Route::get('/swms-report-pdf-download/{id}', [SwmsStepsController::class, 'swmsReportDownloadPdf']);
        Route::get('/swms-report-pdf-download-regenerate/{id}', [SwmsStepsController::class, 'swmsReportDownloadPdfRegenerate']);
        Route::get('/swms-report-view-signature/{id}', [SwmsStepsController::class, 'swmsReportViewSignature']);
        Route::post('/swms-report-image-store', [SwmsStepsController::class, 'imageStore'])->name('swmsImages.store');
        Route::delete('/swms-report-delete-image/{id}', [SwmsStepsController::class, 'deleteImage'])->name('swmsImages.destroy');
        Route::get('/swms-report-pdf-list', [SwmsStepsController::class, 'swmsReportPdfFilesManager']);
        Route::get('files/download/{filename}', [SwmsStepsController::class, 'downloadSwmsPdfFile'])->name('swmsfiles.download');
        Route::get('/swms-report-pdf-publish/{id}', [SwmsStepsController::class, 'swmsReportPublishReport']);
        Route::get('/swms-report-duplicate/{id}', [SwmsStepsController::class, 'duplicateSwmsReport']);
        //------------------------ SWMS STEPS STORE -------------------------
        Route::get('/swms-report-list-data', [SwmsStepsController::class, 'swmsReportListData']);
        Route::delete('/swms-report-delete-list-record/{id}', [SwmsStepsController::class, 'swmsReportRecordDelete']);
        Route::post('/swms-report-quick-entry', [SwmsStepsController::class, 'swmsQuickEntryStore']);
        Route::post('swms-quick-entry-edit', [SwmsStepsController::class, 'swmsQuickEntryEdit']);
        Route::post('swms-quick-entry-update', [SwmsStepsController::class, 'swmsQuickEntryUpdate']);
        
        Route::post('/swms-report-store-step1', [SwmsStepsController::class, 'swmsStep1Store']);
        Route::post('/swms-report-edit-step1', [SwmsStepsController::class, 'swmsStep1Edit']);
        Route::post('/swms-report-store-step2', [SwmsStepsController::class, 'swmsStep2Store']);
        Route::post('/swms-report-edit-step2', [SwmsStepsController::class, 'swmsStep2Edit']);
        Route::post('/swms-report-store-step3', [SwmsStepsController::class, 'swmsStep3Store']);
        Route::post('/swms-report-edit-step3', [SwmsStepsController::class, 'swmsStep3Edit']);
        Route::delete('/swms-report-delete-developed-by-step3/{id}', [SwmsStepsController::class, 'swmsStep3DevelopedByDelete']);
        Route::delete('/swms-report-delete-approved-by-step3/{id}', [SwmsStepsController::class, 'swmsStep3ApprovedByDelete']);
        Route::delete('/swms-report-delete-review-responsible-step3/{id}', [SwmsStepsController::class, 'swmsStep3ReviewByDelete']);
        Route::delete('/swms-report-delete-monitring-responsible-step3/{id}', [SwmsStepsController::class, 'swmsStep3MonitoringByDelete']);
        Route::delete('/swms-report-delete-compliance-responsible-step3/{id}', [SwmsStepsController::class, 'swmsStep3ComplianceByDelete']);
        Route::post('/swms-report-store-step4', [SwmsStepsController::class, 'swmsStep4Store']);
        Route::post('/swms-report-edit-step4', [SwmsStepsController::class, 'swmsStep4Edit']);
        Route::delete('/swms-report-delete-task-details-step3/{id}', [SwmsStepsController::class, 'swmsStep3TaskDetailDelete']);
        Route::post('/swms-report-store-step5', [SwmsStepsController::class, 'swmsStep5Store']);
        Route::post('/swms-report-edit-step5', [SwmsStepsController::class, 'swmsStep5Edit']);
        Route::post('/swms-report-store-step6', [SwmsStepsController::class, 'swmsStep6Store']);
        Route::post('/swms-report-edit-step6', [SwmsStepsController::class, 'swmsStep6Edit']);
        Route::post('/swms-report-store-step7', [SwmsStepsController::class, 'swmsStep7Store']);
        Route::post('/swms-report-images-list', [SwmsStepsController::class, 'getImages']);
        Route::post('/swms-report-signature', [SwmsStepsController::class, 'SwmsSignature']);
        Route::delete('/swms-report-delete-signature-step6', [SwmsStepsController::class, 'swmsStep6SignatureDelete']);

    Route::resource('assets', AssetController::class);
    Route::get('asset/dashboard', [AssetController::class, 'getDashboard']);


        // Defect Management
        Route::prefix('defects')->group(function () {
            Route::get('/', [DefectController::class, 'index']);
            Route::post('/store', [DefectController::class, 'store']);
            Route::get('/show/{id}', [DefectController::class, 'show']);
            Route::post('/update', [DefectController::class, 'update']);
            Route::delete('/delete/{id}', [DefectController::class, 'destroy']);
            Route::post('/submit', [DefectController::class, 'submitCompletion']);
            Route::get('/employee-assigned', [DefectController::class, 'getEmployeeAssignedDefects']);
            Route::post('/mark-in-progress', [DefectController::class, 'markInProgress']);
            Route::post('/images/add', [DefectController::class, 'addImages']);
            Route::delete('/images/delete/{id}', [DefectController::class, 'deleteImages']);
            Route::post('/approve', [DefectController::class, 'approve']);
            Route::post('/reject', [DefectController::class, 'reject']);
            Route::post('/reassign', [DefectController::class, 'reassign']);
            Route::get('/{id}/history', [DefectController::class, 'history']);
            
            // Assignment entity routes
            Route::get('/assignable-entities', [DefectController::class, 'getAssignableEntities']);
            Route::get('/assignable-internal-employees', [DefectController::class, 'getAssignableInternalEmployees']);
            Route::get('/assignable-subcontractors', [DefectController::class, 'getAssignableSubcontractors']);
            Route::get('/assignable-subcontractor-employees', [DefectController::class, 'getAssignableSubcontractorEmployees']);
        });

        // Site Diary API Routes
        Route::prefix('site-diary')->group(function () {
            Route::get('/', [SiteDiaryController::class, 'index']);
            Route::post('/store', [SiteDiaryController::class, 'store']);
            Route::get('/show/{id}', [SiteDiaryController::class, 'show']);
            Route::post('/update', [SiteDiaryController::class, 'update']);
            Route::delete('/delete/{id}', [SiteDiaryController::class, 'destroy']);
            Route::delete('/images/delete/{id}', [SiteDiaryController::class, 'deleteImage']);
            Route::post('/tasks/toggle', [SiteDiaryController::class, 'toggleTask']);
            Route::post('/generate-summary', [SiteDiaryController::class, 'generateSummary']);
        });

        // WHSQ API Routes
        Route::prefix('whsq')->group(function () {
            Route::get('/', [App\Http\Controllers\WHSQController::class, 'index']);
            Route::get('/{id}', [App\Http\Controllers\WHSQController::class, 'show']);
            Route::post('/store', [App\Http\Controllers\WHSQController::class, 'store']);
            Route::delete('/delete/{id}', [App\Http\Controllers\WHSQController::class, 'destroy']);
            Route::get('/publish/{id}', [App\Http\Controllers\WHSQController::class, 'publish']);
            Route::get('/duplicate/{reportId}', [App\Http\Controllers\WHSQController::class, 'duplicate']);
            // PDF operations
            Route::get('/{id}/pdf', [App\Http\Controllers\WHSQController::class, 'generatePdf']);
            // Report data for PDF generation (frontend will handle PDF creation)
            Route::get('/report-data/{id}', [App\Http\Controllers\WHSQController::class, 'getReportDataForPDF']);
            // WHSQ Report Settings Routes
            Route::prefix('settings')->group(function () {
                Route::get('/index', [App\Http\Controllers\WhsqReportSettingController::class, 'index']);
                Route::get('/show/{id}', [App\Http\Controllers\WhsqReportSettingController::class, 'show']);
                Route::post('/store', [App\Http\Controllers\WhsqReportSettingController::class, 'store']);
                Route::get('/edit/modeltype/{modelType}/{id}', [App\Http\Controllers\WhsqReportSettingController::class, 'edit']);
                Route::put('/update/{modelType}/{id}', [App\Http\Controllers\WhsqReportSettingController::class, 'update']);
                Route::delete('/delete/{modelType}/{id}', [App\Http\Controllers\WhsqReportSettingController::class, 'destroy']);
                Route::get('/grand-parents/{parentId}', [App\Http\Controllers\WhsqReportSettingController::class, 'getGrandParents']);
                Route::post('/store-settings-of-table-of-content', [App\Http\Controllers\WhsqReportSettingController::class, 'storeSettingsOfTableOfContent']);
                Route::get('/{entity_type}/{id}', [App\Http\Controllers\WhsqReportSettingController::class, 'showSettings']);
                // New dynamic content routes
                Route::get('/step/{stepId}', [App\Http\Controllers\WhsqReportSettingController::class, 'getStepSettings']);
            });
            // ====================== WHSQEReportLogController ==================================
            // Route::get('/report-logs', [WHSQEReportLogController::class, 'index']);
            Route::get('/report-logs/{reportId}', [WHSQEReportLogController::class, 'getReportLogs']);
            // New dynamic step content routes
            Route::get('/step-content/{stepId}/{reportId}', [App\Http\Controllers\WHSQController::class, 'getStepContent']);
            Route::post('/step-content', [App\Http\Controllers\WHSQController::class, 'saveStepContent']);
            Route::get('/progress/{reportId}', [App\Http\Controllers\WHSQController::class, 'getReportProgress']);
            // Step navigation route
            Route::get('/step-navigation/{stepId}/{reportId}', [App\Http\Controllers\WHSQController::class, 'getStepNavigation']);
            // Selected settings routes
            Route::post('/selected-settings', [App\Http\Controllers\WHSQController::class, 'saveSelectedSettings']);
            Route::get('/selected-settings/{reportId}', [App\Http\Controllers\WHSQController::class, 'getSelectedSettings']);
            // Customer-specific step settings
            Route::get('/step-settings-customer/{stepId}/{reportId?}', [App\Http\Controllers\WhsqReportSettingController::class, 'getStepSettingsForCustomer']);

            // WHSQ Signature Routes
            Route::prefix('signatures')->group(function () {
                Route::get('/get', [App\Http\Controllers\WhsqSignatureController::class, 'index']);
                Route::post('/store', [App\Http\Controllers\WhsqSignatureController::class, 'store']);
                //  Route::post('/bulk-update', [App\Http\Controllers\WhsqSignatureController::class, 'bulkUpdate']);
                Route::get('/show/{id}', [App\Http\Controllers\WhsqSignatureController::class, 'show']);
                Route::post('/update/{id}', [App\Http\Controllers\WhsqSignatureController::class, 'update']);
                Route::delete('delete/{id}', [App\Http\Controllers\WhsqSignatureController::class, 'destroy']);
                Route::get('/report/{reportId}', [App\Http\Controllers\WhsqSignatureController::class, 'getByReport']);
                Route::get('/employee/{employeeId}', [App\Http\Controllers\WhsqSignatureController::class, 'getByEmployee']);
            });
        });
    });

    Route::get('/meetings/get-employee', [MeetingController::class, 'getEmployeeMeetings']);

    // =======================  Payroll Management Routes ======================= 
    Route::prefix('payroll')->group(function () {
        // Payroll routes
        Route::get('/', [PayrollController::class, 'index']);
        Route::post('/store', [PayrollController::class, 'store']);
        Route::get('/show/{id}', [PayrollController::class, 'show']);
        Route::post('/update', [PayrollController::class, 'update']);
        Route::post('/toggle-status', [PayrollController::class, 'toggleStatus']);
        Route::delete('/delete/{id}', [PayrollController::class, 'destroy']);
        Route::get('/receipt/{id}', [PayrollController::class, 'getPayrollReceipt']);
        Route::get('/details/{id}', [PayrollController::class, 'viewDetails']);

        // Payslip generation
        Route::get('/select-employees', [PayrollController::class, 'selectEmployeesForPayslip']);
        Route::post('/generate-slips', [PayrollController::class, 'generateSelectedSlips']);
        Route::post('/bulk-delete', [PayrollController::class, 'bulkDelete']);
        Route::get('/roster-hours', [PayrollController::class, 'getRosterWorkingHours']);

        // PDF operations
        Route::post('/save-receipts/{id}', [PayrollController::class, 'savePayrollPdf']);
        Route::post('/save-attendance/{id}', [PayrollController::class, 'savePayrollAtt']);
        Route::get('/download-receipt/{id}', [PayrollController::class, 'downloadPayrollPdf']);
        Route::get('/download-attendance/{id}', [PayrollController::class, 'downloadAttendancePdf']);
        Route::get('/attendance-pdf/{id}', [PayrollController::class, 'attendancePdf']);
        Route::post('/send-email', [PayrollController::class, 'sendReceiptEmail']);
        Route::get('/{id}/receipt', [PayRollController::class, 'getPayrollReceipt']);

        Route::post('/generate/selected-slips', [PayrollController::class, 'generateReceiptsForAllEmployees']);


        // Fine management
        Route::get('/fines', [PayrollController::class, 'fineManagement']);
        Route::post('/fines/store', [PayrollController::class, 'fineStore']);
        Route::post('/fines/update', [PayrollController::class, 'fineUpdate']);
        Route::delete('/fines/delete/{id}', [PayrollController::class, 'fineDestroy']);
        Route::get('/fines/show/{id}', [PayrollController::class, 'fineManagementEdit']);

        // Salary management
        Route::get('/salaries', [PayrollController::class, 'salaryIndex']);
        Route::post('/salaries/store', [PayrollController::class, 'salaryStore']);
        Route::post('/salaries/update', [PayrollController::class, 'salaryUpdate']);
        Route::delete('/salaries/delete/{id}', [PayrollController::class, 'salaryDestroy']);
        Route::get('/salaries/edit/{id}', [PayrollController::class, 'salaryEdit']);

        // Overtime management
        Route::get('/overtime', [OvertimeController::class, 'index']);
        Route::post('/overtime/store', [OvertimeController::class, 'store']);
        Route::get('/overtime/show/{id}', [OvertimeController::class, 'show']);
        Route::post('/overtime/update', [OvertimeController::class, 'update']);
        Route::post('/overtime/update-status', [OvertimeController::class, 'updateStatus']);
        Route::delete('/overtime/delete/{id}', [OvertimeController::class, 'destroy']);
        Route::post('/overtime/apply', [OvertimeController::class, 'applyOvertime']);
        Route::post('/overtime/bulk-delete', [OvertimeController::class, 'bulkDelete']);
    });

    // Leave Management
    Route::resource('public-holiday', LeaveController::class);
    Route::post('public-holiday-update/{id}', [LeaveController::class, 'updatePublicHoliday']);
    // Leave Type 
    Route::resource('leave-type', LeaveTypeController::class);
    Route::post('leave-type-update/{id}', [LeaveTypeController::class, 'updatePublicHoliday']);
    //Leave Package
    Route::post('/leavepackage-store', [LeavePackageController::class, 'store']);
    Route::get('/leavepackage-get', [LeavePackageController::class, 'index']);
    // Route::post('/leavepackage-get-for-employee', [LeavePackageController::class, 'getLeavePackagesForEmployee']);
    Route::get('/leavepackage-delete/{id}', [LeavePackageController::class, 'destroy']);
    Route::get('/leavepackage-edit/{id}', [LeavePackageController::class, 'leavePackageEdit']);
    Route::post('/leavepackage-update/{id}', [LeavePackageController::class, 'update']);
    //Leave Package
    Route::post('/leave-request-store', [LeaveRequestController::class, 'store']);
    Route::get('/leave-request-get', [LeaveRequestController::class, 'index']);
    Route::get('/leave-request-delete/{id}', [LeaveRequestController::class, 'destroy']);
    Route::post('/leave-request-update/{id}', [LeaveRequestController::class, 'update']);
    Route::post('/leave-request/update-status/{id}', [LeaveRequestController::class, 'updateStatus']);
    Route::get('/leave-request-reason/{id}', [LeaveRequestController::class, 'leavereason']);
    Route::get('/leave-view/{id}', [LeaveRequestController::class, 'view']); //->middleware('Permissions:Leave Request View');
    Route::get('/leave-portal', [LeaveRequestController::class, 'leave_portal']); // ->middleware('Permissions:Leaves Portal View')
    Route::post('/remaining-leave', [LeaveRequestController::class, 'remainingleave']);
    Route::post('/leave-count/{id}', [LeaveRequestController::class, 'leave_count']);
    Route::get('/leave-pkg', [LeaveRequestController::class, 'leave_pkg']);
    Route::get('/upcoming-leave', [LeaveRequestController::class, 'upcoming_leave']);
    Route::get('/approved-leave', [LeaveRequestController::class, 'approved_leave']);
    Route::get('/rejected-leave', [LeaveRequestController::class, 'rejected_leave']);
    Route::get('/exipired-leave', [LeaveRequestController::class, 'exipired_leave']);
    // Customer tiers 
    Route::resource('customer/tiers', TierController::class);
    Route::post('customer/tiers/updated', [TierController::class, 'tier_update']);
    Route::get('customer/tier-emp/{id}', [TierController::class, 'tier_emp']);
    // Roster
    Route::resource('/roaster', RosterTemplateController::class);
    Route::post('/leave-request-store', [LeaveRequestController::class, 'store']); //Leave request 
    Route::post('/roaster/template_assign', [RosterTemplateController::class, 'templateAssign']); // Single template  assigne
    Route::post('/roaster/bulk-schedule-save', [RosterTemplateController::class, 'bulkScheduleSave']);
    Route::post('/roaster/bulk-schedule-update', [RosterTemplateController::class, 'bulkScheduleUpdate']);
    Route::get('/get-roaster/history', [RosterTemplateController::class, 'getHistory']);
    Route::post('/roster/bulk-delete', [RosterTemplateController::class, 'deleteTemplate']);
    Route::post('/roaster/publish-custom', [RosterTemplateController::class, 'publishCustom']); // specific employee
    Route::post('/roaster/publish', [RosterTemplateController::class, 'publish']);
    Route::post('/templates/delete', [RosterTemplateController::class, 'templateDelete']); // delete roster template
    Route::get('/templates/in-active', [RosterTemplateController::class, 'inactive']);
    // employee start 
    
    Route::post('/emp-company-details-store', [EmployeeOnboardingController::class, 'empCompanyDetailsStore']);
    Route::post('/emp-company-details-edit', [EmployeeOnboardingController::class, 'empCompanyDetailsEdit']);
    Route::resource('/employee', EmployeeController::class);
    Route::post('/employee/delete', [EmployeeController::class, 'employe_delete']);
    Route::post('/employee/update-status', [EmployeeController::class, 'updateStatus']);
    Route::post('/profile', [EmployeeController::class, 'profile']);
    // Customer employee personel 
    Route::post('/emp-personal-details-edit', [EmployeeOnboardingController::class, 'empPersonalDetailsEdit']);
    Route::post('/emp-personal-details-store', [EmployeeOnboardingController::class, 'empPersonalDetailsStore']);
    // Customer employee Document store
    Route::post('/emp-documents-edit', [EmployeeOnboardingController::class, 'empDocumentsEdit']);
    Route::post('/emp-documents-store', [EmployeeOnboardingController::class, 'empDocumentsStore']);
    // Customer Employee Emergency contact
    Route::post('/emp-emergency-contacts-edit', [EmployeeOnboardingController::class, 'empEmergencyContactsEdit']);
    Route::post('/emp-emergency-contacts-list', [EmployeeOnboardingController::class, 'empEmergencyContactslist']);
    Route::post('/emp-emergency-contacts-store', [EmployeeOnboardingController::class, 'empEmergencyContactsStore']);
    Route::post('/emp-emergency-contacts-store-multi', [EmployeeOnboardingController::class, 'empEmergencyContactsStoreMulti']);
    Route::post('/emp-emergency-contacts-delete', [EmployeeOnboardingController::class, 'empEmergencyContactsDelete']);
    Route::post('/emp-emergency-contacts-count', [EmployeeOnboardingController::class, 'empEmergencyContactsCount']);
    // Customer Employee access
    Route::post('/emp-access-edit', [EmployeeOnboardingController::class, 'empAccessEdit']);
    Route::post('/emp-access-store', [EmployeeOnboardingController::class, 'empAccessStore']);
    /// customer employee donwload
    Route::post('/emp/download', [EmployeeController::class, 'empDownload']);
    // Customer roles
    Route::resource('/role', RoleController::class);
    Route::post('/role/delete', [RoleController::class, 'role_delete']);
    Route::post('/role/edit', [RoleController::class, 'role_edit']);
    Route::post('/role/update', [RoleController::class, 'role_update']);
    // Customer Work permits
    Route::resource('/emp-permit', EmpPermitController::class);
    Route::post('/emp-permit/delete', [EmpPermitController::class, 'permit_delete']);
    Route::post('/emp-permit/edit', [EmpPermitController::class, 'permit_edit']);
    Route::post('/emp-permit/update', [EmpPermitController::class, 'permit_update']);
    // Customer employee types
    Route::resource('/emp-type', EmpTypeController::class);
    Route::post('/emp-type/delete', [EmpTypeController::class, 'type_delete']);
    Route::post('/emp-type/edit', [EmpTypeController::class, 'type_edit']);
    Route::post('/emp-type/update', [EmpTypeController::class, 'type_update']);
    // Customer Employee Teams
    Route::resource('/emp-team', EmpTeamController::class);
    Route::post('/emp-team/delete', [EmpTeamController::class, 'team_delete']);
    Route::post('/emp-team/edit', [EmpTeamController::class, 'team_edit']);
    Route::post('/emp-team/update', [EmpTeamController::class, 'team_update']);
    Route::get('/employee-team/get-supervisors', [EmpTeamController::class, 'get_supervisors']);
    Route::post('/get-team-member', [EmpTeamController::class, 'GetTeamMember']);
    Route::post('/get-team-history', [EmpTeamController::class, 'GetTeamHistory']);
    // Customer required documents 
    Route::resource('/required-document', RequiredDocumentController::class);
    Route::post('/required-document/delete', [RequiredDocumentController::class, 'document_delete']);
    Route::post('/required-document/edit', [RequiredDocumentController::class, 'document_edit']);
    Route::post('/required-document-field-delete', [RequiredDocumentController::class, 'delete_field']);
    Route::post('/required-document/update', [RequiredDocumentController::class, 'update']);
    // Customer work  type
    Route::resource('/emp-worker-type', EmpWorkerTypeController::class);
    Route::post('/emp-worker-type/delete', [EmpWorkerTypeController::class, 'worker_type_delete']);
    Route::post('/emp-worker-type/edit', [EmpWorkerTypeController::class, 'worker_type_edit']);
    Route::post('/emp-worker-type/update', [EmpWorkerTypeController::class, 'worker_type_update']);
    // Customer  emp work experience  work_experience
    Route::resource('/emp-work-experience', EmpWorkExperienceController::class);
    Route::post('/emp-work-experience/delete', [EmpWorkExperienceController::class, 'work_experience_delete']);
    Route::post('/emp-work-experience/edit', [EmpWorkExperienceController::class, 'work_experience_edit']);
    Route::post('/emp-work-experience/update', [EmpWorkExperienceController::class, 'work_experience_update']);
    // Customer Roster Setting
    Route::get('internal-employee-roster-setting', [SettingsController::class, 'getInternalEmployeeRosterSetting']);
    Route::post('internal-employee-roster-setting', [SettingsController::class, 'internalEmployeeRosterSetting']);
    // Customer super funds
    Route::resource('/funds', FundsController::class);
    Route::post('/funds/delete', [FundsController::class, 'funds_delete']);
    Route::post('/funds/edit', [FundsController::class, 'funds_edit']);
    Route::post('/funds/update', [FundsController::class, 'funds_update']);
    //Link Management
    Route::post('/link-management/update-status', [LinkManagementController::class, 'updateStatus']);
    Route::resource('/link-management', LinkManagementController::class);
    Route::post('/link-management/delete', [LinkManagementController::class, 'link_delete']);
    Route::post('/link-management/edit', [LinkManagementController::class, 'link_edit']);
    Route::post('/link-management/update', [LinkManagementController::class, 'link_update']);
    //Customer profile
    Route::post('/customer-profile', [CustomerController::class, 'view']);
    // customer external employee
    Route::post('/external-employee-onboarding-edit', [ExternalEmployeeOnboardingController::class, 'externalEmployeeOnboardingEdit']);
    //Customer profile
    Route::get('/customer-profile/{id}', [CustomerController::class, 'view']);
    //Customer Settings
    Route::resource('/settings', SettingsController::class);
    //Customer Permissions
    Route::resource('/permission', PermissionsController::class);
    Route::post('/tier-related-data', [RoleController::class, 'tierRelatedData']);
    Route::post('/add-permissions', [PermissionsController::class, 'addPermissionModule']);
    Route::get('/edit-permissions/{id}', [PermissionsController::class, 'getModuleById']);
    Route::post('/update-permissions/{id}', [PermissionsController::class, 'updatePermissionModule']);
    Route::post('/delete-permissions/{id}', [PermissionsController::class, 'deletePermissionModule']);
    Route::get('/get-allPermissions', [PermissionsController::class, 'getAllModules']);

  
    //Bank Account
    Route::resource('bank', BankAccountController::class);
    Route::post('bank/{id}/status', [BankAccountController::class, 'updateStatus']);
    //Dashboard
        Route::get('/customer/dashboard', [DashboardController::class, 'index']);
        Route::get('/customer/get-expiring-document', [DashboardController::class, 'expiringDocuments']);
        Route::get('/customer/get-expire-document', [DashboardController::class, 'expiringDocumentsWithin15Days']);
        Route::get('/customer/get-missing-document', [DashboardController::class, 'missingDocuments']);
        Route::get('/customer/get-present-employees', [DashboardController::class, 'presentEmployees']);
        Route::get('/customer/get-absent-employees', [DashboardController::class, 'absentEmployees']);
        Route::get('/customer/pending-document-approvals', [DashboardController::class, 'getPendingDocumentApprovals']);
        Route::post('/send-credentials', [EmployeeOnboardingController::class, 'sendCredentials']);
        
    //Plan get
    Route::get('/customer/plan/{plan}', [PlanController::class, 'show']);
    Route::post('/customer/plan/subscribe', [PlanController::class, 'subscribe']);
    Route::prefix('subscriptions')->group(function () {
        Route::post('/create', [SubscriptionController::class, 'subscribe']);
        Route::post('/cancel', [SubscriptionController::class, 'cancelSubscription']);
        Route::get('/details', [SubscriptionController::class, 'getSubscription']);
        Route::post('/update', [SubscriptionController::class, 'updateSubscription']);
    });
    Route::post('/demo-data', [DemoController::class, 'demoData']);
});

Route::middleware(['auth:admin', 'referral'])->group(function () {
    Route::get('/testroute', function () {
        return response()->json([
            'success' => true,
            'message' => 'Referral middleware is working!',
        ]);
    });
});

Route::middleware('auth:api')->group(function () {
    Route::post('/first-rest-password-logic', [AuthController::class, 'firstRestPasswordLogic']);

    Route::post('/logout', [AuthController::class, 'logout']);
    Route::post('/rejected', [EmployeeOnboardingController::class, 'rejected']);
    Route::post('/profile-submit-history', [EmployeeOnboardingController::class, 'profileSubmitHistory']);
    Route::post('/roaster/history', [RosterTemplateController::class, 'getHistory']);
    Route::post('/roaster/repeat-shift-update', [RosterTemplateController::class, 'repeatShiftUpdate']);
    Route::get('/holiday-desc/{id}', [LeaveController::class, 'holidaydesc']);
    Route::post('/roster-api', [RosterTemplateController::class, 'rosterApi']);
    Route::get('/leave-type-desc/{id}', [LeaveTypeController::class, 'leavetypedesc']);
    ////////////leave Api//////////////////
    Route::post('/attendance', [AttendanceController::class, 'single_employee_attendance']);
    Route::post('get-attendance-stats', [AttendanceController::class, 'getAttendanceStats']);
    Route::post('/applie-leave-request', [LeaveRequestController::class, 'applie_leave_request']);
    Route::post('/leave-request-api', [LeaveRequestController::class, 'leave_request_api']);
    Route::get('/leave-request-get-api', [LeaveRequestController::class, 'leave_request_get_api']);
    Route::get('/leave-request-edit-api', [LeaveRequestController::class, 'leave_request_edit_api']);
    Route::post('/leave-request-update-api/{id}', [LeaveRequestController::class, 'leave_request_update_api']);
    Route::post('/destroy-api/{id}', [LeaveRequestController::class, 'destroy_api']);
    Route::get('/get-leave-request', [LeaveRequestController::class, 'get_leave_request']);
    Route::get('/employee-leave-pkg', [LeaveRequestController::class, 'employee_leave_pkg']);
    /////////////////////////////
    Route::resource('Warnings', WarningController::class);
    Route::post('/get-Warnings', [WarningController::class, 'getUserWarning']);
    Route::post('/update-Warnings', [WarningController::class, 'UpdateUserWarning']);
    Route::resource('comment-management', UserCommentManagementController::class);
    Route::post('/get-comment-management', [UserCommentManagementController::class, 'getUserComment']);
    Route::post('/update-comment-management', [UserCommentManagementController::class, 'UpdateUserComment']);
    Route::get('/tier-desc/{id}', [TierController::class, 'tierdesc']);
    Route::post('/employee-pkg/{id}', [LeaveRequestController::class, 'employee_pkg']);
    Route::post('/tier-package-store', [TierPackageController::class, 'store']);
    Route::get('/tier-package-get', [TierPackageController::class, 'index']);
    Route::post('/tier-package-delete/{id}', [TierPackageController::class, 'destroy']);
    Route::post('/tier-package-update/{id}', [TierPackageController::class, 'update']);
    Route::get('notification', [NotificationController::class, 'index']);
    Route::post('clear-all-notifications', [NotificationController::class, 'clear_all_notifications']);
    Route::post('mark-notification-read', [NotificationController::class, 'markNotificationAsRead']);
    Route::post('mark-all-notifications-read', [NotificationController::class, 'markAllNotificationsAsRead']);
    Route::get('employee-notifications', [NotificationController::class, 'getEmployeeNotifications']);
    
    // Overtime specific notifications
    Route::get('overtime-notifications', [NotificationController::class, 'getOvertimeNotifications']);
Route::get('overtime-notifications/unread-count', [NotificationController::class, 'getUnreadOvertimeNotificationCount']);
Route::get('signature-notifications', [NotificationController::class, 'getSignatureNotifications']);
Route::get('signature-notifications/unread-count', [NotificationController::class, 'getUnreadSignatureNotificationCount']);
Route::get('leave-request-notifications', [NotificationController::class, 'getLeaveRequestNotifications']);
Route::get('leave-request-notifications/unread-count', [NotificationController::class, 'getUnreadLeaveRequestNotificationCount']);

// Report PDF upload notifications
Route::get('report-pdf-upload-notifications', [NotificationController::class, 'getReportPdfUploadNotifications']);
Route::get('report-pdf-upload-notifications/unread-count', [NotificationController::class, 'getUnreadReportPdfUploadNotificationCount']);

    // // Contact Us routes
    // Route::post('contact-us', [ContactUsController::class, 'store']);
    // Route::get('contact-us', [ContactUsController::class, 'index']);
    // Route::get('contact-us/{id}', [ContactUsController::class, 'show']);
    // Route::delete('contact-us/{id}', [ContactUsController::class, 'destroy']);
});

Route::post('/demo-customer', [DemoController::class, 'createDemoCustomer'])
    ->name('demo.customer.create');

// Public Contact Us route (no authentication required)
Route::post('/public/contact-us', [ContactUsController::class, 'store'])
    ->name('public.contact.store');

// Public Demo Request route (no authentication required)
Route::post('/public/demo-request', [DemoRequestController::class, 'store'])
    ->name('public.demo.request.store');

/////////////////// CRON JOB ///////////////////////
Route::get('/check-token', function (Request $req) {
    $token = $req->token;
    $user = Auth::guard('sanctum')->setToken($token)->user();
    return response()->json($user);
});
//logout user on plan expire
Route::get('/check-user-expiry', [SubscriptionController::class, 'checkUserExpiry']);
// Auto checkout for all employees (cron job - no authentication required)
Route::get('/attendance/auto-checkout', [AttendanceController::class, 'autoCheckout']);
Route::get('/meeting/guest/{id}', [MeetingController::class, 'getMeetingGuest']);
Route::post('meeting/guest/add', [MeetingController::class, 'addGuestUserDetailsByGuest']);
// Stripe webhook - This needs to be outside the authentication middleware
Route::post('webhooks/stripe', [PlanController::class, 'handleStripeWebhook']);
// Referral Module Routes
Route::get('/referral/{referralCode}', [LeadController::class, 'showReferralForm']);
Route::post('/referral/{referralCode}/submit', [LeadController::class, 'storeFromReferral']);
Route::post('/password/request-otp', [PasswordResetController::class, 'requestOtp']);
Route::post('/password/verify-otp', [PasswordResetController::class, 'verifyOtp']);
Route::post('/password/reset', [PasswordResetController::class, 'resetPassword']);
Route::post('/demo-customer', [DemoController::class, 'apiCreateDemoCustomerByEmail']);

Route::get('/update-expired-status', [LeaveRequestController::class, 'updateExpiredLeaveStatus'])
    ->name('leave.update.expired.status');
Route::get('public/pages', [PageController::class, 'indexWeb']);
Route::get('public/pages/show/{permalink}', [PageController::class, 'showWeb']);
Route::get('public/faq/modules-with-faqs', [FAQController::class, 'getGroupedByModules']);
Route::get('public/faq/page/{pageSlug?}', [FAQController::class, 'getByPageSlug']);

// Broadcasting authentication route

// Get employees for starting new chats
Route::get('/employees/for-chat',[EmployeeController::class, 'getEmployeesForChat'])->middleware('auth:api');

/*
|--------------------------------------------------------------------------
| Webhook Routes for External Order Access
|--------------------------------------------------------------------------
|
| These routes allow external projects to access order data via webhooks
| with proper authentication using webhook secrets.
|
*/

Route::prefix('webhook')->middleware(['webhook.auth'])->group(function () {
    // Get all orders with filtering and pagination
    Route::get('/orders', [WebhookController::class, 'getAllOrders']);
    
});

