<?php

namespace App\Http\Controllers;

use App\Models\BankAccount;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

class BankAccountController extends Controller
{

    public function index()
    {
        $created_by = Auth::user()->id;
        $workspace_id = Auth::user()->current_workspace_id;
        $bankAccount = BankAccount::where('workspace',$workspace_id)->where('created_by',$created_by)->get();

        return response()->json([
            'message' => 'Bank account list fetched successfully.',
            'data' => $bankAccount
        ]);
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'holder_name' => 'nullable|string|max:255',
            'chart_account_id' => 'nullable|integer',
            'bank_name' => 'nullable|string|max:255',
            'bank_type' => 'nullable|string|max:255',
            'wallet_type' => 'nullable|string|max:255',
            'account_number' => 'nullable|integer',
            'opening_balance' => 'nullable|integer',
            'contact_number' => 'nullable|integer',
            'bank_address' => 'nullable|string|max:255',
            'bank_branch' => 'nullable|string|max:255',
            'swift' => 'nullable|string|max:255',
        ]);
        $created_by = Auth::user()->id;
        $workspace_id = Auth::user()->current_workspace_id;

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $bankAccount = BankAccount::create([
            'holder_name' => $request->holder_name,
            'chart_account_id' => $request->chart_account_id,
            'bank_name' => $request->bank_name,
            'bank_type' => $request->bank_type,
            'wallet_type' => $request->wallet_type,
            'account_number' => $request->account_number,
            'opening_balance' => $request->opening_balance,
            'contact_number' => $request->contact_number,
            'bank_address' => $request->bank_address,
            'bank_branch' => $request->bank_branch,
            'swift' => $request->swift,
            'workspace' => $workspace_id,
            'created_by' => $created_by,
        ]);


        return $this->success($bankAccount, 'Bank account created successfully.');

    }

    public function show(Request $request) 
    {
        //
    }


    public function edit($id)
    {
        $bankAccount = BankAccount::where('id', $id)->first();

        return response()->json([
            'message' => 'Bank account details fetched successfully.',
            'data' => $bankAccount
        ]);
    }

    public function update(Request $request, $id)
    {

        $bankAccount = BankAccount::findOrFail($id);

        $validator = Validator::make($request->all(), [
            'holder_name' => 'nullable|string|max:255',
            'chart_account_id' => 'nullable|integer',
            'bank_name' => 'nullable|string|max:255',
            'bank_type' => 'nullable|string|max:255',
            'wallet_type' => 'nullable|string|max:255',
            'account_number' => 'nullable|integer',
            'opening_balance' => 'nullable|integer',
            'contact_number' => 'nullable|integer',
            'bank_address' => 'nullable|string|max:255',
            'bank_branch' => 'nullable|string|max:255',
            'swift' => 'nullable|string|max:255',
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $created_by = Auth::user()->id;
        $workspace_id = Auth::user()->current_workspace_id;

        $bankAccount->update([
            'holder_name' => $request->holder_name,
            'chart_account_id' => $request->chart_account_id,
            'bank_name' => $request->bank_name,
            'bank_type' => $request->bank_type,
            'wallet_type' => $request->wallet_type,
            'account_number' => $request->account_number,
            'opening_balance' => $request->opening_balance,
            'contact_number' => $request->contact_number,
            'bank_address' => $request->bank_address,
            'bank_branch' => $request->bank_branch,
            'swift' => $request->swift,
            'workspace' => $workspace_id,  
            'created_by' => $created_by,  
        ]);

        return response()->json([
            'message' => 'Bank account updated successfully.',
            'data' => $bankAccount
        ]);
    }

    public function destroy($id)
    {
        $bankAccount = BankAccount::findOrFail($id);

        $bankAccount->delete();

        return response()->json([
            'message' => 'Bank account deleted successfully.'
        ]);
    }

    public function updateStatus(Request $request, $id)
    {

        $validator = Validator::make($request->all(), [
            'status' => 'required|boolean', 
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $bankAccount = BankAccount::findOrFail($id);

        $bankAccount->update([
            'status' => $request->status, 
        ]);
        return response()->json([
            'message' => 'Bank account status updated successfully.',
            'data' => $bankAccount
        ]);
    }
}
