<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class CustomerController extends Controller
{
 
    public function store(Request $request)
    {
        return $this->handleCustomerCreate($request);   
    }
    public function signup(Request $request)
    {
        return $this->signuphandle($request);   
    }

    public function show(Request $request)
    {
        return $this->handleCustomerShow($request);   
    }

    public function view(Request $request)
    {
        $id=$request->id;

        return $this->handleCustomerProfile($id);   
    }

    public function passwordReset(Request $request){
        return $this->handleAdminResetPassword($request);    
    }

    public function editCustomer(Request $request){
        return $this->handleAdminCustomerEdit($request); 
    }
    public function deleteCustomer($id){
        return $this->handleAdminCustomerDelete($id); 
    }
    public function toggleUserLogin(Request $request)
    {
        return $this->handleToggleUserLogin($request);
    }
    public function companyLogin(Request $request)
    {
        return $this->handleCompanyLogin($request);
    }
    public function assignPlan(Request $request)
    {
        return $this->handleAssignPlan($request);
    }
    
    /**
     * Get authenticated customer profile with plan details
     * 
     * @return \Illuminate\Http\JsonResponse
     */
    public function getProfile()
    {
        return $this->getCustomerProfile();
    }
    
    /**
     * Update authenticated customer profile
     * 
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateProfile(Request $request)
    {
        return $this->updateCustomerProfile($request);
    }
    
    /**
     * Send test email to verify email template design
     * 
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function sendTestEmail(Request $request)
    {
        try {
            $validator = \Illuminate\Support\Facades\Validator::make($request->all(), [
                'email' => 'required|email',
            ]);
            
            if ($validator->fails()) {
                return $this->handleValidationFailure($validator);
            }
            
            // Get authenticated customer ID
            $ids = $this->getCustomerAndWorkspaceIds();
            $customerId = $ids['customer_id'];
            $workspaceId = $ids['workspace_id'];
            
            $email = $request->email;
            $brandTitle = getBrandTitle($customerId ?? null, $workspaceId ?? null);

            $subject = 'Test Email - Template Design Verification';
            $subject .= ' | ' . $brandTitle;
            
            // Prepare email content using the test email template
            $emailContent = view('Emails.test-email', [
                'subject' => $subject,
                'customer_id' => $customerId,
                'workspace_id' => $workspaceId,
            ])->render();
            
            // Send email using EmailTrait
            $emailParams = [
                'to' => $email,
                'subject' => $subject,
                'msg' => $emailContent,
                'customer_id' => $customerId,
                'workspace_id' => $workspaceId,
            ];
            
            $emailSent = $this->SendInstantEmail($emailParams);
            
            if ($emailSent) {
                return $this->success([
                    'email' => $email,
                    'message' => 'Test email sent successfully'
                ], 'Test email sent successfully');
            } else {
                return $this->error('Failed to send test email. Please check your email configuration.', 500);
            }
        } catch (\Exception $e) {
            \Illuminate\Support\Facades\Log::error('Error sending test email: ' . $e->getMessage(), [
                'trace' => $e->getTraceAsString()
            ]);
            return $this->error('An error occurred while sending the test email: ' . $e->getMessage(), 500);
        }
    }
}
