<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Traits\DefectTrait;

class DefectController extends Controller
{
    use DefectTrait;
    /////////////////// Defect Management Ceater ///////////////////
    public function index(Request $request)
    {
        return $this->getDefects($request);
    }

    public function store(Request $request)
    {
        
        return $this->createDefect($request);
    }

    public function show($id)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        return $this->getDefectById($id, $ids);
    }

    public function update(Request $request)
    {
        return $this->updateDefect($request);
    }

    public function destroy($id)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        return $this->deleteDefect($id, $ids);
    }

 /////////////////// Defect Management end ///////////////////


    public function addImages(Request $request)
    {
        return $this->addDefectImages($request);
    }

    public function deleteImages($id)
    {
        $ids = $this->getCustomerAndWorkspaceIds();
        return $this->deleteDefectImages($id, $ids);
    }

    
    public function approve(Request $request)
    {
        return $this->approveDefect($request);
    }

    public function reject(Request $request)
    {
        return $this->rejectDefect($request);
    }

    public function reassign(Request $request)
    {
        return $this->reassignDefect($request);
    }

    public function history($id)
    {
        return $this->getDefectHistory($id);
    }

    /////////////////// Defect Management Assign Employee  ///////////////////
    
    public function getEmployeeAssignedDefects(Request $request)
    {
        return $this->getAssignedDefectsForEmployee();
    }

    public function submitCompletion(Request $request)
    {
        return $this->submitCompletionDefect($request);
    }

    public function markInProgress(Request $request)
    {
        return $this->markInProgressDefect($request);
    }

    // Get assignable entities for defect assignment
    public function getAssignableEntities()
    {
        return $this->getAllAssignableEntities();
    }

    public function getAssignableInternalEmployees()
    {
        return $this->getAssignableInternalEmployees();
    }

    public function getAssignableSubcontractors()
    {
        return $this->getAssignableSubcontractors();
    }

    public function getAssignableSubcontractorEmployees(Request $request)
    {
        $subcontractorId = $request->get('subcontractor_id');
        return $this->getAssignableSubcontractorEmployees($subcontractorId);
    }

    /////////////////// Defect Management for Subcontractor  ///////////////////
    
    public function getSubcontractorAssignedDefects(Request $request)
    {
        return $this->getAssignedDefectsForSubcontractor($request);
    }

    public function assignDefectToSubcontractorEmployee(Request $request)
    {
        return $this->assignDefectToSubcontractorEmp($request);
    }

}
