<?php

namespace App\Http\Controllers;

use DB;
use App\Models\User;
use App\Models\EmpTeam;
use Illuminate\Http\Request;
use App\Models\EmpWorkerType;
use App\Models\EmpPersonalDetails;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class EmpWorkerTypeController extends Controller
{
    public function index()
    {
        $query = EmpWorkerType::query();
        $query = $this->applyCustomerWorkspaceFilter($query);
        $emp_worker_types =  $query->get();
        return $this->success($emp_worker_types, 'Worker Type Get Successfully');
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ]);
        if ($validator->fails()) {
            return $this->handleValidationFailure($validator);
        }
        $validatedData =  $validator->validated();
        $ids = $this->getCustomerAndWorkspaceIds();
        $validatedData['customer_id'] = $ids['customer_id'];
        $validatedData['workspace_id'] = $ids['workspace_id'];
        $validatedData['created_by'] = Auth::user()->id;
        EmpWorkerType::insert($validatedData);
        $emp_worker_types =  EmpWorkerType::where('customer_id', $ids['customer_id'])
            ->where('workspace_id', $ids['workspace_id'])
            ->where('del', '0')
            ->get();
        $data['emp_worker_types'] = $emp_worker_types;
        return $this->success($data, 'Worker Type Saved Successfully');
    }

    public function show($id)
    {
        //
    }

    public function worker_type_edit(Request $request)
    {
        $query = EmpWorkerType::query();
        $query = $this->applyCustomerWorkspaceFilter($query);
        $query = $query->find($request->id);
        if(!$query){
            return $this->error('Worker Type Not Found', 404);
        }
        $data['emp_worker_types'] = $query;
        return $this->success($data, 'Worker Type Get Successfully');
    }

    public function worker_type_update(Request $request)
    {
        $user = auth()->user();
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ]);

        if ($validator->fails()) {

            $errors = $validator->errors();
            return $this->error($errors, 422);
        } else {
            $validatedData =  $validator->validated();
            $id = $request->id;
            $emp_worker_types = EmpWorkerType::where('id', $id)->first();
            $userTable = $this->getUserTable();

            if (
                $userTable == "customer" && ($emp_worker_types->workspace_id != auth()->user()->current_workspace_id || $emp_worker_types->customer_id != auth()->user()->id)
            ) {
                return $this->message('You do not have access to this Employee worker Types', 403);
            }

            if ($userTable == "emp" && ($emp_worker_types->customer_id != auth()->user()->customer_id || $emp_worker_types->workspace_id != auth()->user()->workspace_id)) {
                return $this->message('You do not have access to this Employee worker Types', 403);
            }
            if (!$emp_worker_types) {
                return $this->notFound('Employee worker Types Not Found', 404);
            }
            $emp_worker_types->update($validatedData);
            if ($userTable == "customer") {
                $data['emp_worker_types'] = EmpWorkerType::where('customer_id', $user->id)
                    ->where('workspace_id', $user->current_workspace_id)
                    ->where('del', '0')
                    ->get();
            } elseif ($userTable == "emp") {
                $data['emp_worker_types'] = EmpWorkerType::where('customer_id', auth()->user()->customer_id)
                    ->where('workspace_id', auth()->user()->workspace_id)
                    ->where('del', '0')
                    ->get();
            }

            return $this->success($data, 'Worker Type Updated Successfully');
        }
    }

    public function worker_type_delete(Request $request)
    {
        $id = $request->id;
        $userTable = $this->getUserTable();
        $EmpWorkerType = EmpWorkerType::find($id);
        if ($userTable == "customer" && ($EmpWorkerType->workspace_id != auth()->user()->current_workspace_id || $EmpWorkerType->customer_id != auth()->user()->id)) {
            return $this->message('You do not have access to this Employee Worker', 403);
        }
        if ($userTable == "emp" && ($EmpWorkerType->customer_id != auth()->user()->customer_id || $EmpWorkerType->workspace_id != auth()->user()->workspace_id)) {
            return $this->message('You do not have access to this Employee Worker', 403);
        }
        $EmpWorkerType->del = '1';
        $EmpWorkerType->save();

        $user = auth()->user();
        if ($userTable == "customer") {
            $data['emp_worker_types'] = EmpWorkerType::where('customer_id', $user->id)
                ->where('workspace_id', $user->current_workspace_id)
                ->where('del', '0')
                ->get();
        } elseif ($userTable == "emp") {
            $data['emp_worker_types'] = EmpWorkerType::where('customer_id', auth()->user()->customer_id)
                ->where('workspace_id', auth()->user()->workspace_id)
                ->where('del', '0')
                ->get();
        }
        return $this->success($data, 'Worker Type Deleted Successfully');
    }
}
