<?php

namespace App\Http\Controllers;

use App\Models\HelpdeskTicketCategories;
use Illuminate\Http\Request;

class HelpdeskTicketCategoriesController extends Controller
{
    //
    public function index(HelpdeskTicketCategories $helpdeskTicketCategories ,Request $request)
    {
        $helpdeskTicketCategories = $helpdeskTicketCategories->latest();
        
        // Add search functionality if search parameter is provided
        if ($request->filled('search')) {
            $search = $request->input('search');
            $helpdeskTicketCategories->where(function($query) use ($search) {
                $query->where('name', 'like', '%' . $search . '%')
                      ->orWhere('color', 'like', '%' . $search . '%');
            });
        }
        
        return $this->withCount($helpdeskTicketCategories, "Helpdesk Ticket Categories retrieved successfully.");
    }
    public function store(Request $request)
    {
       return $this->storeHelpdeskCategory($request);
    }
    public function show($category)
    {
       return $this->showHelpdeskCategory($category);
    }
    public function update(Request $request)
    {
       return $this->updateHelpdeskCategory($request);
    }
    public function destroy($category){
        return $this->destroyHelpdeskCategory($category);
    }
    
    
}
