<?php

namespace App\Http\Controllers\Subcontractor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Controllers\Traits\SubcontractorProjectTaskManagementTrait;

class SubcontractorProjectTaskManagementController extends Controller
{
    use SubcontractorProjectTaskManagementTrait;

    /**
     * Display a listing of project tasks assigned to subcontractor and their employees
     */
    public function index(Request $request)
    {
        return $this->getSubcontractorProjectTasks($request);
    }

    /**
     * Store a newly created project task
     * Subcontractors can create tasks for themselves or their employees
     */
    public function store(Request $request)
    {
        return $this->createSubcontractorProjectTask($request);
    }

    /**
     * Display the specified project task
     */
    public function show(Request $request, $id)
    {
        return $this->getSubcontractorProjectTaskById($request, $id);
    }

    /**
     * Update the specified project task
     */
    public function update(Request $request, $id)
    {
        return $this->updateSubcontractorProjectTask($request, $id);
    }

    /**
     * Upload documents and add comment to project task
     */
    public function uploadDocuments(Request $request)
    {
        return $this->uploadSubcontractorProjectTaskDocuments($request);
    }

    /**
     * Update a project task document (comment or document or both)
     */
    public function updateDocument(Request $request)
    {
        return $this->updateSubcontractorProjectTaskDocument($request);
    }

    /**
     * Delete a project task document
     */
    public function deleteDocument($id)
    {
        return $this->deleteSubcontractorProjectTaskDocument($id);
    }
}

