<?php

namespace App\Http\Controllers;
use App\Models\Tier;
use App\Models\LeavePackage;
use App\Models\TierPackage;
use DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;

class TierPackageController extends Controller
{
    public function index(Request $request)
    {
        $query = TierPackage::query();

        if($request->filled('filter'))
        {
          $query =  $this->filter(json_decode($request->filter, true),$query);
        }
        $query->with('Tier');

        $count = $query->count();
        $start = $request->input('from', 0);
        $query->offset($start)->limit(10);
        $query->orderBy('id', 'desc');
        $query_result = $query->get();

        $data =  [
            'tierpkgs' => $query_result,
        ];
        $array_filter =  json_decode($request->filter, true);
        $filters = [
          'first_name' => $array_filter['first_name'] ?? '', 
          'middle_name' => $array_filter['middle_name'] ?? '',
          'last_name' => $array_filter['first_name'] ?? '',
          'employee_email' => $array_filter['last_name'] ?? '',
          'compeleted' => $array_filter['first_name'] ?? '',
          'status' => $array_filter['compeleted'] ?? '',
        ];

        return response()->json([
            'message' => 'Get Tier Package List Successfully',
            'data' => $data,
            'count' => $count,
            'filters' => $filters
        ],200);
    }
    public function filter($filters,$query)
    {
     
        foreach ($filters as $filterName => $filterValue) {
              if ($filterValue != null ||  $filterValue !="" ) {
                  switch ($filterName) {
                  case 'company':
                    $query->whereHas('company', function ($subquery) use ($filterValue) {
                    $subquery->where('fname', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'title':
                      $query->where('title', 'like', '%' . $filterValue . '%');
                  break;
                  case 'status':
                      $filterValue =   $filterValue ? 1 : 0;
                      $query->where('status', 'like', '%' . $filterValue . '%');
                  break;
                  case 'latitude':
                    $query->where('latitude', 'like', '%' . $filterValue . '%');
                  break;  
                  case 'longitude':
                    $query->where('longitude', 'like', '%' . $filterValue . '%');
                  break;                     
                  case 'area_radius':
                    $query->where('area_radius', 'like', '%' . $filterValue . '%');
                  break; 
                  case 'State':
                    $query->where('State', 'like', '%' . $filterValue . '%');
                  break;                  
                  }
              }
        }

        return $query;
    } 
    public function create(Request $request)
    {
        $tiers = Tier::orderBy('id', 'desc')->get();
        $leavepackages = LeavePackage::orderBy('id', 'desc')->get();
        return view('TierPackage.create',compact('tiers','leavepackages'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'tier_id' => 'required|integer',
            'allowance_package_id' => 'nullable|integer',
        ]);
    
        if ($validator->fails()) {
            $error = $validator->errors()->first();
    
            return response()->json([
                'message' => $error
            ], 422);
        } else {
           
            $tierPackage = new TierPackage;
            $tierPackage->tier_id = $request->input('tier_id');
            $tierPackage->allowance_package_id = $request->input('allowance_package_id');
            $tierPackage->save();

            session()->flash('success', 'Tier Package Saved Successfully');
            $data = TierPackage::all();
            return response()->json([
                'message' => 'Tier Package Saved Successfully',
                'data' => $data
            ], 200);
        }
    }
    

    

    public function edit($id)
    {
        $tiers = Tier::orderBy('id', 'desc')->get();
        $tierpackage = TierPackage::where('id',$id)->first();
        return view('TierPackage.edit', compact('tiers','tierpackage'));
    }

    public function update(Request $request, $id)
{
    $validator = Validator::make($request->all(), [
        'tier_id' => 'required|integer',
        'allowance_package_id' => 'nullable|integer',
    ]);

    if ($validator->fails()) {
        $error = $validator->errors()->first();

        return response()->json([
            'message' =>  $error
        ], 422);
    } else {
       
        $tierPackage = TierPackage::findOrFail($id);
        $tierPackage->tier_id = $request->input('tier_id');
        $tierPackage->allowance_package_id = $request->input('allowance_package_id');

        $tierPackage->save();

        $data = TierPackage::all();
        session()->flash('success', 'Tier Package Updated Successfully');
        return response()->json([
            'message' => 'Tier Package Updated Successfully',
            'data' => $data
        ], 200);
    }
}

    
    
    public function destroy($id)
    {
        TierPackage::where('id',$id)->delete();
        session()->flash('success', 'Tier Package Deleted Successfully');
        return response()->json([
            'message' => 'Tier Package Deleted Successfully'
        ],200);
    }
    
}
