<?php

namespace App\Http\Controllers\Traits;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;

trait SearchTrait
{
    public function searchFilter(Builder $query, Request $request)
    {
        $filters = $request->input('filters', []);
        $pagination = $request->input('pagination', 10);
        $sortOrder = $request->input('sortOrder', 'desc');
        $isCsv = $request->input('csv', false); // Check if CSV download is requested
        foreach ($filters as $column => $value) {
            if (is_array($value)) {
                $query->whereIn($column, $value);
            } else {
                $query->where($column, 'LIKE', "%{$value}%");
            }
        }
        if (!empty($filters)) {
            $sortColumn = key($filters);
            $query->orderBy($sortColumn, $sortOrder);
        }
        if ($isCsv) {
            return $this->generateCsvFromQuery($query);
        }
        $paginated = $query->paginate($pagination);
        
        // Add custom pagination attributes
        $paginated->appends($request->query());
        
        // Convert to array and add custom attributes
        $data = $paginated->toArray();
        
        // Add custom pagination attributes
        $data['first_page_url'] = $paginated->url(1);
        $data['last_page_url'] = $paginated->url($paginated->lastPage());
        $data['next_page_url'] = $paginated->nextPageUrl();
        $data['prev_page_url'] = $paginated->previousPageUrl();
        $data['from'] = $paginated->firstItem();
        $data['to'] = $paginated->lastItem();
        return $this->success($data, "Data retrieved successfully.");
    }
    public function searchFilterRecord(Builder $query, Request $request)
    {
        $filters = $request->input('filters', []);
        $pagination = $request->input('pagination', 10);
        $sortOrder = $request->input('sortOrder', 'desc');
        $isCsv = $request->input('csv', false); // Check if CSV download is requested
        
        foreach ($filters as $column => $value) {
            if (is_array($value)) {
                $query->whereIn($column, $value);
            } else {
                $query->where($column, 'LIKE', "%{$value}%");
            }
        }
        
        if (!empty($filters)) {
            $sortColumn = key($filters);
            $query->orderBy($sortColumn, $sortOrder);
        }else{
            $query->orderBy('id', 'desc');
        }
        
        if ($isCsv) {
            return $this->generateCsvFromQuery($query);
        }
        
        // Return only the paginated users, not the full response
        $paginated = $query->paginate($pagination);
        $paginated->appends($request->query());
        return $paginated;
    }
    public function searchFilterRecordPost(Builder $query, Request $request)
    {
        $filters = $request->input('filters', []);
        $pagination = $request->input('pagination', 10);
        $sortOrder = $request->input('sortOrder', 'desc');
        $isCsv = $request->input('csv', false); // Check if CSV download is requested
        
        foreach ($filters as $column => $value) {
            if (is_array($value)) {
                $query->whereIn($column, $value);
            } else {
                $query->where($column, 'LIKE', "%{$value}%");
            }
        }
        
        if (!empty($filters)) {
            $sortColumn = key($filters);
            $query->orderBy($sortColumn, $sortOrder);
        }
        
        if ($isCsv) {
            return $this->generateCsvFromQuery($query);
        }
        
        // Return only the paginated users, not the full response
        $paginated = $query->paginate($pagination);
        // dd($request->all('pagination'));
        $paginated->appends($request->all('pagination'));
        return $paginated;
    }
}
