<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class EmployeeSubcontractorMeta extends BaseModel
{
    use HasFactory;

    protected $table = 'employees_subcontractors_metas';

    protected $fillable = [
        'emp_id',
        'subcontractor_id',
        'company_id',
        'project_ids',
        'active',
    ];

    protected $casts = [
        'project_ids' => 'array',
        'active' => 'boolean',
    ];

    /**
     * Get the employee that owns this association.
     */
    public function employee()
    {
        return $this->belongsTo(EmployeeSubcontractor::class, 'emp_id');
    }

    /**
     * Get the subcontractor (user) that owns this association.
     */
    public function subcontractor()
    {
        return $this->belongsTo(User::class, 'subcontractor_id');
    }
}

