<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class FAQItem extends BaseModel
{
    use HasFactory;

    protected $table = 'faq_items';

    protected $fillable = [
        'faq_id',
        'question',
        'answer',
        'sort_order',
        'status'
    ];

    protected $casts = [
        'status' => 'boolean',
        'sort_order' => 'integer',
    ];

    /**
     * Scope to get active FAQ items
     */
    public function scopeActive($query)
    {
        return $query->where('status', 1);
    }

    /**
     * Scope to get inactive FAQ items
     */
    public function scopeInactive($query)
    {
        return $query->where('status', 0);
    }

    /**
     * Scope to order by sort order
     */
    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order', 'asc')->orderBy('created_at', 'asc');
    }

    /**
     * Check if FAQ item is active
     */
    public function isActive()
    {
        return $this->status == 1;
    }

    /**
     * Check if FAQ item is inactive
     */
    public function isInactive()
    {
        return $this->status == 0;
    }

    /**
     * Get the FAQ group that this item belongs to
     */
    public function faq()
    {
        return $this->belongsTo(FAQ::class, 'faq_id', 'id');
    }
}