<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentFinalClassification extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_final_classifications';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'final_incident_name',
        'final_incident_details',
        'is_rehabilitation',
        'return_to_duty_date',
        'rtw_date',
        'total_lost_days',
        'is_worker_notified',
        'notified_by_whom',
        'date',
        'time',
        'details'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function notifiedBy()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'notified_by_whom');
    }
}
