<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentReportedTo extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_reported_tos';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'reported_to',
        'company_name',
        'position',
        'contact_number'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }

    public function reportedToEmployee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'reported_to' , 'emp_id');
    }

    public function positionDetail()
    {
        return $this->belongsTo(Role::class, 'position' ,'id');
    }
}
