<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IncidentSignoff extends BaseModel
{
    use HasFactory;

    protected $table = 'incident_signoffs';

    // Define fillable fields
    protected $fillable = [
        'incident_report_id',
        'role_code',
        'emp_id',
        'is_site_employee',
        'name',
        'signature',
        'date',
        'time'
    ];

    // Define relationships
    public function incidentReport()
    {
        return $this->belongsTo(IncidentReport::class, 'incident_report_id');
    }



    public function employee()
    {
        return $this->hasOneThrough(
            EmpPersonalDetails::class,
            EmpCompanyDetails::class,
            'id', // Foreign key on EmpCompanyDetails table
            'emp_id', // Foreign key on EmpPersonalDetails table
            'emp_id', // Local key on IncidentSignoff table
            'id' // Local key on EmpCompanyDetails table
        );
    }

    /**
     * Company details related to the employee who signed off
     */
    public function companyDetails()
    {
        return $this->belongsTo(EmpCompanyDetails::class, 'emp_id', 'id');
    }
}
