<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InspectionPlanMeta extends BaseModel
{
    use HasFactory;
    protected $guarded=[''];
    protected $fillable = [
        'inspection_plan_id',
        'itpc_id',
        'name',
        'title',
        'value',
        'is_table',
        'customer_id',
        'workspace_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    
    public function inspection_plan_checklist()
    {
        return $this->belongsTo(InspectionPlanChecklist::class, 'itpc_id', 'id');
    }

    public function inspection_plan()
    {
        return $this->belongsTo(InspectionPlan::class, 'inspection_plan_id', 'id');
    }

}
