<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingDocumentSetting extends BaseModel
{
    use HasFactory;
    protected $guarded =[''];


    protected $fillable = [
        'customer_id',
        'workspace_id',
        'title',
        'description',
        'type_of_setting',
        'del',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    
    public function check_status()
    {
        return $this->hasOne(MeetingDocumentNoteCheckpoint::class, 'meeting_seeting_id', 'id');
    }
}
