<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingNoteDocumentsPdf extends BaseModel
{
    use HasFactory;
    
    protected $fillable = [
        'meeting_id',
        'meeting_note_id',
        'document_path',
        'title',
        'meeting_date',
        'uploaded_by',
        'status',
        'is_signed',
        'type',
        'type_of_setting',
    ];

    public function employee_signed_document()
    {
        return $this->hasMany(EmployeeSignedDocument::class,'document_id','id');
    }

    public function meeting_note_signatures()
    {
        return $this->hasMany(MeetingNoteSignature::class,'employee_note_id','id')->with('employee');
    }

    public function meeting()
    {
        return $this->belongsTo(Meeting::class,'meeting_id','id');
    }

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'uploaded_by','emp_id')->select('id','emp_id','first_name','middle_name','last_name','image');
    }
}
