<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\EmployeeSubcontractor;

class MeetingUser extends BaseModel
{
    use HasFactory;

    protected $fillable =[
        'meeting_id',
        'site_id',
        'employee_id',
        'user_type',
    ];

    public function meeting_employees()
    {
        return $this->hasOne(EmpPersonalDetails::class,'emp_id','employee_id')->select('id','emp_id','first_name','middle_name','last_name','image');
    }

    public function meeting_subcontractor_employees()
    {
        return $this->hasOne(EmployeeSubcontractor::class,'id','employee_id')->select('id','first_name','middle_name','last_name','email','profile_image');
    }

    public function meeting_attendances()
    {
        return $this->hasMany(MeetingAttendance::class,'meeting_id','id');
    }
}
