<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RequiredDocumentField extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'doc_id',
        'field_type',
        'field_name',
        'field_required',
        'status',
        'priority',
        'del'
    ];

    protected $appends = ['hasData'];

    public function empDocuments()
    {
        return $this->hasMany(EmpDocuments::class, 'required_document_field', 'id');
    }

    public function requiredDocument()
    {
        return $this->belongsTo(RequiredDocument::class, 'doc_id', 'id');
    }

    public function getHasDataAttribute()
    {
        return $this->empDocuments()->count();
    }

} 
