<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasManyThrough;

class Tier extends BaseModel
{
    use HasFactory;

    protected $fillable = [
        'title',
        'tier_key',
        'description',
        'workspace_id',
        'customer_id',
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];


    public function companyDetails()
    {
        return $this->hasMany(EmpCompanyDetails::class)->with('tierEmpPersonalDetail')->where('del',0)->select('id','tier_id');
    }

     public function tierEmployeesData()
    {
        return $this->hasMany(EmpCompanyDetails::class)->with('empPersonalDetails');
    }
}
