<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Trade extends BaseModel
{
    use HasFactory;

    protected $table = 'trades';

    protected $fillable = [
        'title',
        'del'
    ];

    /**
     * Get the subcontractor companies that use this trade.
     */
    public function subcontractorCompanies()
    {
        return $this->hasMany(SubcontractorCompany::class, 'trade_id');
    }
}

