<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class WHSQECustomerSelectedSettings extends BaseModel
{
    use HasFactory;

    protected $table = 'whsqe_customer_selected_settings';

    protected $fillable = [
        'whsq_report_id',
        'customer_id',
        'workspace_id',
        'parent_id',
        'child_id',
        'grandchild_id',
        'is_selected',
        'sort_order',
        'level'
    ];

    protected $casts = [
        'is_selected' => 'boolean',
        'sort_order' => 'integer'
    ];

    protected $hidden = ['customer_id', 'workspace_id'];


    /**
     * Scope to filter by report
     */
    public function byReport($query, $reportId)
    {
        return $query->where('whsq_report_id', $reportId);
    }

    /**
     * Scope to filter by selected status
     */
    public function selected($query)
    {
        return $query->where('is_selected', true);
    }

    /**
     * Scope to filter active records (not deleted)
     */
    public function active($query)
    {
        return $query->where('deleted_at', 0);
    }

    /**
     * Get the WHSQ report this setting belongs to
     */
    public function whsqReport()
    {
        return $this->belongsTo(WhsqReport::class, 'whsq_report_id');
    }

    /**
     * Get the parent content
     */
    public function parentContent()
    {
        return $this->belongsTo(WHSQE_TableOfContent::class, 'parent_id');
    }

    /**
     * Get the child content
     */
    public function childContent()
    {
        return $this->belongsTo(WHSQE_TableOfContentChild::class, 'child_id', 'id');
    }

    /**
     * Get the grandchild content
     */
    public function grandchildContent()
    {
        return $this->belongsTo(WHSQE_TableOfContentGrandChild::class, 'grandchild_id');
    }

    /**
     * Get the full setting path (parent > child > grandchild)
     */
    public function getSettingPathAttribute()
    {
        $path = [];
        
        if ($this->parentContent) {
            $path[] = $this->parentContent->title;
        }
        
        if ($this->childContent) {
            $path[] = $this->childContent->title;
        }
        
        if ($this->grandchildContent) {
            $path[] = $this->grandchildContent->title;
        }
        
        return implode(' > ', $path);
    }
} 