<?php

namespace App\Models;

class WHSQEReportLog extends BaseModel
{
    protected $table = 'whsqe_report_logs';

    protected $fillable = [
        'report_id',
        'employee_id',
        'action_type',
        'step_number',
        'message',
        'changes',
        'customer_id',
        'workspace_id'
    ];

    protected $casts = [
        'changes' => 'array'
    ];

    protected $hidden = [
        'customer_id',
        'workspace_id',
    ];
    
    public function getCasts()
    {
        // Get the parent casts (which includes BaseModel's automatic date detection)
        $parentCasts = parent::getCasts();
        
        // Override with our explicit casts to ensure timestamps are treated as datetime
        $ourCasts = [
            'created_at' => 'datetime',
            'updated_at' => 'datetime'
        ];
        
        // Merge our casts last so they override any automatic casting
        return array_merge($parentCasts, $ourCasts);
    }
    public function report()
    {
        return $this->belongsTo(WhsqReport::class, 'report_id');
    }

    public function employee()
    {
        return $this->belongsTo(EmpPersonalDetails::class, 'employee_id', 'emp_id');
    }

    public function customer()
    {
        return $this->belongsTo(User::class, 'customer_id', 'id');
    }
} 